/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle;

import io.objectbox.gradle.ObjectBoxPluginExtension;
import io.objectbox.logging.Logging;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060.J\u000e\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0006R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u000e\u0010 \u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\bR\u000e\u0010(\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00062"}, d2={"Lio/objectbox/gradle/ProjectEnv;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configAndroidTestImplOrCompile", "", "getConfigAndroidTestImplOrCompile", "()Ljava/lang/String;", "configAndroidTestImplOrCompile$delegate", "Lkotlin/Lazy;", "configApiOrImplOrCompile", "getConfigApiOrImplOrCompile", "configApiOrImplOrCompile$delegate", "configTestImplOrCompile", "getConfigTestImplOrCompile", "configTestImplOrCompile$delegate", "hasAndroidPlugin", "", "getHasAndroidPlugin", "()Z", "hasJavaPlugin", "getHasJavaPlugin", "hasKotlinAndroidPlugin", "getHasKotlinAndroidPlugin", "hasKotlinPlugin", "getHasKotlinPlugin", "is64Bit", "isLinux", "isLinux64", "isMac", "isMac64", "isWindows", "isWindows64", "options", "Lio/objectbox/gradle/ObjectBoxPluginExtension;", "getOptions", "()Lio/objectbox/gradle/ObjectBoxPluginExtension;", "osName", "getOsName", "osNameLowerCase", "getProject", "()Lorg/gradle/api/Project;", "logDebug", "", "message", "Lkotlin/Function0;", "logInfo", "msg", "Const", "objectbox-gradle-plugin"})
public final class ProjectEnv {
    @NotNull
    private final Project project;
    @NotNull
    private final ObjectBoxPluginExtension options;
    private final boolean hasAndroidPlugin;
    private final boolean hasKotlinAndroidPlugin;
    private final boolean hasKotlinPlugin;
    private final boolean hasJavaPlugin;
    @NotNull
    private final String osName;
    private final boolean is64Bit;
    @NotNull
    private final String osNameLowerCase;
    private final boolean isLinux;
    private final boolean isMac;
    private final boolean isWindows;
    private final boolean isLinux64;
    private final boolean isMac64;
    private final boolean isWindows64;
    @NotNull
    private final Lazy configApiOrImplOrCompile$delegate;
    @NotNull
    private final Lazy configAndroidTestImplOrCompile$delegate;
    @NotNull
    private final Lazy configTestImplOrCompile$delegate;

    public ProjectEnv(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object object = this.project.getExtensions().create("objectbox", ObjectBoxPluginExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ginExtension::class.java)");
        this.options = (ObjectBoxPluginExtension)object;
        this.hasAndroidPlugin = this.project.getPlugins().hasPlugin("com.android.base");
        this.hasKotlinAndroidPlugin = this.project.getPlugins().hasPlugin("kotlin-android");
        this.hasKotlinPlugin = this.project.getPlugins().hasPlugin("kotlin");
        this.hasJavaPlugin = this.project.getPlugins().hasPlugin(JavaPlugin.class);
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        this.osName = string;
        this.is64Bit = Intrinsics.areEqual((Object)System.getProperty("sun.arch.data.model"), (Object)"64");
        String string2 = this.osName;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        this.osNameLowerCase = string3;
        this.isLinux = StringsKt.contains$default((CharSequence)this.osNameLowerCase, (CharSequence)"linux", (boolean)false, (int)2, null);
        this.isMac = StringsKt.contains$default((CharSequence)this.osNameLowerCase, (CharSequence)"mac", (boolean)false, (int)2, null);
        this.isWindows = StringsKt.contains$default((CharSequence)this.osNameLowerCase, (CharSequence)"windows", (boolean)false, (int)2, null);
        this.isLinux64 = this.isLinux && this.is64Bit;
        this.isMac64 = this.isMac && this.is64Bit;
        this.isWindows64 = this.isWindows && this.is64Bit;
        this.configApiOrImplOrCompile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ProjectEnv this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getProject().getConfigurations().findByName("api") != null ? "api" : (this.this$0.getProject().getConfigurations().findByName("implementation") != null ? "implementation" : "compile");
            }
        }));
        this.configAndroidTestImplOrCompile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ProjectEnv this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getProject().getConfigurations().findByName("androidTestImplementation") != null ? "androidTestImplementation" : "androidTestCompile";
            }
        }));
        this.configTestImplOrCompile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ProjectEnv this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getProject().getConfigurations().findByName("testImplementation") != null ? "testImplementation" : "testCompile";
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ObjectBoxPluginExtension getOptions() {
        return this.options;
    }

    public final boolean getHasAndroidPlugin() {
        return this.hasAndroidPlugin;
    }

    public final boolean getHasKotlinAndroidPlugin() {
        return this.hasKotlinAndroidPlugin;
    }

    public final boolean getHasKotlinPlugin() {
        return this.hasKotlinPlugin;
    }

    public final boolean getHasJavaPlugin() {
        return this.hasJavaPlugin;
    }

    @NotNull
    public final String getOsName() {
        return this.osName;
    }

    public final boolean is64Bit() {
        return this.is64Bit;
    }

    public final boolean isLinux64() {
        return this.isLinux64;
    }

    public final boolean isMac64() {
        return this.isMac64;
    }

    public final boolean isWindows64() {
        return this.isWindows64;
    }

    @NotNull
    public final String getConfigApiOrImplOrCompile() {
        Lazy lazy = this.configApiOrImplOrCompile$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getConfigAndroidTestImplOrCompile() {
        Lazy lazy = this.configAndroidTestImplOrCompile$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getConfigTestImplOrCompile() {
        Lazy lazy = this.configTestImplOrCompile$delegate;
        return (String)lazy.getValue();
    }

    public final void logInfo(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.project.getLogger().info(msg);
    }

    public final void logDebug(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.project.afterEvaluate(arg_0 -> ProjectEnv.logDebug$lambda$0((Function1)new Function1<Project, Unit>(this, message){
            final /* synthetic */ ProjectEnv this$0;
            final /* synthetic */ Function0<String> $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            public final void invoke(Project it) {
                Object object = this.this$0.getOptions().getDebug().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"options.debug.get()");
                if (((Boolean)object).booleanValue()) {
                    Logging.log((String)((String)this.$message.invoke()));
                }
            }
        }, arg_0));
    }

    private static final void logDebug$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/objectbox/gradle/ProjectEnv$Const;", "", "()V", "javaVersionToApply", "", "name", "nativeSyncVersionToApply", "nativeVersionToApply", "pluginVersion", "objectbox-gradle-plugin"})
    public static final class Const {
        @NotNull
        public static final Const INSTANCE = new Const();
        @NotNull
        public static final String name = "objectbox";
        @NotNull
        public static final String pluginVersion = "3.8.0";
        @NotNull
        public static final String javaVersionToApply = "3.8.0";
        @NotNull
        public static final String nativeVersionToApply = "3.8.0";
        @NotNull
        public static final String nativeSyncVersionToApply = "3.8.0";

        private Const() {
        }
    }
}

