/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync.server;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.server.PeerInfo;
import io.objectbox.sync.server.SyncServer;
import io.objectbox.sync.server.SyncServerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Experimental
public class SyncServerBuilder {
    final BoxStore boxStore;
    final String url;
    final List<SyncCredentials> credentials = new ArrayList<SyncCredentials>();
    final List<PeerInfo> peers = new ArrayList<PeerInfo>();
    @Nullable
    String certificatePath;
    SyncChangeListener changeListener;

    public SyncServerBuilder(BoxStore boxStore, String url, SyncCredentials authenticatorCredentials) {
        this.checkNotNull(boxStore, "BoxStore is required.");
        this.checkNotNull(url, "Sync server URL is required.");
        this.checkNotNull(authenticatorCredentials, "Authenticator credentials are required.");
        if (!BoxStore.isSyncServerAvailable()) {
            throw new IllegalStateException("This library does not include ObjectBox Sync Server. Please visit https://objectbox.io/sync/ for options.");
        }
        this.boxStore = boxStore;
        this.url = url;
        this.authenticatorCredentials(authenticatorCredentials);
    }

    public SyncServerBuilder certificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    public SyncServerBuilder authenticatorCredentials(SyncCredentials authenticatorCredentials) {
        this.checkNotNull(authenticatorCredentials, "Authenticator credentials must not be null.");
        this.credentials.add(authenticatorCredentials);
        return this;
    }

    public SyncServerBuilder changeListener(SyncChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SyncServerBuilder peer(String url) {
        return this.peer(url, SyncCredentials.none());
    }

    public SyncServerBuilder peer(String url, SyncCredentials credentials) {
        this.peers.add(new PeerInfo(url, credentials));
        return this;
    }

    public SyncServer build() {
        if (this.credentials.isEmpty()) {
            throw new IllegalStateException("At least one authenticator is required.");
        }
        return new SyncServerImpl(this);
    }

    public SyncServer buildAndStart() {
        SyncServer syncServer = this.build();
        syncServer.start();
        return syncServer;
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

