/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataPublisherUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.greenrobot.essentials.collections.MultimapSet;

@Internal
class ObjectClassPublisher
implements DataPublisher<Class>,
Runnable {
    final BoxStore boxStore;
    final MultimapSet<Integer, DataObserver<Class>> observersByEntityTypeId = MultimapSet.create((MultimapSet.SetType)MultimapSet.SetType.THREAD_SAFE);
    private final Deque<PublishRequest> changesQueue = new ArrayDeque<PublishRequest>();
    volatile boolean changePublisherRunning;

    ObjectClassPublisher(BoxStore boxStore) {
        this.boxStore = boxStore;
    }

    @Override
    public void subscribe(DataObserver<Class> observer, @Nullable Object forClass) {
        if (forClass == null) {
            for (int entityTypeId : this.boxStore.getAllEntityTypeIds()) {
                this.observersByEntityTypeId.putElement((Object)entityTypeId, observer);
            }
        } else {
            int entityTypeId = this.boxStore.getEntityTypeIdOrThrow((Class)forClass);
            this.observersByEntityTypeId.putElement((Object)entityTypeId, observer);
        }
    }

    @Override
    public void unsubscribe(DataObserver<Class> observer, @Nullable Object forClass) {
        if (forClass != null) {
            int entityTypeId = this.boxStore.getEntityTypeIdOrThrow((Class)forClass);
            this.unsubscribe(observer, entityTypeId);
        } else {
            for (int entityTypeId : this.boxStore.getAllEntityTypeIds()) {
                this.unsubscribe(observer, entityTypeId);
            }
        }
    }

    private void unsubscribe(DataObserver<Class> observer, int entityTypeId) {
        Set observers = (Set)this.observersByEntityTypeId.get((Object)entityTypeId);
        DataPublisherUtils.removeObserverFromCopyOnWriteSet(observers, observer);
    }

    @Override
    public void publishSingle(DataObserver<Class> observer, @Nullable Object forClass) {
        int[] nArray;
        if (forClass != null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.boxStore.getEntityTypeIdOrThrow((Class)forClass);
        } else {
            nArray = this.boxStore.getAllEntityTypeIds();
        }
        int[] entityTypeIds = nArray;
        this.queuePublishRequestAndScheduleRun(observer, entityTypeIds);
    }

    void publish(int[] entityTypeIdsAffected) {
        this.queuePublishRequestAndScheduleRun(null, entityTypeIdsAffected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuePublishRequestAndScheduleRun(@Nullable DataObserver<Class> observer, int[] entityTypeIds) {
        Deque<PublishRequest> deque = this.changesQueue;
        synchronized (deque) {
            this.changesQueue.add(new PublishRequest(observer, entityTypeIds));
            if (!this.changePublisherRunning) {
                this.changePublisherRunning = true;
                this.boxStore.internalScheduleThread(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block8: while (true) {
                PublishRequest request;
                Object object = this.changesQueue;
                synchronized (object) {
                    request = this.changesQueue.pollFirst();
                    if (request == null) {
                        this.changePublisherRunning = false;
                        break;
                    }
                }
                object = request.entityTypeIds;
                int n = ((Object)object).length;
                int n2 = 0;
                while (true) {
                    List<DataObserver> observers;
                    if (n2 >= n) continue block8;
                    Object entityTypeId = object[n2];
                    Collection<DataObserver<Object>> collection = observers = request.observer != null ? Collections.singletonList(request.observer) : this.observersByEntityTypeId.get((Object)((int)entityTypeId));
                    if (observers != null && !observers.isEmpty()) {
                        Class<?> entityClass = this.boxStore.getEntityClassOrThrow((int)entityTypeId);
                        try {
                            for (DataObserver observer : observers) {
                                observer.onData(entityClass);
                            }
                        }
                        catch (RuntimeException e) {
                            this.handleObserverException(entityClass);
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
        finally {
            this.changePublisherRunning = false;
        }
    }

    private void handleObserverException(Class objectClass) {
        RuntimeException newEx = new RuntimeException("Observer failed while processing data for " + objectClass + ". Consider using an ErrorObserver");
        newEx.printStackTrace();
        throw newEx;
    }

    private static class PublishRequest {
        @Nullable
        private final DataObserver<Class> observer;
        private final int[] entityTypeIds;

        PublishRequest(@Nullable DataObserver<Class> observer, int[] entityTypeIds) {
            this.observer = observer;
            this.entityTypeIds = entityTypeIds;
        }
    }
}

