/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.converter;

import io.objectbox.converter.PropertyConverter;
import io.objectbox.flatbuffers.ArrayReadWriteBuf;
import io.objectbox.flatbuffers.FlexBuffers;
import io.objectbox.flatbuffers.FlexBuffersBuilder;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class FlexObjectConverter
implements PropertyConverter<Object, byte[]> {
    private static final AtomicReference<FlexBuffersBuilder> cachedBuilder = new AtomicReference();

    public byte[] convertToDatabaseValue(Object value) {
        if (value == null) {
            return null;
        }
        FlexBuffersBuilder builder = cachedBuilder.getAndSet(null);
        if (builder == null) {
            builder = new FlexBuffersBuilder(new ArrayReadWriteBuf(512), 3);
        }
        this.addValue(builder, value);
        ByteBuffer buffer = builder.finish();
        byte[] out = new byte[buffer.limit()];
        buffer.get(out);
        if (buffer.limit() <= 262144) {
            builder.clear();
            cachedBuilder.getAndSet(builder);
        }
        return out;
    }

    private void addValue(FlexBuffersBuilder builder, Object value) {
        if (value instanceof Map) {
            this.addMap(builder, null, (Map)value);
        } else if (value instanceof List) {
            this.addVector(builder, null, (List)value);
        } else if (value instanceof String) {
            builder.putString((String)value);
        } else if (value instanceof Boolean) {
            builder.putBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            builder.putInt(((Byte)value).intValue());
        } else if (value instanceof Short) {
            builder.putInt(((Short)value).intValue());
        } else if (value instanceof Integer) {
            builder.putInt((Integer)value);
        } else if (value instanceof Long) {
            builder.putInt((Long)value);
        } else if (value instanceof Float) {
            builder.putFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            builder.putFloat((Double)value);
        } else if (value instanceof byte[]) {
            builder.putBlob((byte[])value);
        } else {
            throw new IllegalArgumentException("Values of this type are not supported: " + value.getClass().getSimpleName());
        }
    }

    protected void checkMapKeyType(Object rawKey) {
        if (!(rawKey instanceof String)) {
            throw new IllegalArgumentException("Map keys must be String");
        }
    }

    private void addMap(FlexBuffersBuilder builder, String mapKey, Map<Object, Object> map) {
        int mapStart = builder.startMap();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object rawKey = entry.getKey();
            Object value = entry.getValue();
            if (rawKey == null || value == null) {
                throw new IllegalArgumentException("Map keys or values must not be null");
            }
            this.checkMapKeyType(rawKey);
            String key = rawKey.toString();
            if (value instanceof Map) {
                this.addMap(builder, key, (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.addVector(builder, key, (List)value);
                continue;
            }
            if (value instanceof String) {
                builder.putString(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                builder.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof Byte) {
                builder.putInt(key, ((Byte)value).intValue());
                continue;
            }
            if (value instanceof Short) {
                builder.putInt(key, ((Short)value).intValue());
                continue;
            }
            if (value instanceof Integer) {
                builder.putInt(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                builder.putInt(key, (Long)value);
                continue;
            }
            if (value instanceof Float) {
                builder.putFloat(key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                builder.putFloat(key, (Double)value);
                continue;
            }
            if (value instanceof byte[]) {
                builder.putBlob(key, (byte[])value);
                continue;
            }
            throw new IllegalArgumentException("Map values of this type are not supported: " + value.getClass().getSimpleName());
        }
        builder.endMap(mapKey, mapStart);
    }

    private void addVector(FlexBuffersBuilder builder, String vectorKey, List<Object> list) {
        int vectorStart = builder.startVector();
        for (Object item : list) {
            if (item == null) {
                throw new IllegalArgumentException("List elements must not be null");
            }
            if (item instanceof Map) {
                this.addMap(builder, null, (Map)item);
                continue;
            }
            if (item instanceof List) {
                this.addVector(builder, null, (List)item);
                continue;
            }
            if (item instanceof String) {
                builder.putString((String)item);
                continue;
            }
            if (item instanceof Boolean) {
                builder.putBoolean((Boolean)item);
                continue;
            }
            if (item instanceof Byte) {
                builder.putInt(((Byte)item).intValue());
                continue;
            }
            if (item instanceof Short) {
                builder.putInt(((Short)item).intValue());
                continue;
            }
            if (item instanceof Integer) {
                builder.putInt((Integer)item);
                continue;
            }
            if (item instanceof Long) {
                builder.putInt((Long)item);
                continue;
            }
            if (item instanceof Float) {
                builder.putFloat(((Float)item).floatValue());
                continue;
            }
            if (item instanceof Double) {
                builder.putFloat((Double)item);
                continue;
            }
            if (item instanceof byte[]) {
                builder.putBlob((byte[])item);
                continue;
            }
            throw new IllegalArgumentException("List values of this type are not supported: " + item.getClass().getSimpleName());
        }
        builder.endVector(vectorKey, vectorStart, false, false);
    }

    public Object convertToEntityProperty(byte[] databaseValue) {
        if (databaseValue == null) {
            return null;
        }
        FlexBuffers.Reference value = FlexBuffers.getRoot(new ArrayReadWriteBuf(databaseValue, databaseValue.length));
        if (value.isMap()) {
            return this.buildMap(value.asMap());
        }
        if (value.isVector()) {
            return this.buildList(value.asVector());
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isInt()) {
            if (this.shouldRestoreAsLong(value)) {
                return value.asLong();
            }
            return value.asInt();
        }
        if (value.isFloat()) {
            return value.asFloat();
        }
        if (value.isBlob()) {
            return value.asBlob().getBytes();
        }
        throw new IllegalArgumentException("FlexBuffers type is not supported: " + value.getType());
    }

    Object convertToKey(String keyValue) {
        return keyValue;
    }

    protected boolean shouldRestoreAsLong(FlexBuffers.Reference reference) {
        try {
            Field parentWidthF = reference.getClass().getDeclaredField("parentWidth");
            parentWidthF.setAccessible(true);
            return (Integer)parentWidthF.get(reference) == 8;
        }
        catch (Exception e) {
            throw new RuntimeException("FlexMapConverter could not determine FlexBuffers integer bit width.", e);
        }
    }

    private Map<Object, Object> buildMap(FlexBuffers.Map map) {
        int entryCount = map.size();
        FlexBuffers.KeyVector keys = map.keys();
        FlexBuffers.Vector values = map.values();
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>((int)((double)entryCount / 0.75 + 1.0));
        for (int i = 0; i < entryCount; ++i) {
            String rawKey = keys.get(i).toString();
            Object key = this.convertToKey(rawKey);
            FlexBuffers.Reference value = values.get(i);
            if (value.isMap()) {
                resultMap.put(key, this.buildMap(value.asMap()));
                continue;
            }
            if (value.isVector()) {
                resultMap.put(key, this.buildList(value.asVector()));
                continue;
            }
            if (value.isString()) {
                resultMap.put(key, value.asString());
                continue;
            }
            if (value.isBoolean()) {
                resultMap.put(key, value.asBoolean());
                continue;
            }
            if (value.isInt()) {
                if (this.shouldRestoreAsLong(value)) {
                    resultMap.put(key, value.asLong());
                    continue;
                }
                resultMap.put(key, value.asInt());
                continue;
            }
            if (value.isFloat()) {
                resultMap.put(key, value.asFloat());
                continue;
            }
            if (value.isBlob()) {
                resultMap.put(key, value.asBlob().getBytes());
                continue;
            }
            throw new IllegalArgumentException("Map values of this type are not supported: " + value.getClass().getSimpleName());
        }
        return resultMap;
    }

    private List<Object> buildList(FlexBuffers.Vector vector) {
        int itemCount = vector.size();
        ArrayList<Object> list = new ArrayList<Object>(itemCount);
        Boolean shouldRestoreAsLong = null;
        for (int i = 0; i < itemCount; ++i) {
            FlexBuffers.Reference item = vector.get(i);
            if (item.isMap()) {
                list.add(this.buildMap(item.asMap()));
                continue;
            }
            if (item.isVector()) {
                list.add(this.buildList(item.asVector()));
                continue;
            }
            if (item.isString()) {
                list.add(item.asString());
                continue;
            }
            if (item.isBoolean()) {
                list.add(item.asBoolean());
                continue;
            }
            if (item.isInt()) {
                if (shouldRestoreAsLong == null) {
                    shouldRestoreAsLong = this.shouldRestoreAsLong(item);
                }
                if (shouldRestoreAsLong.booleanValue()) {
                    list.add(item.asLong());
                    continue;
                }
                list.add(item.asInt());
                continue;
            }
            if (item.isFloat()) {
                list.add(item.asFloat());
                continue;
            }
            if (item.isBlob()) {
                list.add(item.asBlob().getBytes());
                continue;
            }
            throw new IllegalArgumentException("List values of this type are not supported: " + item.getClass().getSimpleName());
        }
        return list;
    }
}

