/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.tree;

import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.tree.LeafNode;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

@Experimental
public class Leaf {
    private final LeafNode node;

    public Leaf(LeafNode node) {
        this.node = node;
    }

    public long getId() {
        return this.node.id;
    }

    public long getParentBranchId() {
        return this.node.branchId;
    }

    public long getMetaId() {
        return this.node.metaId;
    }

    public short getValueType() {
        return this.node.valueType;
    }

    public boolean isInt() {
        return this.node.valueType == 6;
    }

    public boolean isDouble() {
        return this.node.valueType == 8;
    }

    public boolean isString() {
        return this.node.valueType == 23;
    }

    public boolean isStringArray() {
        return this.node.valueType == 24;
    }

    private void verifyIsInt() {
        if (!this.isInt()) {
            throw new IllegalStateException("value is not integer (" + this.node.valueType + ")");
        }
    }

    private void verifyIsDouble() {
        if (!this.isDouble()) {
            throw new IllegalStateException("value is not floating point (" + this.node.valueType + ")");
        }
    }

    private void verifyIsString() {
        if (!this.isString()) {
            throw new IllegalStateException("value is not string (" + this.node.valueType + ")");
        }
    }

    private void verifyIsStringArray() {
        if (!this.isStringArray()) {
            throw new IllegalStateException("value is not string array");
        }
    }

    public long getInt() {
        this.verifyIsInt();
        return this.node.integerValue;
    }

    public double getDouble() {
        this.verifyIsDouble();
        return this.node.floatingValue;
    }

    @Nullable
    public String getString() {
        this.verifyIsString();
        if (this.node.objectValue instanceof String) {
            return (String)this.node.objectValue;
        }
        byte[] bytes = (byte[])this.node.objectValue;
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Nullable
    public String[] getStringArray() {
        this.verifyIsStringArray();
        return (String[])this.node.objectValue;
    }

    @Nullable
    public Long asInt() {
        if (this.isInt()) {
            return this.getInt();
        }
        if (this.isDouble()) {
            return (long)this.getDouble();
        }
        if (this.isString()) {
            String value = this.getString();
            try {
                return value != null ? Long.valueOf(value) : null;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public Double asDouble() {
        if (this.isDouble()) {
            return this.getDouble();
        }
        if (this.isInt()) {
            return this.getInt();
        }
        if (this.isString()) {
            String value = this.getString();
            try {
                return value != null ? Double.valueOf(value) : null;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public String asString() {
        if (this.isString()) {
            return this.getString();
        }
        if (this.isInt()) {
            return String.valueOf(this.getInt());
        }
        if (this.isDouble()) {
            return String.valueOf(this.getDouble());
        }
        if (this.isStringArray()) {
            CharSequence[] value = this.getStringArray();
            if (value == null) {
                return null;
            }
            return String.join((CharSequence)", ", value);
        }
        return null;
    }

    @Nullable
    public String[] asStringArray() {
        String[] stringArray;
        if (this.isStringArray()) {
            return this.getStringArray();
        }
        String value = this.asString();
        if (value != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public void setInt(long value) {
        this.verifyIsInt();
        this.node.integerValue = value;
    }

    public void setDouble(double value) {
        this.verifyIsDouble();
        this.node.floatingValue = value;
    }

    public void setString(@Nullable String value) {
        this.verifyIsString();
        this.node.objectValue = value;
    }

    public void setStringArray(@Nullable String[] value) {
        this.verifyIsStringArray();
        this.node.objectValue = value;
    }
}

