/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.Box;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.EntityInfo;
import io.objectbox.ObjectClassPublisher;
import io.objectbox.Property;
import io.objectbox.Transaction;
import io.objectbox.TxCallback;
import io.objectbox.annotation.apihint.Beta;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.converter.PropertyConverter;
import io.objectbox.exception.DbException;
import io.objectbox.exception.DbExceptionListener;
import io.objectbox.exception.DbSchemaException;
import io.objectbox.internal.Feature;
import io.objectbox.internal.NativeLibraryLoader;
import io.objectbox.internal.ObjectBoxThreadPool;
import io.objectbox.reactive.SubscriptionBuilder;
import io.objectbox.sync.SyncClient;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.greenrobot.essentials.collections.LongHashMap;

@ThreadSafe
public class BoxStore
implements Closeable {
    @Nullable
    private static Object context;
    @Nullable
    private static Object relinker;
    public static final String IN_MEMORY_PREFIX = "memory:";
    public static final String JNI_VERSION = "4.0.0";
    private static final String VERSION = "4.0.0-2024-05-14";
    private static BoxStore defaultStore;
    private static final Set<String> openFiles;
    private static volatile Thread openFilesCheckerThread;
    private final File directory;
    private final String canonicalPath;
    private long handle;
    private final Map<Class<?>, String> dbNameByClass = new HashMap();
    private final Map<Class<?>, Integer> entityTypeIdByClass = new HashMap();
    private final Map<Class<?>, EntityInfo<?>> propertiesByClass = new HashMap();
    private final LongHashMap<Class<?>> classByEntityTypeId = new LongHashMap();
    private final int[] allEntityTypeIds;
    private final Map<Class<?>, Box<?>> boxes = new ConcurrentHashMap();
    private final Set<Transaction> transactions = Collections.newSetFromMap(new WeakHashMap());
    private final ExecutorService threadPool = new ObjectBoxThreadPool(this);
    private final ObjectClassPublisher objectClassPublisher;
    final boolean debugTxRead;
    final boolean debugTxWrite;
    final boolean debugRelations;
    final ThreadLocal<Transaction> activeTx = new ThreadLocal();
    private volatile boolean closed;
    final Object txCommitCountLock = new Object();
    volatile int commitCount;
    private int objectBrowserPort;
    private final int queryAttempts;
    private final TxCallback<?> failedReadTxAttemptCallback;
    @Nullable
    private SyncClient syncClient;

    @Nullable
    @Internal
    public static synchronized Object getContext() {
        return context;
    }

    @Nullable
    @Internal
    public static synchronized Object getRelinker() {
        return relinker;
    }

    public static synchronized BoxStore getDefault() {
        if (defaultStore == null) {
            throw new IllegalStateException("Please call buildDefault() before calling this method");
        }
        return defaultStore;
    }

    static synchronized void setDefault(BoxStore store) {
        if (defaultStore != null) {
            throw new IllegalStateException("Default store was already built before. ");
        }
        defaultStore = store;
    }

    public static synchronized boolean clearDefaultStore() {
        boolean existedBefore = defaultStore != null;
        defaultStore = null;
        return existedBefore;
    }

    public static String getVersion() {
        return VERSION;
    }

    static native String nativeGetVersion();

    public static String getVersionNative() {
        NativeLibraryLoader.ensureLoaded();
        return BoxStore.nativeGetVersion();
    }

    static native boolean nativeRemoveDbFiles(String var0, boolean var1);

    static native long nativeCreateWithFlatOptions(byte[] var0, byte[] var1);

    static native boolean nativeIsReadOnly(long var0);

    static native void nativeDelete(long var0);

    static native void nativeDropAllData(long var0);

    @Internal
    static native long nativeGloballyActiveEntityTypes();

    static native long nativeBeginTx(long var0);

    static native long nativeBeginReadTx(long var0);

    static native int nativeRegisterEntityClass(long var0, String var2, Class<?> var3);

    static native void nativeRegisterCustomType(long var0, int var2, int var3, String var4, Class<? extends PropertyConverter> var5, Class<?> var6);

    static native String nativeDiagnose(long var0);

    static native int nativeCleanStaleReadTransactions(long var0);

    static native void nativeSetDbExceptionListener(long var0, @Nullable DbExceptionListener var2);

    static native void nativeSetDebugFlags(long var0, int var2);

    private native String nativeStartObjectBrowser(long var1, @Nullable String var3, int var4);

    private native boolean nativeStopObjectBrowser(long var1);

    static native boolean nativeIsObjectBrowserAvailable();

    native long nativeDbSize(long var1);

    native long nativeDbSizeOnDisk(long var1);

    native long nativeValidate(long var1, long var3, boolean var5);

    static native long nativeSysProcMeminfoKb(String var0);

    static native long nativeSysProcStatusKb(String var0);

    private static native boolean nativeHasFeature(int var0);

    public static boolean hasFeature(Feature feature) {
        try {
            NativeLibraryLoader.ensureLoaded();
            return BoxStore.nativeHasFeature(feature.id);
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Old JNI lib? " + e);
            return false;
        }
    }

    public static boolean isObjectBrowserAvailable() {
        return BoxStore.hasFeature(Feature.ADMIN);
    }

    public static boolean isSyncAvailable() {
        return BoxStore.hasFeature(Feature.SYNC);
    }

    public static boolean isSyncServerAvailable() {
        return BoxStore.hasFeature(Feature.SYNC_SERVER);
    }

    native long nativePanicModeRemoveAllObjects(long var1, int var3);

    BoxStore(BoxStoreBuilder builder) {
        context = builder.context;
        relinker = builder.relinker;
        NativeLibraryLoader.ensureLoaded();
        this.directory = builder.directory;
        this.canonicalPath = BoxStore.getCanonicalPath(this.directory);
        BoxStore.verifyNotAlreadyOpen(this.canonicalPath);
        try {
            this.handle = BoxStore.nativeCreateWithFlatOptions(builder.buildFlatStoreOptions(this.canonicalPath), builder.model);
            if (this.handle == 0L) {
                throw new DbException("Could not create native store");
            }
            int debugFlags = builder.debugFlags;
            if (debugFlags != 0) {
                this.debugTxRead = (debugFlags & 1) != 0;
                this.debugTxWrite = (debugFlags & 2) != 0;
            } else {
                this.debugTxWrite = false;
                this.debugTxRead = false;
            }
            this.debugRelations = builder.debugRelations;
            for (EntityInfo<?> entityInfo : builder.entityInfoList) {
                try {
                    this.dbNameByClass.put(entityInfo.getEntityClass(), entityInfo.getDbName());
                    int entityId = BoxStore.nativeRegisterEntityClass(this.handle, entityInfo.getDbName(), entityInfo.getEntityClass());
                    this.entityTypeIdByClass.put(entityInfo.getEntityClass(), entityId);
                    this.classByEntityTypeId.put((long)entityId, entityInfo.getEntityClass());
                    this.propertiesByClass.put(entityInfo.getEntityClass(), entityInfo);
                    for (Property<?> property : entityInfo.getAllProperties()) {
                        if (property.customType == null) continue;
                        if (property.converterClass == null) {
                            throw new RuntimeException("No converter class for custom type of " + property);
                        }
                        BoxStore.nativeRegisterCustomType(this.handle, entityId, 0, property.dbName, property.converterClass, property.customType);
                    }
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Could not setup up entity " + entityInfo.getEntityClass(), e);
                }
            }
            int size = this.classByEntityTypeId.size();
            this.allEntityTypeIds = new int[size];
            long[] entityIdsLong = this.classByEntityTypeId.keys();
            for (int i = 0; i < size; ++i) {
                this.allEntityTypeIds[i] = (int)entityIdsLong[i];
            }
            this.objectClassPublisher = new ObjectClassPublisher(this);
            this.failedReadTxAttemptCallback = builder.failedReadTxAttemptCallback;
            this.queryAttempts = Math.max(builder.queryAttempts, 1);
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
    }

    static String getCanonicalPath(File directory) {
        if (directory.getPath().startsWith(IN_MEMORY_PREFIX)) {
            return directory.getPath();
        }
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new DbException("Is not a directory: " + directory.getAbsolutePath());
            }
        } else if (!directory.mkdirs()) {
            throw new DbException("Could not create directory: " + directory.getAbsolutePath());
        }
        try {
            return directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new DbException("Could not verify dir", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyNotAlreadyOpen(String canonicalPath) {
        Set<String> set = openFiles;
        synchronized (set) {
            BoxStore.isFileOpen(canonicalPath);
            if (!openFiles.add(canonicalPath)) {
                throw new DbException("Another BoxStore is still open for this directory: " + canonicalPath + ". Hint: for most apps it's recommended to keep a BoxStore for the app's life time.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isFileOpen(String canonicalPath) {
        Set<String> set = openFiles;
        synchronized (set) {
            if (!openFiles.contains(canonicalPath)) {
                return false;
            }
        }
        Thread checkerThread = openFilesCheckerThread;
        if (checkerThread == null || !checkerThread.isAlive()) {
            checkerThread = new Thread(() -> {
                BoxStore.isFileOpenSync(canonicalPath, true);
                openFilesCheckerThread = null;
            });
            checkerThread.setDaemon(true);
            openFilesCheckerThread = checkerThread;
            checkerThread.start();
            try {
                checkerThread.join(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            return BoxStore.isFileOpenSync(canonicalPath, false);
        }
        Set<String> set2 = openFiles;
        synchronized (set2) {
            return openFiles.contains(canonicalPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isFileOpenSync(String canonicalPath, boolean runFinalization) {
        Set<String> set = openFiles;
        synchronized (set) {
            int tries = 0;
            while (tries < 5 && openFiles.contains(canonicalPath)) {
                System.gc();
                if (runFinalization && ++tries > 1) {
                    System.runFinalization();
                }
                System.gc();
                if (runFinalization && tries > 1) {
                    System.runFinalization();
                }
                try {
                    openFiles.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return openFiles.contains(canonicalPath);
        }
    }

    public static boolean isDatabaseOpen(Object context, @Nullable String dbNameOrNull) throws IOException {
        File dbDir = BoxStoreBuilder.getAndroidDbDir(context, dbNameOrNull);
        return BoxStore.isFileOpen(dbDir.getCanonicalPath());
    }

    public static boolean isDatabaseOpen(@Nullable File baseDirectoryOrNull, @Nullable String dbNameOrNull) throws IOException {
        File dbDir = BoxStoreBuilder.getDbDir(baseDirectoryOrNull, dbNameOrNull);
        return BoxStore.isFileOpen(dbDir.getCanonicalPath());
    }

    public static boolean isDatabaseOpen(File directory) throws IOException {
        return BoxStore.isFileOpen(directory.getCanonicalPath());
    }

    @Experimental
    public static long sysProcMeminfoKb(String key) {
        NativeLibraryLoader.ensureLoaded();
        return BoxStore.nativeSysProcMeminfoKb(key);
    }

    @Experimental
    public static long sysProcStatusKb(String key) {
        NativeLibraryLoader.ensureLoaded();
        return BoxStore.nativeSysProcStatusKb(key);
    }

    @Deprecated
    public long sizeOnDisk() {
        return this.getDbSize();
    }

    public long getDbSize() {
        return this.nativeDbSize(this.getNativeStore());
    }

    public long getDbSizeOnDisk() {
        return this.nativeDbSizeOnDisk(this.getNativeStore());
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Store is closed");
        }
    }

    String getDbName(Class<?> entityClass) {
        return this.dbNameByClass.get(entityClass);
    }

    Integer getEntityTypeId(Class<?> entityClass) {
        return this.entityTypeIdByClass.get(entityClass);
    }

    @Internal
    public int getEntityTypeIdOrThrow(Class<?> entityClass) {
        Integer id = this.entityTypeIdByClass.get(entityClass);
        if (id == null) {
            throw new DbSchemaException("No entity registered for " + entityClass);
        }
        return id;
    }

    public Collection<Class<?>> getAllEntityClasses() {
        return this.dbNameByClass.keySet();
    }

    @Internal
    int[] getAllEntityTypeIds() {
        return this.allEntityTypeIds;
    }

    @Internal
    Class<?> getEntityClassOrThrow(int entityTypeId) {
        Class clazz = (Class)this.classByEntityTypeId.get((long)entityTypeId);
        if (clazz == null) {
            throw new DbSchemaException("No entity registered for type ID " + entityTypeId);
        }
        return clazz;
    }

    @Internal
    <T> EntityInfo<T> getEntityInfo(Class<T> entityClass) {
        return this.propertiesByClass.get(entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public Transaction beginTx() {
        long nativeTx;
        int initialCommitCount = this.commitCount;
        if (this.debugTxWrite) {
            System.out.println("Begin TX with commit count " + initialCommitCount);
        }
        if ((nativeTx = BoxStore.nativeBeginTx(this.getNativeStore())) == 0L) {
            throw new DbException("Could not create native transaction");
        }
        Transaction tx = new Transaction(this, nativeTx, initialCommitCount);
        Set<Transaction> set = this.transactions;
        synchronized (set) {
            this.transactions.add(tx);
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public Transaction beginReadTx() {
        long nativeTx;
        int initialCommitCount = this.commitCount;
        if (this.debugTxRead) {
            System.out.println("Begin read TX with commit count " + initialCommitCount);
        }
        if ((nativeTx = BoxStore.nativeBeginReadTx(this.getNativeStore())) == 0L) {
            throw new DbException("Could not create native read transaction");
        }
        Transaction tx = new Transaction(this, nativeTx, initialCommitCount);
        Set<Transaction> set = this.transactions;
        synchronized (set) {
            this.transactions.add(tx);
        }
        return tx;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isReadOnly() {
        return BoxStore.nativeIsReadOnly(this.getNativeStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean oldClosedState;
        Object object = this;
        synchronized (object) {
            oldClosedState = this.closed;
            if (!this.closed) {
                ArrayList<Transaction> transactionsToClose;
                if (this.objectBrowserPort != 0) {
                    try {
                        this.stopObjectBrowser();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                this.closed = true;
                Set<Transaction> set = this.transactions;
                synchronized (set) {
                    transactionsToClose = new ArrayList<Transaction>(this.transactions);
                }
                for (Transaction t : transactionsToClose) {
                    t.close();
                }
                if (this.handle != 0L) {
                    BoxStore.nativeDelete(this.handle);
                    this.handle = 0L;
                }
                this.threadPool.shutdown();
                this.checkThreadTermination();
            }
        }
        if (!oldClosedState) {
            object = openFiles;
            synchronized (object) {
                openFiles.remove(this.canonicalPath);
                openFiles.notifyAll();
            }
        }
    }

    private void checkThreadTermination() {
        try {
            if (!this.threadPool.awaitTermination(1L, TimeUnit.SECONDS)) {
                int activeCount = Thread.activeCount();
                System.err.println("Thread pool not terminated in time; printing stack traces...");
                Thread[] threads = new Thread[activeCount + 2];
                int count = Thread.enumerate(threads);
                for (int i = 0; i < count; ++i) {
                    System.err.println("Thread: " + threads[i].getName());
                    Thread.dumpStack();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean deleteAllFiles() {
        if (!this.isClosed()) {
            throw new IllegalStateException("Store must be closed");
        }
        return BoxStore.deleteAllFiles(this.directory);
    }

    public static boolean deleteAllFiles(File objectStoreDirectory) {
        String canonicalPath = BoxStore.getCanonicalPath(objectStoreDirectory);
        if (BoxStore.isFileOpen(canonicalPath)) {
            throw new IllegalStateException("Cannot delete files: store is still open");
        }
        NativeLibraryLoader.ensureLoaded();
        return BoxStore.nativeRemoveDbFiles(canonicalPath, true);
    }

    public static boolean deleteAllFiles(Object androidContext, @Nullable String customDbNameOrNull) {
        File dbDir = BoxStoreBuilder.getAndroidDbDir(androidContext, customDbNameOrNull);
        return BoxStore.deleteAllFiles(dbDir);
    }

    public static boolean deleteAllFiles(@Nullable File baseDirectoryOrNull, @Nullable String customDbNameOrNull) {
        File dbDir = BoxStoreBuilder.getDbDir(baseDirectoryOrNull, customDbNameOrNull);
        return BoxStore.deleteAllFiles(dbDir);
    }

    public void removeAllObjects() {
        BoxStore.nativeDropAllData(this.getNativeStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void unregisterTransaction(Transaction transaction) {
        Set<Transaction> set = this.transactions;
        synchronized (set) {
            this.transactions.remove(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void txCommitted(Transaction tx, @Nullable int[] entityTypeIdsAffected) {
        Iterator<Box<?>> iterator = this.txCommitCountLock;
        synchronized (iterator) {
            ++this.commitCount;
            if (this.debugTxWrite) {
                System.out.println("TX committed. New commit count: " + this.commitCount + ", entity types affected: " + (entityTypeIdsAffected != null ? entityTypeIdsAffected.length : 0));
            }
        }
        for (Box<?> box : this.boxes.values()) {
            box.txCommitted(tx);
        }
        if (entityTypeIdsAffected != null) {
            this.objectClassPublisher.publish(entityTypeIdsAffected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Box<T> boxFor(Class<T> entityClass) {
        Box<Object> box = this.boxes.get(entityClass);
        if (box == null) {
            if (!this.dbNameByClass.containsKey(entityClass)) {
                throw new IllegalArgumentException(entityClass + " is not a known entity. Please add it and trigger generation again.");
            }
            Map<Class<?>, Box<?>> map = this.boxes;
            synchronized (map) {
                box = this.boxes.get(entityClass);
                if (box == null) {
                    box = new Box<T>(this, entityClass);
                    this.boxes.put(entityClass, box);
                }
            }
        }
        return box;
    }

    public void runInTx(Runnable runnable) {
        Transaction tx = this.activeTx.get();
        if (tx == null) {
            tx = this.beginTx();
            this.activeTx.set(tx);
            try {
                runnable.run();
                tx.commit();
            }
            finally {
                this.activeTx.remove();
                tx.close();
            }
        } else {
            if (tx.isReadOnly()) {
                throw new IllegalStateException("Cannot start a transaction while a read only transaction is active");
            }
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInReadTx(Runnable runnable) {
        Transaction tx = this.activeTx.get();
        if (tx == null) {
            tx = this.beginReadTx();
            this.activeTx.set(tx);
            try {
                runnable.run();
            }
            finally {
                this.activeTx.remove();
                for (Box<?> box : this.boxes.values()) {
                    box.readTxFinished(tx);
                }
                tx.close();
            }
        } else {
            runnable.run();
        }
    }

    @Experimental
    public <T> T callInReadTxWithRetry(Callable<T> callable, int attempts, int initialBackOffInMs, boolean logAndHeal) {
        if (attempts == 1) {
            return this.callInReadTx(callable);
        }
        if (attempts < 1) {
            throw new IllegalArgumentException("Illegal value of attempts: " + attempts);
        }
        long backoffInMs = initialBackOffInMs;
        DbException lastException = null;
        for (int attempt = 1; attempt <= attempts; ++attempt) {
            try {
                return this.callInReadTx(callable);
            }
            catch (DbException e) {
                lastException = e;
                String diagnose = this.diagnose();
                String message = attempt + " of " + attempts + " attempts of calling a read TX failed:";
                if (logAndHeal) {
                    System.err.println(message);
                    e.printStackTrace();
                    System.err.println(diagnose);
                    System.err.flush();
                    System.gc();
                    System.runFinalization();
                    this.cleanStaleReadTransactions();
                }
                if (this.failedReadTxAttemptCallback != null) {
                    this.failedReadTxAttemptCallback.txFinished(null, new DbException(message + " \n" + diagnose, e));
                }
                try {
                    Thread.sleep(backoffInMs);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    throw lastException;
                }
                backoffInMs *= 2L;
                continue;
            }
        }
        throw lastException;
    }

    public <T> T callInReadTx(Callable<T> callable) {
        Transaction tx = this.activeTx.get();
        if (tx == null) {
            tx = this.beginReadTx();
            this.activeTx.set(tx);
            try {
                T t = callable.call();
                return t;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Callable threw exception", e);
            }
            finally {
                this.activeTx.remove();
                for (Box<?> box : this.boxes.values()) {
                    box.readTxFinished(tx);
                }
                tx.close();
            }
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Callable threw exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callInTx(Callable<R> callable) throws Exception {
        Transaction tx = this.activeTx.get();
        if (tx == null) {
            tx = this.beginTx();
            this.activeTx.set(tx);
            try {
                R result = callable.call();
                tx.commit();
                R r = result;
                return r;
            }
            finally {
                this.activeTx.remove();
                tx.close();
            }
        }
        if (tx.isReadOnly()) {
            throw new IllegalStateException("Cannot start a transaction while a read only transaction is active");
        }
        return callable.call();
    }

    public <R> R callInTxNoException(Callable<R> callable) {
        try {
            return this.callInTx(callable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runInTxAsync(Runnable runnable, @Nullable TxCallback<Void> callback) {
        this.threadPool.submit(() -> {
            block3: {
                try {
                    this.runInTx(runnable);
                    if (callback != null) {
                        callback.txFinished(null, null);
                    }
                }
                catch (Throwable failure) {
                    if (callback == null) break block3;
                    callback.txFinished(null, failure);
                }
            }
        });
    }

    public <R> void callInTxAsync(Callable<R> callable, @Nullable TxCallback<R> callback) {
        this.threadPool.submit(() -> {
            block3: {
                try {
                    Object result = this.callInTx(callable);
                    if (callback != null) {
                        callback.txFinished(result, null);
                    }
                }
                catch (Throwable failure) {
                    if (callback == null) break block3;
                    callback.txFinished(null, failure);
                }
            }
        });
    }

    public String diagnose() {
        return BoxStore.nativeDiagnose(this.getNativeStore());
    }

    @Beta
    public long validate(long pageLimit, boolean checkLeafLevel) {
        if (pageLimit < 0L) {
            throw new IllegalArgumentException("pageLimit must be zero or positive");
        }
        return this.nativeValidate(this.getNativeStore(), pageLimit, checkLeafLevel);
    }

    public int cleanStaleReadTransactions() {
        return BoxStore.nativeCleanStaleReadTransactions(this.getNativeStore());
    }

    public void closeThreadResources() {
        for (Box<?> box : this.boxes.values()) {
            box.closeThreadResources();
        }
    }

    public SubscriptionBuilder<Class> subscribe() {
        this.checkOpen();
        return new SubscriptionBuilder<Class>(this.objectClassPublisher, null);
    }

    public <T> SubscriptionBuilder<Class<T>> subscribe(Class<T> forClass) {
        this.checkOpen();
        return new SubscriptionBuilder<Class<T>>(this.objectClassPublisher, forClass);
    }

    @Nullable
    @Experimental
    public String startObjectBrowser() {
        this.verifyObjectBrowserNotRunning();
        int basePort = 8090;
        for (int port = 8090; port < 8100; ++port) {
            try {
                String url = this.startObjectBrowser(port);
                if (url == null) continue;
                return url;
            }
            catch (DbException e) {
                if (e.getMessage() != null && e.getMessage().contains("port")) continue;
                throw e;
            }
        }
        return null;
    }

    @Nullable
    @Experimental
    public String startObjectBrowser(int port) {
        this.verifyObjectBrowserNotRunning();
        String url = this.nativeStartObjectBrowser(this.getNativeStore(), null, port);
        if (url != null) {
            this.objectBrowserPort = port;
        }
        return url;
    }

    @Nullable
    @Experimental
    public String startObjectBrowser(String urlToBindTo) {
        int port;
        this.verifyObjectBrowserNotRunning();
        try {
            port = new URL(urlToBindTo).getPort();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Can not start Object Browser at " + urlToBindTo, e);
        }
        String url = this.nativeStartObjectBrowser(this.getNativeStore(), urlToBindTo, 0);
        if (url != null) {
            this.objectBrowserPort = port;
        }
        return url;
    }

    @Experimental
    public synchronized boolean stopObjectBrowser() {
        if (this.objectBrowserPort == 0) {
            throw new IllegalStateException("ObjectBrowser has not been started before");
        }
        this.objectBrowserPort = 0;
        return this.nativeStopObjectBrowser(this.getNativeStore());
    }

    @Experimental
    public int getObjectBrowserPort() {
        return this.objectBrowserPort;
    }

    public boolean isObjectBrowserRunning() {
        return this.objectBrowserPort != 0;
    }

    private void verifyObjectBrowserNotRunning() {
        if (this.objectBrowserPort != 0) {
            throw new DbException("ObjectBrowser is already running at port " + this.objectBrowserPort);
        }
    }

    public void setDbExceptionListener(@Nullable DbExceptionListener dbExceptionListener) {
        BoxStore.nativeSetDbExceptionListener(this.getNativeStore(), dbExceptionListener);
    }

    @Internal
    public Future<?> internalScheduleThread(Runnable runnable) {
        return this.threadPool.submit(runnable);
    }

    @Internal
    public ExecutorService internalThreadPool() {
        return this.threadPool;
    }

    @Internal
    public boolean isDebugRelations() {
        return this.debugRelations;
    }

    @Internal
    public int internalQueryAttempts() {
        return this.queryAttempts;
    }

    @Internal
    public TxCallback<?> internalFailedReadTxAttemptCallback() {
        return this.failedReadTxAttemptCallback;
    }

    void setDebugFlags(int debugFlags) {
        BoxStore.nativeSetDebugFlags(this.getNativeStore(), debugFlags);
    }

    long panicModeRemoveAllObjects(int entityId) {
        return this.nativePanicModeRemoveAllObjects(this.getNativeStore(), entityId);
    }

    public long getNativeStore() {
        this.checkOpen();
        return this.handle;
    }

    @Nullable
    public SyncClient getSyncClient() {
        return this.syncClient;
    }

    void setSyncClient(@Nullable SyncClient syncClient) {
        this.syncClient = syncClient;
    }

    static {
        openFiles = new HashSet<String>();
    }
}

