/*
 * Decompiled with CFR 0.152.
 */
package io.onfhir.path;

import io.onfhir.api.validation.IReferenceResolver;
import io.onfhir.path.FhirPathBoolean;
import io.onfhir.path.FhirPathDateTime;
import io.onfhir.path.FhirPathEnvironment;
import io.onfhir.path.FhirPathEvaluator$;
import io.onfhir.path.FhirPathException;
import io.onfhir.path.FhirPathException$;
import io.onfhir.path.FhirPathExpressionEvaluator;
import io.onfhir.path.FhirPathExpressionEvaluator$;
import io.onfhir.path.FhirPathNumber;
import io.onfhir.path.FhirPathResult;
import io.onfhir.path.FhirPathString;
import io.onfhir.path.FhirPathTime;
import io.onfhir.path.FhirPathValueTransformer$;
import io.onfhir.path.grammar.FhirPathExprLexer;
import io.onfhir.path.grammar.FhirPathExprParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.json4s.JsonAST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001%\u0011\u0011C\u00125jeB\u000bG\u000f[#wC2,\u0018\r^8s\u0015\t\u0019A!\u0001\u0003qCRD'BA\u0003\u0007\u0003\u0019ygN\u001a5je*\tq!\u0001\u0002j_\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001B\u0001B\u0003%!#A\tsK\u001a,'/\u001a8dKJ+7o\u001c7wKJ\u00042aC\n\u0016\u0013\t!BB\u0001\u0004PaRLwN\u001c\t\u0003-mi\u0011a\u0006\u0006\u00031e\t!B^1mS\u0012\fG/[8o\u0015\tQB!A\u0002ba&L!\u0001H\f\u0003%%\u0013VMZ3sK:\u001cWMU3t_24XM\u001d\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0001\u0012\u0003CA\u0011\u0001\u001b\u0005\u0011\u0001bB\t\u001e!\u0003\u0005\rA\u0005\u0005\bI\u0001\u0011\r\u0011\"\u0003&\u0003\u0019awnZ4feV\ta\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\t1&A\u0002pe\u001eL!!\f\u0015\u0003\r1{wmZ3s\u0011\u0019y\u0003\u0001)A\u0005M\u00059An\\4hKJ\u0004\u0003\"B\u0019\u0001\t\u0013\u0011\u0014A\u00048pe6\fG.\u001b>f\u0013:\u0004X\u000f\u001e\u000b\u0003gy\u0002\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c\r\u001b\u00059$B\u0001\u001d\t\u0003\u0019a$o\\8u}%\u0011!\bD\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;\u0019!)q\b\ra\u0001g\u0005)\u0011N\u001c9vi\")\u0011\t\u0001C\u0001\u0005\u0006)\u0001/\u0019:tKR\u00111)\u0014\t\u0003\t*s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0002\u0002\u000f\u001d\u0014\u0018-\\7be&\u0011\u0011JR\u0001\u0013\r\"L'\u000fU1uQ\u0016C\bO\u001d)beN,'/\u0003\u0002L\u0019\n\tR\t\u001f9sKN\u001c\u0018n\u001c8D_:$X\r\u001f;\u000b\u0005%3\u0005\"B A\u0001\u0004\u0019\u0004\"B(\u0001\t\u0013\u0001\u0016\u0001C3wC2,\u0018\r^3\u0015\u0007Ekv\fE\u0002S/js!aU+\u000f\u0005Y\"\u0016\"A\u0007\n\u0005Yc\u0011a\u00029bG.\fw-Z\u0005\u00031f\u00131aU3r\u0015\t1F\u0002\u0005\u0002\"7&\u0011AL\u0001\u0002\u000f\r\"L'\u000fU1uQJ+7/\u001e7u\u0011\u0015qf\n1\u0001D\u0003\u0011)\u0007\u0010\u001d:\t\u000b\u0001t\u0005\u0019A1\u0002\u0005=t\u0007C\u00012l\u001d\t\u0019\u0007N\u0004\u0002eM:\u0011a'Z\u0005\u0002W%\u0011qMK\u0001\u0007UN|g\u000eN:\n\u0005%T\u0017a\u0002&t_:\f5\u000b\u0016\u0006\u0003O*J!\u0001\\7\u0003\r)3\u0016\r\\;f\u0015\tI'\u000eC\u0003P\u0001\u0011\u0005q\u000eF\u0002RaFDQA\u00188A\u0002MBQ\u0001\u00198A\u0002\u0005DQa\u001d\u0001\u0005\u0002Q\f\u0011b]1uSN4\u0017.Z:\u0015\u0007UD\u0018\u0010\u0005\u0002\fm&\u0011q\u000f\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015q&\u000f1\u00014\u0011\u0015\u0001'\u000f1\u0001b\u0011\u0015Y\b\u0001\"\u0001}\u0003=\u0019\u0018\r^5tM&,7\u000fU1sg\u0016$GcA;~}\")aL\u001fa\u0001\u0007\")\u0001M\u001fa\u0001C\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011!E3wC2,\u0018\r^3Ok6,'/[2bYR1\u0011QAA\u0006\u0003\u001b\u00012AUA\u0004\u0013\r\tI!\u0017\u0002\u000b\u0005&<G)Z2j[\u0006d\u0007\"\u00020\u0000\u0001\u0004\u0019\u0004\"\u00021\u0000\u0001\u0004\t\u0007bBA\t\u0001\u0011\u0005\u00111C\u0001\u0011KZ\fG.^1uK\u0012\u000bG/\u001a+j[\u0016$b!!\u0006\u0002*\u0005-\u0002\u0003BA\f\u0003Ki!!!\u0007\u000b\t\u0005m\u0011QD\u0001\ti\u0016l\u0007o\u001c:bY*!\u0011qDA\u0011\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\r\u0012\u0001\u00026bm\u0006LA!a\n\u0002\u001a\tAA+Z7q_J\fG\u000e\u0003\u0004_\u0003\u001f\u0001\ra\r\u0005\u0007A\u0006=\u0001\u0019A1\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005aQM^1mk\u0006$X\rV5nKR1\u00111GA%\u0003\u0017\u0002raCA\u001b\u0003s\t\t%C\u0002\u000281\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u001e\u0003{i!!!\b\n\t\u0005}\u0012Q\u0004\u0002\n\u0019>\u001c\u0017\r\u001c+j[\u0016\u0004BaC\n\u0002DA!\u00111HA#\u0013\u0011\t9%!\b\u0003\ri{g.Z%e\u0011\u0019q\u0016Q\u0006a\u0001g!1\u0001-!\fA\u0002\u0005Dq!a\u0014\u0001\t\u0003\t\t&\u0001\bfm\u0006dW/\u0019;f'R\u0014\u0018N\\4\u0015\r\u0005M\u0013QKA,!\r\u0011vk\r\u0005\u0007=\u00065\u0003\u0019A\u001a\t\r\u0001\fi\u00051\u0001b\u000f\u001d\tYF\u0001E\u0001\u0003;\n\u0011C\u00125jeB\u000bG\u000f[#wC2,\u0018\r^8s!\r\t\u0013q\f\u0004\u0007\u0003\tA\t!!\u0019\u0014\u0007\u0005}#\u0002C\u0004\u001f\u0003?\"\t!!\u001a\u0015\u0005\u0005u\u0003\u0002CA5\u0003?\"\t!a\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0001\ni\u0007\u0003\u0004\u0012\u0003O\u0002\r!\u0006\u0005\t\u0003S\ny\u0006\"\u0001\u0002rQ\t\u0001\u0005\u0003\u0005\u0002j\u0005}C\u0011AA;)\r\u0001\u0013q\u000f\u0005\u0007#\u0005M\u0004\u0019\u0001\n\t\u0015\u0005m\u0014qLI\u0001\n\u0003\ti(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fR3AEAAW\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\u0013Ut7\r[3dW\u0016$'bAAG\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0015q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class FhirPathEvaluator {
    private final Option<IReferenceResolver> referenceResolver;
    private final Logger logger;

    public static Option<IReferenceResolver> $lessinit$greater$default$1() {
        return FhirPathEvaluator$.MODULE$.$lessinit$greater$default$1();
    }

    public static FhirPathEvaluator apply(Option<IReferenceResolver> option) {
        return FhirPathEvaluator$.MODULE$.apply(option);
    }

    public static FhirPathEvaluator apply() {
        return FhirPathEvaluator$.MODULE$.apply();
    }

    public static FhirPathEvaluator apply(IReferenceResolver iReferenceResolver) {
        return FhirPathEvaluator$.MODULE$.apply(iReferenceResolver);
    }

    private Logger logger() {
        return this.logger;
    }

    private String normalizeInput(String input) {
        return input.contains("contains(") ? input.replace("contains(", "_contains(") : input;
    }

    public FhirPathExprParser.ExpressionContext parse(String input) {
        this.logger().debug(new StringBuilder(35).append("Parsing FHIR path expression '").append(input).append("' ...").toString());
        ByteArrayInputStream stream = new ByteArrayInputStream(this.normalizeInput(input).getBytes(StandardCharsets.UTF_8));
        FhirPathExprLexer lexer = new FhirPathExprLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        FhirPathExprParser parser = new FhirPathExprParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return parser.expression();
    }

    private Seq<FhirPathResult> evaluate(FhirPathExprParser.ExpressionContext expr, JsonAST.JValue on) {
        this.logger().debug(new StringBuilder(38).append("Evaluating FHIR path expression '").append(expr.getText()).append("' ...").toString());
        Seq<FhirPathResult> resource = FhirPathValueTransformer$.MODULE$.transform(on);
        FhirPathEnvironment environment = new FhirPathEnvironment((FhirPathResult)resource.head(), this.referenceResolver);
        FhirPathExpressionEvaluator evaluator = new FhirPathExpressionEvaluator(environment, resource, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3());
        return (Seq)evaluator.visit((ParseTree)expr);
    }

    public Seq<FhirPathResult> evaluate(String expr, JsonAST.JValue on) {
        FhirPathExprParser.ExpressionContext parsedExpr = this.parse(expr);
        return this.evaluate(parsedExpr, on);
    }

    public boolean satisfies(String expr, JsonAST.JValue on) {
        Seq<FhirPathResult> result = this.evaluate(expr, on);
        if (result.length() != 1 || !(result.head() instanceof FhirPathBoolean)) {
            throw new FhirPathException(new StringBuilder(66).append("Expression ").append(expr).append(" does not evaluate to a boolean for the given resource!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        return ((FhirPathBoolean)result.head()).b();
    }

    public boolean satisfiesParsed(FhirPathExprParser.ExpressionContext expr, JsonAST.JValue on) {
        boolean bl;
        Seq<FhirPathResult> result = this.evaluate(expr, on);
        Seq<FhirPathResult> seq = result;
        if (Nil$.MODULE$.equals(seq)) {
            bl = true;
        } else {
            FhirPathResult fhirPathResult;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathBoolean) {
                boolean b;
                FhirPathBoolean fhirPathBoolean = (FhirPathBoolean)fhirPathResult;
                bl = b = fhirPathBoolean.b();
            } else {
                throw new FhirPathException(new StringBuilder(73).append("Expression ").append((Object)expr).append(" does not evaluate to a single boolean for the given resource!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return bl;
    }

    public BigDecimal evaluateNumerical(String expr, JsonAST.JValue on) {
        Seq<FhirPathResult> result = this.evaluate(expr, on);
        if (result.length() != 1 || !(result.head() instanceof FhirPathNumber)) {
            throw new FhirPathException(new StringBuilder(65).append("Expression ").append(expr).append(" does not evaluate to a number for the given resource!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        return ((FhirPathNumber)result.head()).v();
    }

    public Temporal evaluateDateTime(String expr, JsonAST.JValue on) {
        Seq<FhirPathResult> result = this.evaluate(expr, on);
        if (result.length() != 1 || !(result.head() instanceof FhirPathDateTime)) {
            throw new FhirPathException(new StringBuilder(67).append("Expression ").append(expr).append(" does not evaluate to a datetime for the given resource!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        return ((FhirPathDateTime)result.head()).dt();
    }

    public Tuple2<LocalTime, Option<ZoneId>> evaluateTime(String expr, JsonAST.JValue on) {
        Seq<FhirPathResult> result = this.evaluate(expr, on);
        if (result.length() != 1 || !(result.head() instanceof FhirPathTime)) {
            throw new FhirPathException(new StringBuilder(63).append("Expression ").append(expr).append(" does not evaluate to a time for the given resource!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        FhirPathTime t = (FhirPathTime)result.head();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.lt()), t.zone());
    }

    public Seq<String> evaluateString(String expr, JsonAST.JValue on) {
        Seq<FhirPathResult> result = this.evaluate(expr, on);
        if (result.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FhirPathEvaluator.$anonfun$evaluateString$1(x$1)))) {
            throw new FhirPathException(new StringBuilder(65).append("Expression ").append(expr).append(" does not evaluate to a string for the given resource!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        return (Seq)result.map((Function1 & Serializable & scala.Serializable)x$2 -> ((FhirPathString)x$2).s(), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$evaluateString$1(FhirPathResult x$1) {
        return !(x$1 instanceof FhirPathString);
    }

    public FhirPathEvaluator(Option<IReferenceResolver> referenceResolver) {
        this.referenceResolver = referenceResolver;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

