/*
 * Decompiled with CFR 0.152.
 */
package io.onfhir.path;

import io.onfhir.api.model.FhirCanonicalReference;
import io.onfhir.api.util.FHIRUtil$;
import io.onfhir.path.FhirPathBoolean;
import io.onfhir.path.FhirPathComplex;
import io.onfhir.path.FhirPathComplex$;
import io.onfhir.path.FhirPathDateTime;
import io.onfhir.path.FhirPathEnvironment;
import io.onfhir.path.FhirPathEvaluator$;
import io.onfhir.path.FhirPathException;
import io.onfhir.path.FhirPathException$;
import io.onfhir.path.FhirPathExpressionEvaluator;
import io.onfhir.path.FhirPathExpressionEvaluator$;
import io.onfhir.path.FhirPathLiteralEvaluator$;
import io.onfhir.path.FhirPathNumber;
import io.onfhir.path.FhirPathQuantity;
import io.onfhir.path.FhirPathResult;
import io.onfhir.path.FhirPathString;
import io.onfhir.path.FhirPathTime;
import io.onfhir.path.FhirPathValueTransformer$;
import io.onfhir.path.grammar.FhirPathExprParser;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json4s.JsonAST;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0001\u0003\u0001%\u0011\u0011D\u00125jeB\u000bG\u000f\u001b$v]\u000e$\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u00111\u0001B\u0001\u0005a\u0006$\bN\u0003\u0002\u0006\r\u00051qN\u001c4iSJT\u0011aB\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\bG>tG/\u001a=u!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\nGQ&\u0014\b+\u0019;i\u000b:4\u0018N]8o[\u0016tG\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u001d\u0019WO\u001d:f]R\u00042!G\u0011%\u001d\tQrD\u0004\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u00051AH]8pizJ\u0011!D\u0005\u0003A1\tq\u0001]1dW\u0006<W-\u0003\u0002#G\t\u00191+Z9\u000b\u0005\u0001b\u0001CA\n&\u0013\t1#A\u0001\bGQ&\u0014\b+\u0019;i%\u0016\u001cX\u000f\u001c;\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\rQ3\u0006\f\t\u0003'\u0001AQ!E\u0014A\u0002IAQaF\u0014A\u0002aAQA\f\u0001\u0005\u0002=\nAbY1mY\u001a+hn\u0019;j_:$2\u0001\u0007\u0019;\u0011\u0015\tT\u00061\u00013\u0003\u00151g.Y7f!\t\u0019tG\u0004\u00025kA\u00111\u0004D\u0005\u0003m1\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a\u0007\u0004\u0005\u0006w5\u0002\r\u0001P\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0007e\tS\b\u0005\u0002?\u0017:\u0011q\b\u0013\b\u0003\u0001\u001as!!Q#\u000f\u0005\t#eBA\u000eD\u0013\u00059\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u0002H\u0005\u00059qM]1n[\u0006\u0014\u0018BA%K\u0003I1\u0005.\u001b:QCRDW\t\u001f9s!\u0006\u00148/\u001a:\u000b\u0005\u001d\u0013\u0011B\u0001'N\u0005E)\u0005\u0010\u001d:fgNLwN\\\"p]R,\u0007\u0010\u001e\u0006\u0003\u0013*CQa\u0014\u0001\u0005\u0002A\u000bqA]3t_24X\rF\u0001\u0019\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003%)\u0007\u0010^3og&|g\u000e\u0006\u0002\u0019)\")Q+\u0015a\u0001{\u00051QO\u001d7FqBDQa\u0016\u0001\u0005\u0002a\u000baa\u001c4UsB,GC\u0001\rZ\u0011\u0015Qf\u000b1\u0001>\u0003\r!\u0018\u0010\u001d\u0005\u00069\u0002!\t!X\u0001\u0003CN$\"\u0001\u00070\t\u000bi[\u0006\u0019A\u001f\t\u000b\u0001\u0004A\u0011A1\u0002\u0005%\u001cHC\u0001\rc\u0011\u0015Qv\f1\u0001>\u0011\u0015!\u0007\u0001\"\u0001Q\u0003\u0015)W\u000e\u001d;z\u0011\u00151\u0007\u0001\"\u0001Q\u0003\rqw\u000e\u001e\u0005\u0006Q\u0002!\t![\u0001\u0007KbL7\u000f^:\u0015\u0005aQ\u0007\"B6h\u0001\u0004a\u0017\u0001B3yaJ\u00042aC7>\u0013\tqGB\u0001\u0004PaRLwN\u001c\u0005\u0006Q\u0002!\t\u0001\u001d\u000b\u00031EDQa[8A\u0002uBQ\u0001\u001b\u0001\u0005\u0002ACQ\u0001\u001e\u0001\u0005\u0002U\f1!\u00197m)\tAb\u000fC\u0003xg\u0002\u0007Q(\u0001\u0005de&$XM]5b\u0011\u0015I\b\u0001\"\u0001Q\u0003\u001d\tG\u000e\u001c+sk\u0016DQa\u001f\u0001\u0005\u0002A\u000bq!\u00198z)J,X\rC\u0003~\u0001\u0011\u0005\u0001+\u0001\u0005bY24\u0015\r\\:f\u0011\u0015y\b\u0001\"\u0001Q\u0003!\tg.\u001f$bYN,\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\tgV\u00147/\u001a;PMR\u0019\u0001$a\u0002\t\u000f\u0005%\u0011\u0011\u0001a\u0001{\u0005)q\u000e\u001e5fe\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011AC:va\u0016\u00148/\u001a;PMR\u0019\u0001$!\u0005\t\u000f\u0005%\u00111\u0002a\u0001{!1\u0011Q\u0003\u0001\u0005\u0002A\u000b!\"[:ESN$\u0018N\\2u\u0011\u0019\tI\u0002\u0001C\u0001!\u0006AA-[:uS:\u001cG\u000f\u0003\u0004\u0002\u001e\u0001!\t\u0001U\u0001\u0006G>,h\u000e\u001e\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003\u00159\b.\u001a:f)\rA\u0012Q\u0005\u0005\u0007o\u0006}\u0001\u0019A\u001f\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u000511/\u001a7fGR$2\u0001GA\u0017\u0011\u001d\ty#a\nA\u0002u\n!\u0002\u001d:pU\u0016\u001cG/[8o\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\taA]3qK\u0006$Hc\u0001\r\u00028!9\u0011qFA\u0019\u0001\u0004i\u0004BBA\u001e\u0001\u0011\u0005\u0001+\u0001\u0004tS:<G.\u001a\u0005\u0007\u0003\u007f\u0001A\u0011\u0001)\u0002\u000b\u0019L'o\u001d;\t\r\u0005\r\u0003\u0001\"\u0001Q\u0003\u0011a\u0017m\u001d;\t\r\u0005\u001d\u0003\u0001\"\u0001Q\u0003\u0011!\u0018-\u001b7\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N\u0005!1o[5q)\rA\u0012q\n\u0005\b\u0003#\nI\u00051\u0001>\u0003\u001dqW/\\#yaJDq!!\u0016\u0001\t\u0003\t9&\u0001\u0003uC.,Gc\u0001\r\u0002Z!9\u0011\u0011KA*\u0001\u0004i\u0004bBA/\u0001\u0011\u0005\u0011qL\u0001\nS:$XM]:fGR$2\u0001GA1\u0011\u001d\t\u0019'a\u0017A\u0002u\nQb\u001c;iKJ\u001cu\u000e\u001c7FqB\u0014\bbBA4\u0001\u0011\u0005\u0011\u0011N\u0001\bKb\u001cG.\u001e3f)\rA\u00121\u000e\u0005\b\u0003G\n)\u00071\u0001>\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\nqaY8nE&tW\rF\u0002\u0019\u0003gBq!!\u0003\u0002n\u0001\u0007Q\bC\u0004\u0002x\u0001!\t!!\u001f\u0002\u0007%Lg\rF\u0004\u0019\u0003w\ny(a!\t\u000f\u0005u\u0014Q\u000fa\u0001{\u0005I1M]5uKJLW/\u001c\u0005\b\u0003\u0003\u000b)\b1\u0001>\u0003)!(/^3SKN,H\u000e\u001e\u0005\b\u0003\u000b\u000b)\b1\u0001m\u0003=yG\u000f[3so&\u001cXMU3tk2$\bbBA<\u0001\u0011\u0005\u0011\u0011\u0012\u000b\b1\u0005-\u0015QRAH\u0011\u001d\ti(a\"A\u0002uBq!!!\u0002\b\u0002\u0007Q\bC\u0004\u0002\u0006\u0006\u001d\u0005\u0019A\u001f\t\u000f\u0005]\u0004\u0001\"\u0001\u0002\u0014R)\u0001$!&\u0002\u0018\"9\u0011QPAI\u0001\u0004i\u0004bBAA\u0003#\u0003\r!\u0010\u0005\u0007\u00037\u0003A\u0011\u0001)\u0002\u0013Q|\u0017J\u001c;fO\u0016\u0014\bBBAP\u0001\u0011\u0005\u0001+A\u0005u_\u0012+7-[7bY\"1\u00111\u0015\u0001\u0005\u0002A\u000b\u0011b\u0018;p'R\u0014\u0018N\\4\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\u0006\t2\r[3dWNKgn\u001a7f'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0006cA\u0006\u0002.&\u0019\u0011q\u0016\u0007\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003g\u0003A\u0011AA[\u0003\u001dIg\u000eZ3y\u001f\u001a$2\u0001GA\\\u0011\u001d\tI,!-A\u0002u\nQb];cgR\u0014\u0018N\\4FqB\u0014\bbBA_\u0001\u0011\u0005\u0011qX\u0001\ngV\u00147\u000f\u001e:j]\u001e$R\u0001GAa\u0003\u000bDq!a1\u0002<\u0002\u0007Q(A\u0005ti\u0006\u0014H/\u0012=qe\"9\u0011qYA^\u0001\u0004a\u0017A\u00037f]\u001e$\b.\u0012=qe\"9\u0011Q\u0018\u0001\u0005\u0002\u0005-Gc\u0001\r\u0002N\"9\u00111YAe\u0001\u0004i\u0004bBA_\u0001\u0011\u0005\u0011\u0011\u001b\u000b\u00061\u0005M\u0017Q\u001b\u0005\b\u0003\u0007\fy\r1\u0001>\u0011\u001d\t9-a4A\u0002uBq!!7\u0001\t\u0003\tY.\u0001\u0006ti\u0006\u0014Ho],ji\"$2\u0001GAo\u0011\u001d\ty.a6A\u0002u\n!\u0002\u001d:fM&DX\t\u001f9s\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003K\f\u0001\"\u001a8eg^KG\u000f\u001b\u000b\u00041\u0005\u001d\bbBAu\u0003C\u0004\r!P\u0001\u000bgV4g-\u001b=FqB\u0014\bbBAw\u0001\u0011\u0005\u0011q^\u0001\n?\u000e|g\u000e^1j]N$2\u0001GAy\u0011\u001d\tI,a;A\u0002uBq!!>\u0001\t\u0003\t90A\u0004sKBd\u0017mY3\u0015\u000ba\tI0!@\t\u000f\u0005m\u00181\u001fa\u0001{\u0005Y\u0001/\u0019;uKJtW\t\u001f9s\u0011\u001d\ty0a=A\u0002u\n\u0001c];cgRLG/\u001e;j_:,\u0005\u0010\u001d:\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006\u00059Q.\u0019;dQ\u0016\u001cHc\u0001\r\u0003\b!9!\u0011\u0002B\u0001\u0001\u0004i\u0014!\u0003:fO\u0016DX\t\u001f9s\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001f\taB]3qY\u0006\u001cW-T1uG\",7\u000fF\u0003\u0019\u0005#\u0011\u0019\u0002C\u0004\u0003\n\t-\u0001\u0019A\u001f\t\u000f\u0005}(1\u0002a\u0001{!1!q\u0003\u0001\u0005\u0002A\u000ba\u0001\\3oORD\u0007B\u0002B\u000e\u0001\u0011\u0005\u0001+\u0001\u0005dQ&dGM]3o\u0011\u0019\u0011y\u0002\u0001C\u0001!\u0006YA-Z:dK:$\u0017M\u001c;t\u0011\u0019\u0011\u0019\u0003\u0001C\u0001!\u0006A\u0001.Y:WC2,X\r\u0003\u0004\u0003(\u0001!\t\u0001U\u0001\u0006i>$\u0017-\u001f\u0005\u0007\u0005W\u0001A\u0011\u0001)\u0002\u00079|w\u000fC\u0004\u00030\u0001!\tA!\r\u0002\u000bQ\u0014\u0018mY3\u0015\u0007a\u0011\u0019\u0004C\u0004\u00036\t5\u0002\u0019A\u001f\u0002\u00119\fW.Z#yaJDqAa\f\u0001\t\u0003\u0011I\u0004F\u0003\u0019\u0005w\u0011i\u0004C\u0004\u00036\t]\u0002\u0019A\u001f\t\u000f\t}\"q\u0007a\u0001{\u00059q\u000e\u001e5FqB\u0014\bb\u0002B\"\u0001\u0011\u0005!QI\u0001\u0004gVlGc\u0001\r\u0003H!11N!\u0011A\u0002uBqAa\u0013\u0001\t\u0003\u0011i%A\u0002bm\u001e$2\u0001\u0007B(\u0011\u0019Y'\u0011\na\u0001{!9!1\u000b\u0001\u0005\u0002\tU\u0013aA7j]R\u0019\u0001Da\u0016\t\r-\u0014\t\u00061\u0001>\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0005;\n1!\\1y)\rA\"q\f\u0005\u0007W\ne\u0003\u0019A\u001f\t\u000f\t\r\u0004\u0001\"\u0001\u0003f\u00059qM]8va\nKH#\u0002\r\u0003h\t-\u0004b\u0002B5\u0005C\u0002\r!P\u0001\fOJ|W\u000f\u001d\"z\u000bb\u0004(\u000fC\u0004\u0003n\t\u0005\u0004\u0019A\u001f\u0002\u001b\u0005<wM]3hCR,W\t\u001f9s\u0011\u001d\u0011\t\b\u0001C\u0001\u0005g\n\u0011bZ3u!\u0016\u0014\u0018n\u001c3\u0015\u000fa\u0011)H!\u001f\u0003~!9!q\u000fB8\u0001\u0004i\u0014\u0001\u00034s_6$\u0015\r^3\t\u000f\tm$q\u000ea\u0001{\u00051Ao\u001c#bi\u0016DqAa \u0003p\u0001\u0007Q(\u0001\u0004qKJLw\u000e\u001a")
public class FhirPathFunctionEvaluator {
    private final FhirPathEnvironment context;
    private final Seq<FhirPathResult> current;

    public Seq<FhirPathResult> callFunction(String fname, Seq<FhirPathExprParser.ExpressionContext> params) {
        Seq seq;
        try {
            Seq fhirPathResult;
            String string = fname;
            String string2 = "toString";
            String functionName = !(string != null ? !string.equals(string2) : string2 != null) ? "_toString" : fname;
            Method method = FhirPathFunctionEvaluator.class.getMethod(functionName, (Class[])((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)x$1 -> FhirPathExprParser.ExpressionContext.class, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
            Object result = method.invoke((Object)this, (Object[])params.toArray(ClassTag$.MODULE$.apply(FhirPathExprParser.ExpressionContext.class)));
            seq = fhirPathResult = (Seq)result;
        }
        catch (NoSuchMethodException n) {
            throw new FhirPathException(new StringBuilder(70).append("Invalid function call, function ").append(fname).append(" does not exist or take ").append(params.length()).append(" arguments !!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = ite.getTargetException();
            if (throwable instanceof FhirPathException) {
                FhirPathException fhirPathException = (FhirPathException)throwable;
                throw fhirPathException;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw FhirPathException$.MODULE$.apply("Invalid function call $fname!", throwable2);
            }
            throw new MatchError((Object)throwable);
        }
        return seq;
    }

    public Seq<FhirPathResult> resolve() {
        Seq fhirReferences = (Seq)this.current.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FhirCanonicalReference fhirCanonicalReference;
            FhirPathResult fhirPathResult = x0$1;
            if (fhirPathResult instanceof FhirPathString) {
                FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
                String uri = fhirPathString.s();
                fhirCanonicalReference = FHIRUtil$.MODULE$.parseCanonicalReference(uri);
            } else if (fhirPathResult instanceof FhirPathComplex) {
                FhirPathComplex fhirPathComplex = (FhirPathComplex)fhirPathResult;
                JsonAST.JObject o = fhirPathComplex.json();
                fhirCanonicalReference = FHIRUtil$.MODULE$.parseReference((JsonAST.JValue)o);
            } else {
                throw new FhirPathException("Invalid function call 'resolve', it should be called on a canonical value or FHIR reference!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            return fhirCanonicalReference;
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)fhirReferences.flatMap((Function1 & Serializable & scala.Serializable)fr -> Option$.MODULE$.option2Iterable($this.context.referenceResolver().flatMap((Function1 & Serializable & scala.Serializable)rr -> rr.resolveReference(fr))), Seq$.MODULE$.canBuildFrom())).map((Function1)FhirPathComplex$.MODULE$, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<FhirPathResult> extension(FhirPathExprParser.ExpressionContext urlExp) {
        Seq url = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)urlExp);
        if (url.length() != 1 || !(url.head() instanceof FhirPathString)) {
            throw new FhirPathException(new StringBuilder(69).append("Invalid function call 'extension', expression ").append(urlExp.getText()).append(" does not return a url!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        FhirPathExprParser.ExpressionContext expr = FhirPathEvaluator$.MODULE$.apply().parse(new StringBuilder(25).append("extension.where(url = '").append(((FhirPathString)url.head()).s()).append("')").toString());
        Seq result = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)expr);
        return result;
    }

    public Seq<FhirPathResult> ofType(FhirPathExprParser.ExpressionContext typ) {
        return this.current;
    }

    public Seq<FhirPathResult> as(FhirPathExprParser.ExpressionContext typ) {
        return this.current;
    }

    public Seq<FhirPathResult> is(FhirPathExprParser.ExpressionContext typ) {
        Seq seq;
        int n = this.current.length();
        switch (n) {
            case 0: {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(false)}));
                break;
            }
            case 1: {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(true)}));
                break;
            }
            default: {
                throw new FhirPathException("Invalid function call 'is', it should be called on single item!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return seq;
    }

    public Seq<FhirPathResult> empty() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(this.current.isEmpty())}));
    }

    public Seq<FhirPathResult> not() {
        Nil$ nil$;
        Seq<FhirPathResult> seq = this.current;
        if (Nil$.MODULE$.equals(seq)) {
            nil$ = Nil$.MODULE$;
        } else {
            FhirPathResult fhirPathResult;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathBoolean) {
                FhirPathBoolean fhirPathBoolean = (FhirPathBoolean)fhirPathResult;
                boolean b = fhirPathBoolean.b();
                nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(!b)}));
            } else {
                throw new FhirPathException("Function 'not' should run on FHIR path boolean!!!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return nil$;
    }

    public Seq<FhirPathResult> exists(Option<FhirPathExprParser.ExpressionContext> expr) {
        boolean bl;
        Option<FhirPathExprParser.ExpressionContext> option = expr;
        if (None$.MODULE$.equals(option)) {
            bl = this.current.nonEmpty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            FhirPathExprParser.ExpressionContext criteria = (FhirPathExprParser.ExpressionContext)((Object)some.value());
            bl = this.current.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$exists$1(this, criteria, c)));
        } else {
            throw new MatchError(option);
        }
        boolean result = bl;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> exists(FhirPathExprParser.ExpressionContext expr) {
        return this.exists((Option<FhirPathExprParser.ExpressionContext>)new Some((Object)expr));
    }

    public Seq<FhirPathResult> exists() {
        return this.exists((Option<FhirPathExprParser.ExpressionContext>)None$.MODULE$);
    }

    public Seq<FhirPathResult> all(FhirPathExprParser.ExpressionContext criteria) {
        boolean result = this.current.forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$all$1(this, criteria, c)));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> allTrue() {
        if (this.current.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$allTrue$1(x$2)))) {
            throw new FhirPathException("Function 'allTrue' should run on collection of FHIR Path boolean values!!!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        boolean result = this.current.forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$allTrue$2(c)));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> anyTrue() {
        if (this.current.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$anyTrue$1(x$3)))) {
            throw new FhirPathException("Function 'anyTrue' should run on collection of FHIR Path boolean values!!!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        boolean result = this.current.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$anyTrue$2(c)));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> allFalse() {
        if (this.current.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$allFalse$1(x$4)))) {
            throw new FhirPathException("Function 'allFalse' should run on collection of FHIR Path boolean values!!!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        boolean result = this.current.forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$allFalse$2(c)));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> anyFalse() {
        if (this.current.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$anyFalse$1(x$5)))) {
            throw new FhirPathException("Function 'anyFalse' should run on collection of FHIR Path boolean values!!!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        boolean result = this.current.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$anyFalse$2(c)));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> subsetOf(FhirPathExprParser.ExpressionContext other) {
        Seq otherCollection = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)other);
        boolean result = this.current.forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)otherCollection.exists((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$subsetOf$2(c, o)))));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> supersetOf(FhirPathExprParser.ExpressionContext other) {
        Seq otherCollection = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)other);
        boolean result = this.current.isEmpty() ? false : otherCollection.forall((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)this.current.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$supersetOf$2(o, c)))));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(result)}));
    }

    public Seq<FhirPathResult> isDistinct() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(((SeqLike)this.current.distinct()).length() == this.current.length())}));
    }

    public Seq<FhirPathResult> distinct() {
        return (Seq)this.current.distinct();
    }

    public Seq<FhirPathResult> count() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(this.current.length()))}));
    }

    public Seq<FhirPathResult> where(FhirPathExprParser.ExpressionContext criteria) {
        return (Seq)this.current.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$where$1(this, criteria, c)));
    }

    public Seq<FhirPathResult> select(FhirPathExprParser.ExpressionContext projection) {
        return (Seq)this.current.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            void var3_3;
            Seq r = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)projection);
            return var3_3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<FhirPathResult> repeat(FhirPathExprParser.ExpressionContext projection) {
        Seq<FhirPathResult> firstResults = this.select(projection);
        return firstResults.nonEmpty() ? (Seq)firstResults.$plus$plus(new FhirPathFunctionEvaluator(this.context, firstResults).repeat(projection), Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
    }

    public Seq<FhirPathResult> single() {
        Nil$ nil$;
        Seq<FhirPathResult> seq = this.current;
        if (Nil$.MODULE$.equals(seq)) {
            nil$ = Nil$.MODULE$;
        } else {
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                FhirPathResult s = (FhirPathResult)((SeqLike)some.get()).apply(0);
                nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{s}));
            } else {
                throw new FhirPathException(new StringBuilder(58).append("Function 'single' is called on a multi item collection ").append(this.current).append("!!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return nil$;
    }

    public Seq<FhirPathResult> first() {
        return Option$.MODULE$.option2Iterable(this.current.headOption()).toSeq();
    }

    public Seq<FhirPathResult> last() {
        return Option$.MODULE$.option2Iterable(this.current.lastOption()).toSeq();
    }

    public Seq<FhirPathResult> tail() {
        return this.current.isEmpty() ? Nil$.MODULE$ : (Seq)this.current.tail();
    }

    public Seq<FhirPathResult> skip(FhirPathExprParser.ExpressionContext numExpr) {
        Seq numValue = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)numExpr);
        if (numValue.length() != 1 || !(numValue.head() instanceof FhirPathNumber)) {
            throw new FhirPathException(new StringBuilder(78).append("Invalid function call 'skip', num expression ").append(numExpr.getText()).append(" does not return a single number!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        FhirPathNumber inum = (FhirPathNumber)numValue.head();
        if (!inum.isInteger()) {
            throw new FhirPathException(new StringBuilder(71).append("Invalid function call 'skip', num expression ").append(numExpr.getText()).append(" does not return a integer").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        int i = inum.v().toInt();
        return i < 0 ? this.current : (i > this.current.length() ? Nil$.MODULE$ : (Seq)this.current.drop(i));
    }

    public Seq<FhirPathResult> take(FhirPathExprParser.ExpressionContext numExpr) {
        Seq numValue = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)numExpr);
        if (numValue.length() != 1 || !(numValue.head() instanceof FhirPathNumber)) {
            throw new FhirPathException(new StringBuilder(78).append("Invalid function call 'take', num expression ").append(numExpr.getText()).append(" does not return a single number!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        FhirPathNumber inum = (FhirPathNumber)numValue.head();
        if (!inum.isInteger()) {
            throw new FhirPathException(new StringBuilder(71).append("Invalid function call 'take', num expression ").append(numExpr.getText()).append(" does not return a integer").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        int i = inum.v().toInt();
        return i <= 0 ? Nil$.MODULE$ : (Seq)this.current.take(i);
    }

    public Seq<FhirPathResult> intersect(FhirPathExprParser.ExpressionContext otherCollExpr) {
        Seq otherSet = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)otherCollExpr);
        return (Seq)((SeqLike)this.current.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)otherSet.exists((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$intersect$2(c, o)))))).distinct();
    }

    public Seq<FhirPathResult> exclude(FhirPathExprParser.ExpressionContext otherCollExpr) {
        Seq otherSet = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)otherCollExpr);
        return (Seq)((SeqLike)this.current.filterNot((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)otherSet.exists((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$exclude$2(c, o)))))).distinct();
    }

    public Seq<FhirPathResult> combine(FhirPathExprParser.ExpressionContext other) {
        Seq otherCollection = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)other);
        return (Seq)this.current.$plus$plus((GenTraversableOnce)otherCollection, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<FhirPathResult> iif(FhirPathExprParser.ExpressionContext criterium, FhirPathExprParser.ExpressionContext trueResult, Option<FhirPathExprParser.ExpressionContext> otherwiseResult) {
        boolean bl;
        Seq criteriaResult = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)criterium);
        Seq seq = criteriaResult;
        if (Nil$.MODULE$.equals(seq)) {
            bl = false;
        } else {
            FhirPathBoolean fhirPathBoolean;
            boolean bl2;
            FhirPathResult fhirPathResult;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathBoolean && !(bl2 = (fhirPathBoolean = (FhirPathBoolean)fhirPathResult).b())) {
                bl = false;
            } else {
                FhirPathBoolean fhirPathBoolean2;
                boolean bl3;
                FhirPathResult fhirPathResult2;
                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (fhirPathResult2 = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathBoolean && (bl3 = (fhirPathBoolean2 = (FhirPathBoolean)fhirPathResult2).b())) {
                    bl = true;
                } else {
                    throw new MatchError((Object)seq);
                }
            }
        }
        boolean conditionResult = bl;
        return conditionResult ? (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)trueResult) : (Seq)otherwiseResult.map((Function1 & Serializable & scala.Serializable)ore -> (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)ore)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> iif(FhirPathExprParser.ExpressionContext criterium, FhirPathExprParser.ExpressionContext trueResult, FhirPathExprParser.ExpressionContext otherwiseResult) {
        return this.iif(criterium, trueResult, (Option<FhirPathExprParser.ExpressionContext>)new Some((Object)otherwiseResult));
    }

    public Seq<FhirPathResult> iif(FhirPathExprParser.ExpressionContext criterium, FhirPathExprParser.ExpressionContext trueResult) {
        return this.iif(criterium, trueResult, (Option<FhirPathExprParser.ExpressionContext>)None$.MODULE$);
    }

    public Seq<FhirPathResult> toInteger() {
        Nil$ nil$;
        FhirPathNumber fhirPathNumber;
        FhirPathResult n;
        Seq<FhirPathResult> seq = this.current;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (n = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathNumber && (fhirPathNumber = (FhirPathNumber)n).isInteger()) {
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{fhirPathNumber}));
        } else {
            FhirPathResult fhirPathResult;
            FhirPathNumber fhirPathNumber2;
            FhirPathResult n2;
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (n2 = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathNumber && !(fhirPathNumber2 = (FhirPathNumber)n2).isInteger()) {
                throw new FhirPathException(new StringBuilder(47).append("Invalid function call 'toInteger' on value ").append(fhirPathNumber2).append(" !!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            Some some3 = Seq$.MODULE$.unapplySeq(seq);
            if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some3.get()).apply(0)) instanceof FhirPathString) {
                FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
                String s = fhirPathString.s();
                Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption();
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new FhirPathException(new StringBuilder(91).append("Invalid function call 'toInteger' on value ").append(s).append(" of string type cannot be converted to integer!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
                    }
                    throw new MatchError((Object)option);
                }
                Some some4 = (Some)option;
                int i = BoxesRunTime.unboxToInt((Object)some4.value());
                Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(i))}));
                nil$ = seq2;
            } else {
                FhirPathResult fhirPathResult2;
                Some some5 = Seq$.MODULE$.unapplySeq(seq);
                if (!some5.isEmpty() && some5.get() != null && ((SeqLike)some5.get()).lengthCompare(1) == 0 && (fhirPathResult2 = (FhirPathResult)((SeqLike)some5.get()).apply(0)) instanceof FhirPathBoolean) {
                    FhirPathBoolean fhirPathBoolean = (FhirPathBoolean)fhirPathResult2;
                    boolean b = fhirPathBoolean.b();
                    nil$ = b ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(1))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(0))}));
                } else {
                    Some some6 = Seq$.MODULE$.unapplySeq(seq);
                    if (!some6.isEmpty() && some6.get() != null && ((SeqLike)some6.get()).lengthCompare(1) == 0) {
                        FhirPathResult oth = (FhirPathResult)((SeqLike)some6.get()).apply(0);
                        throw new FhirPathException(new StringBuilder(47).append("Invalid function call 'toInteger' on value ").append(oth).append(" !!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
                    }
                    nil$ = Nil$.MODULE$;
                }
            }
        }
        return nil$;
    }

    public Seq<FhirPathResult> toDecimal() {
        Nil$ nil$;
        FhirPathResult n;
        Seq<FhirPathResult> seq = this.current;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (n = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathNumber) {
            FhirPathNumber fhirPathNumber = (FhirPathNumber)n;
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{fhirPathNumber}));
        } else {
            FhirPathResult fhirPathResult;
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathString) {
                FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
                String s = fhirPathString.s();
                Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toDouble()).toOption();
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new FhirPathException(new StringBuilder(91).append("Invalid function call 'toDecimal' on value ").append(s).append(" of string type cannot be converted to decimal!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
                    }
                    throw new MatchError((Object)option);
                }
                Some some3 = (Some)option;
                double d = BoxesRunTime.unboxToDouble((Object)some3.value());
                Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal(d))}));
                nil$ = seq2;
            } else {
                FhirPathResult fhirPathResult2;
                Some some4 = Seq$.MODULE$.unapplySeq(seq);
                if (!some4.isEmpty() && some4.get() != null && ((SeqLike)some4.get()).lengthCompare(1) == 0 && (fhirPathResult2 = (FhirPathResult)((SeqLike)some4.get()).apply(0)) instanceof FhirPathBoolean) {
                    FhirPathBoolean fhirPathBoolean = (FhirPathBoolean)fhirPathResult2;
                    boolean b = fhirPathBoolean.b();
                    nil$ = b ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal(1.0))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal(0.0))}));
                } else {
                    Some some5 = Seq$.MODULE$.unapplySeq(seq);
                    if (!some5.isEmpty() && some5.get() != null && ((SeqLike)some5.get()).lengthCompare(1) == 0) {
                        FhirPathResult oth = (FhirPathResult)((SeqLike)some5.get()).apply(0);
                        throw new FhirPathException(new StringBuilder(47).append("Invalid function call 'toDecimal' on value ").append(oth).append(" !!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
                    }
                    nil$ = Nil$.MODULE$;
                }
            }
        }
        return nil$;
    }

    public Seq<FhirPathResult> _toString() {
        Seq seq;
        FhirPathResult fhirPathResult;
        Seq<FhirPathResult> seq2 = this.current;
        Some some = Seq$.MODULE$.unapplySeq(seq2);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathNumber) {
            FhirPathNumber fhirPathNumber = (FhirPathNumber)fhirPathResult;
            BigDecimal n = fhirPathNumber.v();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(n.toString())}));
        } else {
            FhirPathResult s;
            Some some2 = Seq$.MODULE$.unapplySeq(seq2);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (s = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathString) {
                FhirPathString fhirPathString = (FhirPathString)s;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{fhirPathString}));
            } else {
                FhirPathResult dt;
                Some some3 = Seq$.MODULE$.unapplySeq(seq2);
                if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(1) == 0 && (dt = (FhirPathResult)((SeqLike)some3.get()).apply(0)) instanceof FhirPathDateTime) {
                    FhirPathDateTime fhirPathDateTime = (FhirPathDateTime)dt;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(FhirPathLiteralEvaluator$.MODULE$.format(fhirPathDateTime))}));
                } else {
                    FhirPathResult t;
                    Some some4 = Seq$.MODULE$.unapplySeq(seq2);
                    if (!some4.isEmpty() && some4.get() != null && ((SeqLike)some4.get()).lengthCompare(1) == 0 && (t = (FhirPathResult)((SeqLike)some4.get()).apply(0)) instanceof FhirPathTime) {
                        FhirPathTime fhirPathTime = (FhirPathTime)t;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(FhirPathLiteralEvaluator$.MODULE$.format(fhirPathTime))}));
                    } else {
                        FhirPathResult q;
                        Some some5 = Seq$.MODULE$.unapplySeq(seq2);
                        if (!some5.isEmpty() && some5.get() != null && ((SeqLike)some5.get()).lengthCompare(1) == 0 && (q = (FhirPathResult)((SeqLike)some5.get()).apply(0)) instanceof FhirPathQuantity) {
                            FhirPathQuantity fhirPathQuantity = (FhirPathQuantity)q;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(new StringBuilder(1).append(fhirPathQuantity.q().v().toString()).append(" ").append(fhirPathQuantity.unit()).toString())}));
                        } else {
                            FhirPathResult fhirPathResult2;
                            Some some6 = Seq$.MODULE$.unapplySeq(seq2);
                            if (!some6.isEmpty() && some6.get() != null && ((SeqLike)some6.get()).lengthCompare(1) == 0 && (fhirPathResult2 = (FhirPathResult)((SeqLike)some6.get()).apply(0)) instanceof FhirPathBoolean) {
                                FhirPathBoolean fhirPathBoolean = (FhirPathBoolean)fhirPathResult2;
                                boolean b = fhirPathBoolean.b();
                                seq = b ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString("'true'")})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString("'false'")}));
                            } else {
                                Some some7 = Seq$.MODULE$.unapplySeq(seq2);
                                if (!some7.isEmpty() && some7.get() != null && ((SeqLike)some7.get()).lengthCompare(1) == 0) {
                                    FhirPathResult oth = (FhirPathResult)((SeqLike)some7.get()).apply(0);
                                    throw new FhirPathException(new StringBuilder(47).append("Invalid function call 'toDecimal' on value ").append(oth).append(" !!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
                                }
                                seq = Nil$.MODULE$;
                            }
                        }
                    }
                }
            }
        }
        return seq;
    }

    private void checkSingleString() {
        if (this.current.length() > 1 || this.current.headOption().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$checkSingleString$1(x$6)))) {
            throw new FhirPathException("Invalid function call 'indexOf' on multi item collection or non-string value!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public Seq<FhirPathResult> indexOf(FhirPathExprParser.ExpressionContext substringExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            String string;
            String string2;
            String ss;
            FhirPathResult fhirPathResult;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)substringExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString) {
                FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
                string2 = ss = fhirPathString.s();
                string = "";
            } else {
                throw new FhirPathException(new StringBuilder(82).append("Invalid function call 'indexOf', the substring expression ").append(substringExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            Seq seq2 = !(string2 != null ? !string2.equals(string) : string != null) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(0))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(((FhirPathString)c).s().indexOf(ss)))}));
            return seq2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> substring(FhirPathExprParser.ExpressionContext startExpr, Option<FhirPathExprParser.ExpressionContext> lengthExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            Nil$ nil$;
            FhirPathNumber fhirPathNumber;
            FhirPathResult n;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)startExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((n = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathNumber) || !(fhirPathNumber = (FhirPathNumber)n).isInteger()) {
                throw new FhirPathException(new StringBuilder(81).append("Invalid function call 'substring', the start expression ").append(startExpr.getText()).append(" does not return integer!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            int n2 = fhirPathNumber.v().toInt();
            int start = n2;
            Option length = lengthExpr.map((Function1 & Serializable & scala.Serializable)lexpr -> BoxesRunTime.boxToInteger((int)FhirPathFunctionEvaluator.$anonfun$substring$2(this, startExpr, lexpr)));
            String str = ((FhirPathString)c).s();
            if (start > str.length() || start < 0) {
                nil$ = Nil$.MODULE$;
            } else if (length.isEmpty()) {
                nil$ = (Seq)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(str.substring(start))}))).toOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            } else {
                int endIndex = start + BoxesRunTime.unboxToInt((Object)length.get()) >= str.length() ? str.length() : start + BoxesRunTime.unboxToInt((Object)length.get());
                nil$ = (Seq)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(str.substring(start, endIndex))}))).toOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            }
            return nil$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> substring(FhirPathExprParser.ExpressionContext startExpr) {
        return this.substring(startExpr, (Option<FhirPathExprParser.ExpressionContext>)None$.MODULE$);
    }

    public Seq<FhirPathResult> substring(FhirPathExprParser.ExpressionContext startExpr, FhirPathExprParser.ExpressionContext lengthExpr) {
        return this.substring(startExpr, (Option<FhirPathExprParser.ExpressionContext>)new Some((Object)lengthExpr));
    }

    public Seq<FhirPathResult> startsWith(FhirPathExprParser.ExpressionContext prefixExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            FhirPathResult fhirPathResult;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)prefixExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(86).append("Invalid function call 'startsWith', the prefixExpr expression ").append(prefixExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
            String ss = fhirPathString.s();
            FhirPathBoolean[] fhirPathBooleanArray = new FhirPathBoolean[1];
            String string = ss;
            String string2 = "";
            fhirPathBooleanArray[0] = new FhirPathBoolean(!(string == null ? string2 != null : !string.equals(string2)) || ((FhirPathString)c).s().startsWith(ss));
            Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fhirPathBooleanArray));
            return seq2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> endsWith(FhirPathExprParser.ExpressionContext suffixExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            FhirPathResult fhirPathResult;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)suffixExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(84).append("Invalid function call 'endsWith', the suffixExpr expression ").append(suffixExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
            String ss = fhirPathString.s();
            FhirPathBoolean[] fhirPathBooleanArray = new FhirPathBoolean[1];
            String string = ss;
            String string2 = "";
            fhirPathBooleanArray[0] = new FhirPathBoolean(!(string == null ? string2 != null : !string.equals(string2)) || ((FhirPathString)c).s().endsWith(ss));
            Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fhirPathBooleanArray));
            return seq2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> _contains(FhirPathExprParser.ExpressionContext substringExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            FhirPathResult fhirPathResult;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)substringExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(83).append("Invalid function call 'contains', the substring expression ").append(substringExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
            String ss = fhirPathString.s();
            FhirPathBoolean[] fhirPathBooleanArray = new FhirPathBoolean[1];
            String string = ss;
            String string2 = "";
            fhirPathBooleanArray[0] = new FhirPathBoolean(!(string == null ? string2 != null : !string.equals(string2)) || ((FhirPathString)c).s().contains(ss));
            Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fhirPathBooleanArray));
            return seq2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> replace(FhirPathExprParser.ExpressionContext patternExpr, FhirPathExprParser.ExpressionContext substitutionExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            String ss;
            FhirPathResult fhirPathResult;
            String ss2;
            FhirPathResult fhirPathResult2;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)patternExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult2 = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(80).append("Invalid function call 'replace', the pattern expression ").append(patternExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString = (FhirPathString)fhirPathResult2;
            String string = ss2 = fhirPathString.s();
            String pattern = string;
            Seq seq2 = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)substitutionExpr);
            Some some2 = Seq$.MODULE$.unapplySeq(seq2);
            if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(86).append("Invalid function call 'replace', the substitiution expression ").append(substitutionExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString2 = (FhirPathString)fhirPathResult;
            String string2 = ss = fhirPathString2.s();
            String substitution = string2;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(((FhirPathString)c).s().replace(pattern, substitution))}));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> matches(FhirPathExprParser.ExpressionContext regexExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            FhirPathResult fhirPathResult;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)regexExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(80).append("Invalid function call 'matches', the regular expression ").append(regexExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
            String ss = fhirPathString.s();
            String unexcapedScript = StringEscapeUtils.unescapeEcmaScript((String)ss);
            boolean isMatch = ((FhirPathString)c).s().matches(unexcapedScript);
            Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(isMatch)}));
            return seq2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> replaceMatches(FhirPathExprParser.ExpressionContext regexExpr, FhirPathExprParser.ExpressionContext substitutionExpr) {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> {
            String ss;
            FhirPathResult fhirPathResult;
            FhirPathResult fhirPathResult2;
            Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)regexExpr);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult2 = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(78).append("Invalid function call 'replace', the regex expression ").append(regexExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString = (FhirPathString)fhirPathResult2;
            String ss2 = fhirPathString.s();
            String string = StringEscapeUtils.unescapeEcmaScript((String)ss2);
            String regex = string;
            Seq seq2 = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)substitutionExpr);
            Some some2 = Seq$.MODULE$.unapplySeq(seq2);
            if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathString)) {
                throw new FhirPathException(new StringBuilder(86).append("Invalid function call 'replace', the substitiution expression ").append(substitutionExpr.getText()).append(" does not return string!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            FhirPathString fhirPathString2 = (FhirPathString)fhirPathResult;
            String string2 = ss = fhirPathString2.s();
            String substitution = string2;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString(((FhirPathString)c).s().replaceAll(regex, substitution))}));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> length() {
        this.checkSingleString();
        return (Seq)this.current.headOption().map((Function1 & Serializable & scala.Serializable)c -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(((FhirPathString)c).s().length()))}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<FhirPathResult> children() {
        return (Seq)((TraversableLike)((TraversableLike)this.current.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$children$1(x$7)))).map((Function1 & Serializable & scala.Serializable)x$8 -> (FhirPathComplex)x$8, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)pc -> (List)((List)pc.json().obj().map((Function1 & Serializable & scala.Serializable)x$9 -> (JsonAST.JValue)x$9._2(), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)v -> FhirPathValueTransformer$.MODULE$.transform((JsonAST.JValue)v), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<FhirPathResult> descendants() {
        void var1_1;
        Seq<FhirPathResult> results = this.children();
        return results.nonEmpty() ? (Seq)results.$plus$plus(new FhirPathFunctionEvaluator(this.context, results).descendants(), Seq$.MODULE$.canBuildFrom()) : var1_1;
    }

    public Seq<FhirPathResult> hasValue() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(this.current.nonEmpty())}));
    }

    public Seq<FhirPathResult> today() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathDateTime[]{new FhirPathDateTime(LocalDate.now())}));
    }

    public Seq<FhirPathResult> now() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathDateTime[]{new FhirPathDateTime(ZonedDateTime.now())}));
    }

    public Seq<FhirPathResult> trace(FhirPathExprParser.ExpressionContext nameExpr) {
        return this.current;
    }

    public Seq<FhirPathResult> trace(FhirPathExprParser.ExpressionContext nameExpr, FhirPathExprParser.ExpressionContext othExpr) {
        return this.current;
    }

    public Seq<FhirPathResult> sum(FhirPathExprParser.ExpressionContext expr) {
        Seq results = (Seq)this.current.map((Function1 & Serializable & scala.Serializable)c -> {
            Seq result = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)expr);
            if (result.length() > 1 || result.headOption().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$sum$2(x$10)))) {
                throw new FhirPathException(new StringBuilder(92).append("Invalid function call 'sum', the expression ").append(expr.getText()).append(" does not return a single FhirPathNumber or Nil!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            return (FhirPathNumber)result.headOption().map((Function1 & Serializable & scala.Serializable)x$11 -> (FhirPathNumber)x$11).getOrElse((Function0 & Serializable & scala.Serializable)() -> new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(0)));
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{(FhirPathNumber)results.reduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> r1.$plus((FhirPathNumber)r2))}));
    }

    public Seq<FhirPathResult> avg(FhirPathExprParser.ExpressionContext expr) {
        if (this.current.isEmpty()) {
            throw new FhirPathException("Invalid function call 'avg' on Nil!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{((FhirPathNumber)this.sum(expr).head()).$div(new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(this.current.length())))}));
    }

    public Seq<FhirPathResult> min(FhirPathExprParser.ExpressionContext expr) {
        Seq results = (Seq)this.current.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            Seq result = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)expr);
            if (result.length() > 1) {
                throw new FhirPathException(new StringBuilder(92).append("Invalid function call 'min', the expression ").append(expr.getText()).append(" does not return a single FhirPathNumber or Nil!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            return Option$.MODULE$.option2Iterable(result.headOption().map((Function1 & Serializable & scala.Serializable)x$12 -> (FhirPathNumber)x$12));
        }, Seq$.MODULE$.canBuildFrom());
        return results.isEmpty() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{(FhirPathNumber)results.reduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> r1.$less(r2) ? r1 : r2)}));
    }

    public Seq<FhirPathResult> max(FhirPathExprParser.ExpressionContext expr) {
        Seq results = (Seq)this.current.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            Seq result = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)expr);
            if (result.length() > 1) {
                throw new FhirPathException(new StringBuilder(92).append("Invalid function call 'min', the expression ").append(expr.getText()).append(" does not return a single FhirPathNumber or Nil!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            return Option$.MODULE$.option2Iterable(result.headOption().map((Function1 & Serializable & scala.Serializable)x$13 -> (FhirPathNumber)x$13));
        }, Seq$.MODULE$.canBuildFrom());
        return results.isEmpty() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{(FhirPathNumber)results.reduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> r1.$greater(r2) ? r1 : r2)}));
    }

    public Seq<FhirPathResult> groupBy(FhirPathExprParser.ExpressionContext groupByExpr, FhirPathExprParser.ExpressionContext aggregateExpr) {
        if (!this.current.forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$groupBy$1(x$14)))) {
            throw new FhirPathException("Invalid function call 'groupBy' on current value! The data type for current value should be complex object!", FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        Seq buckets = (Seq)this.current.map((Function1 & Serializable & scala.Serializable)c -> {
            Seq bucketKeyResults = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)groupByExpr);
            JsonAST.JValue bucketKey = FhirPathValueTransformer$.MODULE$.serializeToJson((Seq<FhirPathResult>)bucketKeyResults);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bucketKey), c);
        }, Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)buckets.groupBy((Function1 & Serializable & scala.Serializable)x$15 -> (JsonAST.JValue)x$15._1()).mapValues((Function1 & Serializable & scala.Serializable)x$16 -> (Seq)x$16.map((Function1 & Serializable & scala.Serializable)x$17 -> (FhirPathResult)x$17._2(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)bv -> {
            Seq aggValues = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)bv._2()), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)aggregateExpr);
            if (aggValues.length() != 1 || aggValues.exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)FhirPathFunctionEvaluator.$anonfun$groupBy$7(x$18)))) {
                throw new FhirPathException(new StringBuilder(119).append("Invalid function call 'groupBy' on current value! The aggregation expression does not return single number for bucket ").append(bv._1()).append("!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
            JsonAST.JValue aggValue = ((FhirPathResult)aggValues.head()).toJson();
            return new FhirPathComplex(JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bucket"), bv._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"agg"), (Object)aggValue)})));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<FhirPathResult> getPeriod(FhirPathExprParser.ExpressionContext fromDate, FhirPathExprParser.ExpressionContext toDate, FhirPathExprParser.ExpressionContext period) {
        ChronoUnit chronoUnit;
        FhirPathResult fhirPathResult;
        Temporal dt;
        FhirPathResult fhirPathResult2;
        Temporal dt2;
        FhirPathResult fhirPathResult3;
        Seq seq = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)fromDate);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((fhirPathResult3 = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathDateTime)) {
            throw new FhirPathException(new StringBuilder(99).append("Invalid function call 'getPeriod', second expression ").append(fromDate.getText()).append(" does not evaluate to a single FHIR date time!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        FhirPathDateTime fhirPathDateTime = (FhirPathDateTime)fhirPathResult3;
        Temporal temporal = dt2 = fhirPathDateTime.dt();
        Temporal fdate = temporal;
        Seq seq2 = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)toDate);
        Some some2 = Seq$.MODULE$.unapplySeq(seq2);
        if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0 || !((fhirPathResult2 = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathDateTime)) {
            throw new FhirPathException(new StringBuilder(99).append("Invalid function call 'getPeriod', second expression ").append(toDate.getText()).append(" does not evaluate to a single FHIR date time!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        FhirPathDateTime fhirPathDateTime2 = (FhirPathDateTime)fhirPathResult2;
        Temporal temporal2 = dt = fhirPathDateTime2.dt();
        Temporal tdate = temporal2;
        Seq seq3 = (Seq)new FhirPathExpressionEvaluator(this.context, this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)period);
        Some some3 = Seq$.MODULE$.unapplySeq(seq3);
        if (some3.isEmpty() || some3.get() == null || ((SeqLike)some3.get()).lengthCompare(1) != 0 || !((fhirPathResult = (FhirPathResult)((SeqLike)some3.get()).apply(0)) instanceof FhirPathString)) throw new FhirPathException(new StringBuilder(161).append("Invalid function call 'getPeriod', the period expression ").append(period.getText()).append(" does not evaluate to a valid (valid values:  'years', 'months', 'weeks', 'days') time-valued quantity !").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        FhirPathString fhirPathString = (FhirPathString)fhirPathResult;
        String p = fhirPathString.s();
        String string = p;
        boolean bl = "year".equals(string) ? true : "years".equals(string);
        if (bl) {
            chronoUnit = ChronoUnit.YEARS;
        } else {
            boolean bl2 = "month".equals(string) ? true : "months".equals(string);
            if (bl2) {
                chronoUnit = ChronoUnit.MONTHS;
            } else {
                boolean bl3 = "week".equals(string) ? true : "weeks".equals(string);
                if (bl3) {
                    chronoUnit = ChronoUnit.WEEKS;
                } else {
                    boolean bl4 = "day".equals(string) ? true : "days".equals(string);
                    if (!bl4) throw new FhirPathException(new StringBuilder(160).append("Invalid function call 'getPeriod', the period expression ").append(period.getText()).append(" does not evaluate to a valid (valid values: 'years', 'months', 'weeks', 'days') time-valued quantity !").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
                    chronoUnit = ChronoUnit.DAYS;
                }
            }
        }
        ChronoUnit chronoUnit2 = chronoUnit;
        ChronoUnit chronoPeriod = chronoUnit2;
        try {
            Seq seq4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.long2bigDecimal(fdate.until(tdate, chronoPeriod)))}));
            return seq4;
        }
        catch (Throwable e) {
            throw FhirPathException$.MODULE$.apply("Invalid function call 'getPeriod', both date time instances should be either with zone or not!", e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(FhirPathFunctionEvaluator $this, FhirPathExprParser.ExpressionContext criteria$1, FhirPathResult c) {
        FhirPathBoolean fhirPathBoolean;
        boolean bl;
        FhirPathResult fhirPathResult;
        Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)criteria$1);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        boolean bl2 = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathBoolean && (bl = (fhirPathBoolean = (FhirPathBoolean)fhirPathResult).b());
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$all$1(FhirPathFunctionEvaluator $this, FhirPathExprParser.ExpressionContext criteria$2, FhirPathResult c) {
        FhirPathBoolean fhirPathBoolean;
        boolean bl;
        FhirPathResult fhirPathResult;
        Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)criteria$2);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        boolean bl2 = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathBoolean && (bl = (fhirPathBoolean = (FhirPathBoolean)fhirPathResult).b());
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$allTrue$1(FhirPathResult x$2) {
        return !(x$2 instanceof FhirPathBoolean);
    }

    public static final /* synthetic */ boolean $anonfun$allTrue$2(FhirPathResult c) {
        return ((FhirPathBoolean)c).b();
    }

    public static final /* synthetic */ boolean $anonfun$anyTrue$1(FhirPathResult x$3) {
        return !(x$3 instanceof FhirPathBoolean);
    }

    public static final /* synthetic */ boolean $anonfun$anyTrue$2(FhirPathResult c) {
        return ((FhirPathBoolean)c).b();
    }

    public static final /* synthetic */ boolean $anonfun$allFalse$1(FhirPathResult x$4) {
        return !(x$4 instanceof FhirPathBoolean);
    }

    public static final /* synthetic */ boolean $anonfun$allFalse$2(FhirPathResult c) {
        return !((FhirPathBoolean)c).b();
    }

    public static final /* synthetic */ boolean $anonfun$anyFalse$1(FhirPathResult x$5) {
        return !(x$5 instanceof FhirPathBoolean);
    }

    public static final /* synthetic */ boolean $anonfun$anyFalse$2(FhirPathResult c) {
        return !((FhirPathBoolean)c).b();
    }

    public static final /* synthetic */ boolean $anonfun$subsetOf$2(FhirPathResult c$1, FhirPathResult o) {
        return BoxesRunTime.unboxToBoolean((Object)c$1.isEqual(o).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$supersetOf$2(FhirPathResult o$1, FhirPathResult c) {
        return BoxesRunTime.unboxToBoolean((Object)c.isEqual(o$1).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$where$1(FhirPathFunctionEvaluator $this, FhirPathExprParser.ExpressionContext criteria$3, FhirPathResult c) {
        boolean bl;
        FhirPathBoolean fhirPathBoolean;
        boolean bl2;
        FhirPathResult fhirPathResult;
        Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, (Seq<FhirPathResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{c}))), FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)criteria$3);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (fhirPathResult = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathBoolean && (bl2 = (fhirPathBoolean = (FhirPathBoolean)fhirPathResult).b())) {
            bl = true;
        } else {
            FhirPathBoolean fhirPathBoolean2;
            boolean bl3;
            FhirPathResult fhirPathResult2;
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (fhirPathResult2 = (FhirPathResult)((SeqLike)some2.get()).apply(0)) instanceof FhirPathBoolean && !(bl3 = (fhirPathBoolean2 = (FhirPathBoolean)fhirPathResult2).b())) {
                bl = false;
            } else if (Nil$.MODULE$.equals(seq)) {
                bl = false;
            } else {
                throw new FhirPathException(new StringBuilder(75).append("Invalid criteria ").append(criteria$3.getText()).append(" function call 'where', it does not evaluate to boolean!!!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$intersect$2(FhirPathResult c$2, FhirPathResult o) {
        return BoxesRunTime.unboxToBoolean((Object)c$2.isEqual(o).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$exclude$2(FhirPathResult c$3, FhirPathResult o) {
        return BoxesRunTime.unboxToBoolean((Object)c$3.isEqual(o).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$checkSingleString$1(FhirPathResult x$6) {
        return !(x$6 instanceof FhirPathString);
    }

    public static final /* synthetic */ int $anonfun$substring$2(FhirPathFunctionEvaluator $this, FhirPathExprParser.ExpressionContext startExpr$1, FhirPathExprParser.ExpressionContext lexpr) {
        FhirPathNumber fhirPathNumber;
        FhirPathResult n;
        Seq seq = (Seq)new FhirPathExpressionEvaluator($this.context, $this.current, FhirPathExpressionEvaluator$.MODULE$.$lessinit$greater$default$3()).visit((ParseTree)lexpr);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((n = (FhirPathResult)((SeqLike)some.get()).apply(0)) instanceof FhirPathNumber) || !(fhirPathNumber = (FhirPathNumber)n).isInteger()) {
            throw new FhirPathException(new StringBuilder(82).append("Invalid function call 'substring', the length expression ").append(startExpr$1.getText()).append(" does not return integer!").toString(), FhirPathException$.MODULE$.$lessinit$greater$default$2());
        }
        int n2 = fhirPathNumber.v().toInt();
        return n2;
    }

    public static final /* synthetic */ boolean $anonfun$children$1(FhirPathResult x$7) {
        return x$7 instanceof FhirPathComplex;
    }

    public static final /* synthetic */ boolean $anonfun$sum$2(FhirPathResult x$10) {
        return !(x$10 instanceof FhirPathNumber);
    }

    public static final /* synthetic */ boolean $anonfun$groupBy$1(FhirPathResult x$14) {
        return x$14 instanceof FhirPathComplex;
    }

    public static final /* synthetic */ boolean $anonfun$groupBy$7(FhirPathResult x$18) {
        return !(x$18 instanceof FhirPathNumber);
    }

    public FhirPathFunctionEvaluator(FhirPathEnvironment context, Seq<FhirPathResult> current) {
        this.context = context;
        this.current = current;
    }
}

