/*
 * Decompiled with CFR 0.152.
 */
package io.onfhir.path;

import io.onfhir.path.FhirPathBoolean;
import io.onfhir.path.FhirPathDateTime;
import io.onfhir.path.FhirPathNumber;
import io.onfhir.path.FhirPathQuantity;
import io.onfhir.path.FhirPathResult;
import io.onfhir.path.FhirPathString;
import io.onfhir.path.FhirPathTime;
import io.onfhir.path.grammar.FhirPathExprBaseVisitor;
import io.onfhir.path.grammar.FhirPathExprParser;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;

public final class FhirPathLiteralEvaluator$
extends FhirPathExprBaseVisitor<Seq<FhirPathResult>> {
    public static FhirPathLiteralEvaluator$ MODULE$;
    private final DateTimeFormatter fhirPathDateTimeFormatter;
    private final Map<String, String> dtUnits;

    static {
        new FhirPathLiteralEvaluator$();
    }

    public DateTimeFormatter fhirPathDateTimeFormatter() {
        return this.fhirPathDateTimeFormatter;
    }

    private Map<String, String> dtUnits() {
        return this.dtUnits;
    }

    @Override
    public Seq<FhirPathResult> visitNullLiteral(FhirPathExprParser.NullLiteralContext ctx) {
        return Nil$.MODULE$;
    }

    @Override
    public Seq<FhirPathResult> visitBooleanLiteral(FhirPathExprParser.BooleanLiteralContext ctx) {
        FhirPathBoolean fhirPathBoolean;
        FhirPathResult[] fhirPathResultArray = new FhirPathResult[1];
        String string = ctx.getText();
        if ("true".equals(string)) {
            fhirPathBoolean = new FhirPathBoolean(true);
        } else if ("false".equals(string)) {
            fhirPathBoolean = new FhirPathBoolean(false);
        } else {
            throw new MatchError((Object)string);
        }
        fhirPathResultArray[0] = fhirPathBoolean;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fhirPathResultArray));
    }

    @Override
    public Seq<FhirPathResult> visitStringLiteral(FhirPathExprParser.StringLiteralContext ctx) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathString[]{new FhirPathString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(ctx.STRING().getText())).drop(1))).dropRight(1))}));
    }

    @Override
    public Seq<FhirPathResult> visitNumberLiteral(FhirPathExprParser.NumberLiteralContext ctx) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{this.parseNumberLiteral(ctx.NUMBER().getText())}));
    }

    @Override
    public Seq<FhirPathResult> visitDateTimeLiteral(FhirPathExprParser.DateTimeLiteralContext ctx) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathDateTime[]{new FhirPathDateTime(this.parseFhirDateTimeBest((String)new StringOps(Predef$.MODULE$.augmentString(ctx.DATETIME().getText())).drop(1)))}));
    }

    @Override
    public Seq<FhirPathResult> visitTimeLiteral(FhirPathExprParser.TimeLiteralContext ctx) {
        Tuple2<LocalTime, Option<ZoneOffset>> tuple2 = this.parseFhirTime((String)new StringOps(Predef$.MODULE$.augmentString(ctx.TIME().getText())).drop(1));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LocalTime lt = (LocalTime)tuple2._1();
        Option zdt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lt, (Object)zdt);
        Tuple2 tuple23 = tuple22;
        LocalTime lt2 = (LocalTime)tuple23._1();
        Option zdt2 = (Option)tuple23._2();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathTime[]{new FhirPathTime(lt2, (Option<ZoneId>)zdt2)}));
    }

    @Override
    public Seq<FhirPathResult> visitQuantityLiteral(FhirPathExprParser.QuantityLiteralContext ctx) {
        FhirPathNumber n = this.parseNumberLiteral(ctx.quantity().NUMBER().getText());
        FhirPathExprParser.UnitContext unitCtx = ctx.quantity().unit();
        String unit = unitCtx.dateTimePrecision() != null ? unitCtx.dateTimePrecision().getText() : (unitCtx.pluralDateTimePrecision() != null ? unitCtx.pluralDateTimePrecision().getText() : unitCtx.STRING().getText());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathQuantity[]{new FhirPathQuantity(n, (String)this.dtUnits().getOrElse((Object)unit, (Function0 & Serializable & scala.Serializable)() -> unit))}));
    }

    private FhirPathNumber parseNumberLiteral(String n) {
        return new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal(new StringOps(Predef$.MODULE$.augmentString(n)).toDouble()));
    }

    public Temporal parseFhirDateTimeBest(String dt) {
        return (Temporal)this.fhirPathDateTimeFormatter().parseBest(dt, x$2 -> ZonedDateTime.from(x$2), x$3 -> LocalDateTime.from(x$3), x$4 -> LocalDate.from(x$4), x$5 -> YearMonth.from(x$5), x$6 -> Year.from(x$6));
    }

    public String format(FhirPathDateTime dt) {
        return this.fhirPathDateTimeFormatter().format(dt.dt());
    }

    public String format(FhirPathTime t) {
        Comparable<ChronoLocalDateTime<?>> comparable;
        Option<ZoneId> option = t.zone();
        if (option instanceof Some) {
            Some some = (Some)option;
            ZoneId z = (ZoneId)some.value();
            comparable = LocalDate.of(2000, 1, 1).atTime(t.lt()).atZone(z);
        } else if (None$.MODULE$.equals(option)) {
            comparable = LocalDate.of(2000, 1, 1).atTime(t.lt());
        } else {
            throw new MatchError(option);
        }
        LocalDateTime temporal = comparable;
        return this.format(new FhirPathDateTime(temporal)).substring(10);
    }

    public Tuple2<LocalTime, Option<ZoneOffset>> parseFhirTime(String t) {
        Tuple2 tuple2;
        Temporal temporal = this.parseFhirDateTimeBest(new StringBuilder(10).append("2019-01-01").append(t).toString());
        if (temporal instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporal;
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)localDateTime.toLocalTime()), (Object)None$.MODULE$);
        } else if (temporal instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporal;
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zonedDateTime.toLocalTime()), (Object)new Some((Object)zonedDateTime.getOffset()));
        } else {
            throw new MatchError((Object)temporal);
        }
        return tuple2;
    }

    public String parseIdentifier(String identifier) {
        return BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(identifier)).head()) == '`' ? (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(identifier)).drop(1))).dropRight(1) : identifier;
    }

    private FhirPathLiteralEvaluator$() {
        MODULE$ = this;
        this.fhirPathDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy[-MM[-dd['T'HH[:mm[:ss[.SSS][XXX]]]]]]");
        this.dtUnits = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"year"), (Object)"'a'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"years"), (Object)"'a'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"month"), (Object)"'mo'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"months"), (Object)"'mo'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"week"), (Object)"'wk'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"weeks"), (Object)"'wk'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"day"), (Object)"'d'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"days"), (Object)"'d'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hour"), (Object)"'h'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hours"), (Object)"'h'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minute"), (Object)"'min'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minutes"), (Object)"'min'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"second"), (Object)"'s'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seconds"), (Object)"'s'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"millisecond"), (Object)"'ms'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"milliseconds"), (Object)"'ms'")}));
    }
}

