/*
 * Decompiled with CFR 0.152.
 */
package io.onfhir.path;

import io.onfhir.path.FhirPathBoolean;
import io.onfhir.path.FhirPathComplex;
import io.onfhir.path.FhirPathDateTime$;
import io.onfhir.path.FhirPathLiteralEvaluator$;
import io.onfhir.path.FhirPathNumber;
import io.onfhir.path.FhirPathResult;
import io.onfhir.path.FhirPathString;
import io.onfhir.path.FhirPathTime;
import io.onfhir.util.JsonFormatter$;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.ZoneId;
import org.json4s.JsonAST;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.Try$;

public final class FhirPathValueTransformer$ {
    public static FhirPathValueTransformer$ MODULE$;

    static {
        new FhirPathValueTransformer$();
    }

    public Seq<FhirPathResult> transform(JsonAST.JValue v2) {
        Seq seq;
        JsonAST.JValue jValue = v2;
        if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            List arr = jArray.arr();
            seq = (Seq)arr.flatMap((Function1 & Serializable & scala.Serializable)v -> MODULE$.transform((JsonAST.JValue)v), List$.MODULE$.canBuildFrom());
        } else if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathComplex[]{new FhirPathComplex(jObject)}));
        } else if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.int2bigDecimal(BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable((JsonAST.JValue)jInt).extract(JsonFormatter$.MODULE$.formats(), (Manifest)ManifestFactory$.MODULE$.Int()))))}));
        } else if (jValue instanceof JsonAST.JDouble) {
            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
            double num = jDouble.num();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal(num))}));
        } else if (jValue instanceof JsonAST.JDecimal) {
            JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
            BigDecimal num = jDecimal.num();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal(num.toDouble()))}));
        } else if (jValue instanceof JsonAST.JLong) {
            JsonAST.JLong jLong = (JsonAST.JLong)jValue;
            long num = jLong.num();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathNumber[]{new FhirPathNumber(BigDecimal$.MODULE$.double2bigDecimal((double)num))}));
        } else if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathResult[]{RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(jString.s())).head()))) ? this.resolveFromString(jString.s()) : new FhirPathString(jString.s())}));
        } else if (jValue instanceof JsonAST.JBool) {
            JsonAST.JBool jBool = (JsonAST.JBool)jValue;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FhirPathBoolean[]{new FhirPathBoolean(jBool.value())}));
        } else {
            seq = Nil$.MODULE$;
        }
        return seq;
    }

    private FhirPathResult resolveFromString(String str) {
        return (FhirPathResult)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FhirPathLiteralEvaluator$.MODULE$.parseFhirDateTimeBest(str)).toOption().map((Function1)FhirPathDateTime$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(str)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FhirPathValueTransformer$.$anonfun$resolveFromString$3(BoxesRunTime.unboxToChar((Object)x$1)))) == 3 ? (FhirPathResult)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FhirPathLiteralEvaluator$.MODULE$.parseFhirTime(new StringBuilder(1).append("T").append(str).toString())).toOption().map((Function1 & Serializable & scala.Serializable)t -> new FhirPathTime((LocalTime)t._1(), (Option<ZoneId>)((Option)t._2()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new FhirPathString(str)) : new FhirPathString(str));
    }

    public JsonAST.JValue serializeToJson(Seq<FhirPathResult> result) {
        JsonAST.JNull$ jNull$;
        Seq jsonValues = (Seq)result.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toJson(), Seq$.MODULE$.canBuildFrom());
        int n = jsonValues.length();
        switch (n) {
            case 0: {
                jNull$ = JsonAST.JNull$.MODULE$;
                break;
            }
            case 1: {
                jNull$ = (JsonAST.JValue)jsonValues.head();
                break;
            }
            default: {
                jNull$ = new JsonAST.JArray(jsonValues.toList());
                break;
            }
        }
        return jNull$;
    }

    public static final /* synthetic */ boolean $anonfun$resolveFromString$3(char x$1) {
        return x$1 == ':';
    }

    private FhirPathValueTransformer$() {
        MODULE$ = this;
    }
}

