/*
 * Copyright 2022 https://github.com/openapi-processor/openapi-parser
 * PDX-License-Identifier: Apache-2.0
 */

package io.openapiprocessor.jsonschema.validator.number.draft4;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.steps.SimpleStep;

public class Maximum4Step extends SimpleStep {

    public Maximum4Step (JsonSchema schema, JsonInstance instance) {
        super(schema, instance, Keywords.MAXIMUM);
    }

    @Override
    protected ValidationMessage getError () {
        return new Maximum4Error (schema, instance);
    }
}
