/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.JsonSchemaConverter;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.support.Nullness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonSchemasConverter
implements PropertyConverter<Collection<JsonSchema>> {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext;

    public JsonSchemasConverter(@UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext) {
        this.parentContext = parentContext;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        @NonNull Collection objects = Types.convertOrNull(location, value, Collection.class);
        if (objects == null) {
            return null;
        }
        JsonPointer parentLocation = JsonPointer.from(location);
        int index = 0;
        ArrayList<JsonSchema> result = new ArrayList<JsonSchema>();
        for (Object item : objects) {
            result.add(this.create(name, item, this.getLocation(parentLocation, index++)));
        }
        return Collections.unmodifiableCollection(result);
    }

    private @UnknownKeyFor @NonNull @Initialized JsonSchema create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        return Nullness.nonNull(new JsonSchemaConverter(this.parentContext).convert(name, value, location));
    }

    private @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized JsonPointer parent, @UnknownKeyFor @NonNull @Initialized int index) {
        return parent.getJsonPointer(String.valueOf(index));
    }
}

