/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.JsonPointerInvalidException;
import io.openapiprocessor.jsonschema.schema.JsonPointerSupport;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class JsonPointer {
    public static final @UnknownKeyFor @NonNull @Initialized JsonPointer EMPTY = new JsonPointer();
    private final @Nullable @UnknownKeyFor @Initialized String pointer;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> tokens;

    public static @UnknownKeyFor @NonNull @Initialized JsonPointer empty() {
        return EMPTY;
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized JsonPointer fromFragment(@UnknownKeyFor @NonNull @Initialized String fragment) {
        return JsonPointer.from(fragment);
    }

    public static @UnknownKeyFor @NonNull @Initialized JsonPointer from(@Nullable @UnknownKeyFor @Initialized String jsonPointer) {
        if (jsonPointer == null) {
            return EMPTY;
        }
        String pointer = jsonPointer;
        if (jsonPointer.startsWith("#")) {
            pointer = JsonPointer.decode(jsonPointer.substring(1));
        }
        return new JsonPointer(pointer);
    }

    private JsonPointer() {
        this.pointer = null;
        this.tokens = Collections.emptyList();
    }

    private JsonPointer(@UnknownKeyFor @NonNull @Initialized String jsonPointer) {
        if (jsonPointer.isEmpty()) {
            this.pointer = null;
            this.tokens = Collections.emptyList();
            return;
        }
        this.pointer = jsonPointer;
        if (!jsonPointer.startsWith("/")) {
            throw new JsonPointerInvalidException(jsonPointer);
        }
        this.tokens = Arrays.stream(jsonPointer.substring(1).split("/", -1)).map(JsonPointerSupport::decode).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized JsonPointer append(@UnknownKeyFor @NonNull @Initialized String token) {
        return new JsonPointer(this.getJsonPointer(token));
    }

    public @UnknownKeyFor @NonNull @Initialized JsonPointer append(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.append(String.valueOf(index));
    }

    public @UnknownKeyFor @NonNull @Initialized String getJsonPointer(@UnknownKeyFor @NonNull @Initialized String token) {
        String encoded = JsonPointerSupport.encode(token);
        if (this.pointer == null) {
            return "/" + encoded;
        }
        return this.pointer + "/" + encoded;
    }

    public @UnknownKeyFor @NonNull @Initialized URI toUri() {
        if (this.tokens.isEmpty()) {
            return URI.create("");
        }
        String escaped = this.tokens.stream().map(JsonPointerSupport::encode).collect(Collectors.joining("/"));
        return UriSupport.createUri("#/" + escaped);
    }

    public @UnknownKeyFor @NonNull @Initialized String tail() {
        if (this.tokens.isEmpty()) {
            return "";
        }
        return this.tokens.get(this.tokens.size() - 1);
    }

    public @UnknownKeyFor @NonNull @Initialized int tailIndex() {
        try {
            return Integer.parseInt(this.tokens.get(this.tokens.size() - 1));
        }
        catch (NumberFormatException ex) {
            throw new JsonPointerInvalidException(this.toString(), this.tail(), ex);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.pointer == null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPointer that = (JsonPointer)o;
        return Objects.equals(this.pointer, that.pointer);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.pointer);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.pointer != null ? this.pointer : "";
    }

    private static @UnknownKeyFor @NonNull @Initialized String encode(@UnknownKeyFor @NonNull @Initialized String pointer) {
        try {
            return URLEncoder.encode(pointer, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new JsonPointerInvalidException(pointer, ex);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String decode(@UnknownKeyFor @NonNull @Initialized String pointer) {
        try {
            String encoded = JsonPointerSupport.encodePath(pointer);
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new JsonPointerInvalidException(pointer, ex);
        }
    }
}

