/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.BooleanConverter;
import io.openapiprocessor.jsonschema.converter.BucketConverter;
import io.openapiprocessor.jsonschema.converter.IntegerConverter;
import io.openapiprocessor.jsonschema.converter.JsonSchemaConverter;
import io.openapiprocessor.jsonschema.converter.JsonSchemaRefConverter;
import io.openapiprocessor.jsonschema.converter.JsonSchemasConverter;
import io.openapiprocessor.jsonschema.converter.MapDependencyConverter;
import io.openapiprocessor.jsonschema.converter.MapJsonSchemasConverter;
import io.openapiprocessor.jsonschema.converter.MapSetStringsOrEmptyConverter;
import io.openapiprocessor.jsonschema.converter.NoValueException;
import io.openapiprocessor.jsonschema.converter.NumberConverter;
import io.openapiprocessor.jsonschema.converter.ResponseType;
import io.openapiprocessor.jsonschema.converter.StringNullableConverter;
import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.converter.UriConverter;
import io.openapiprocessor.jsonschema.converter.VocabularyConverter;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.InvalidPropertyException;
import io.openapiprocessor.jsonschema.schema.JsonDependency;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.JsonSchemas;
import io.openapiprocessor.jsonschema.schema.Reference;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import io.openapiprocessor.jsonschema.support.Nullness;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class JsonSchemaObject
implements JsonSchema {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context;
    private final @UnknownKeyFor @NonNull @Initialized Bucket schemaObject;
    private final @UnknownKeyFor @NonNull @Initialized Bucket schemaProperties;

    public JsonSchemaObject(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document, @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context) {
        this.context = context;
        this.schemaObject = new Bucket(context.getScope(), document);
        this.schemaProperties = this.getBucketProperties(this.schemaObject);
    }

    public JsonSchemaObject(@UnknownKeyFor @NonNull @Initialized JsonPointer location, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document, @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context) {
        this.context = context;
        this.schemaObject = new Bucket(context.getScope(), location, document);
        this.schemaProperties = this.getBucketProperties(this.schemaObject);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchemaContext getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getLocation() {
        return this.schemaObject.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRef() {
        return this.schemaObject.hasProperty("$ref");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getRef() {
        return this.schemaObject.convert("$ref", new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getAnchor() {
        return this.schemaObject.convert("$anchor", new StringNullableConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isDynamicRef() {
        if (this.context.getVersion() == SchemaVersion.Draft201909) {
            return this.schemaObject.hasProperty("$recursiveRef");
        }
        return this.schemaObject.hasProperty("$dynamicRef");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getDynamicRef() {
        if (this.context.getVersion() == SchemaVersion.Draft201909) {
            return this.schemaObject.convert("$recursiveRef", new UriConverter());
        }
        return this.schemaObject.convert("$dynamicRef", new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getDynamicAnchor() {
        if (this.context.getVersion() == SchemaVersion.Draft201909) {
            Boolean anchor = this.schemaObject.convert("$recursiveAnchor", new BooleanConverter());
            if (anchor == null || !anchor.booleanValue()) {
                return null;
            }
            return "#";
        }
        return this.schemaObject.convert("$dynamicAnchor", new StringNullableConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchema getRefSchema() {
        Reference reference = this.context.getReference(Nullness.nonNull(this.getRef()));
        JsonSchemaContext refContext = this.context.withScope(reference.getValueScope());
        JsonSchema schema = (JsonSchema)new JsonSchemaRefConverter(refContext).convert("$ref", reference.getValue(), reference.getPointer());
        if (schema == null) {
            throw new NoValueException(this.getLocation().append("$ref"));
        }
        return schema;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchema getRefSchema(@Nullable @UnknownKeyFor @Initialized URI dynamicScope) {
        if (dynamicScope == null) {
            Reference reference = this.context.getReference(Nullness.nonNull(this.getDynamicRef()));
            JsonSchemaContext refContext = this.context.withScope(reference.getValueScope());
            JsonSchema schema = (JsonSchema)new JsonSchemaRefConverter(refContext).convert("$dynamicRef", reference.getValue(), reference.getPointer());
            if (schema == null) {
                throw new NoValueException(this.getLocation().append("$dynamicRef"));
            }
            return schema;
        }
        URI dynamicRef = Nullness.nonNull(this.getDynamicRef());
        String fragment = dynamicRef.getFragment();
        Reference reference = this.context.getDynamicReference(dynamicRef = UriSupport.createUri("#" + fragment), dynamicScope);
        JsonSchemaContext refContext = this.context.withScope(reference.getValueScope());
        JsonSchema schema = (JsonSchema)new JsonSchemaRefConverter(refContext).convert("$dynamicRef", reference.getValue(), reference.getPointer());
        if (schema == null) {
            throw new NoValueException(this.getLocation().append("$dynamicRef"));
        }
        return schema;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getMetaSchema() {
        return this.schemaObject.convert("$schema", new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getMetaSchemaSchema() {
        URI metaSchemaUri = this.getMetaSchema();
        if (metaSchemaUri == null) {
            return null;
        }
        Reference reference = this.context.getReference(metaSchemaUri);
        return (JsonSchema)new JsonSchemaConverter(this.context).convert("$schema", reference.getValue(), reference.getPointer());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Vocabularies getVocabulary() {
        return this.schemaObject.convert("$vocabulary", new VocabularyConverter(this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getId() {
        if (this.context.getVersion() == SchemaVersion.Draft4) {
            return this.schemaObject.convert("id", new UriConverter());
        }
        return this.schemaObject.convert("$id", new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getMultipleOf() {
        return this.schemaObject.convert("multipleOf", new NumberConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getMaximum() {
        return this.schemaObject.convert("maximum", new NumberConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean getExclusiveMaximumB() {
        Boolean exclusive = this.schemaObject.convert("exclusiveMaximum", new BooleanConverter());
        if (exclusive == null) {
            return false;
        }
        return exclusive;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getExclusiveMaximum() {
        return this.schemaObject.convert("exclusiveMaximum", new NumberConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getMinimum() {
        return this.schemaObject.convert("minimum", new NumberConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean getExclusiveMinimumB() {
        Boolean exclusive = this.schemaObject.convert("exclusiveMinimum", new BooleanConverter());
        if (exclusive == null) {
            return false;
        }
        return exclusive;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getExclusiveMinimum() {
        return this.schemaObject.convert("exclusiveMinimum", new NumberConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxLength() {
        return this.schemaObject.convert("maxLength", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMinLength() {
        return this.schemaObject.convert("minLength", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getPattern() {
        return this.schemaObject.convert("pattern", new StringNullableConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getPrefixItems() {
        Collection<JsonSchema> prefixItems = this.getJsonSchemasOf("prefixItems");
        if (prefixItems == null) {
            return Collections.emptyList();
        }
        return prefixItems;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchemas getItems() {
        Collection<JsonSchema> items;
        boolean exists = this.schemaObject.hasProperty("items");
        if (!exists) {
            return new JsonSchemas();
        }
        Object raw = this.schemaObject.getRawValue("items");
        if (Types.isSchema(raw)) {
            return new JsonSchemas(this.getJsonSchemaOf("items"));
        }
        if (Types.isArray(raw) && (items = this.getJsonSchemasOf("items")) != null) {
            return new JsonSchemas(items);
        }
        throw new InvalidPropertyException(this.getLocation().append("items"));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchemas getAdditionalItems() {
        boolean exists = this.schemaObject.hasProperty("additionalItems");
        if (!exists) {
            return new JsonSchemas();
        }
        Object raw = this.schemaObject.getRawValue("additionalItems");
        if (raw == null) {
            return new JsonSchemas((JsonSchema)null);
        }
        return new JsonSchemas(this.getJsonSchemaOf("additionalItems"));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getUnevaluatedItems() {
        return this.getJsonSchemaOf("unevaluatedItems");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxItems() {
        return this.schemaObject.convert("maxItems", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMinItems() {
        return this.schemaObject.convert("minItems", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Boolean isUniqueItems() {
        return this.schemaObject.convert("uniqueItems", new BooleanConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getContains() {
        return this.getJsonSchemaOf("contains");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer getMinContains() {
        Integer minContains = this.schemaObject.convert("minContains", new IntegerConverter());
        if (minContains == null) {
            return 1;
        }
        return minContains;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxContains() {
        return this.schemaObject.convert("maxContains", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxProperties() {
        return this.schemaObject.convert("maxProperties", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMinProperties() {
        return this.schemaObject.convert("minProperties", new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getRequired() {
        Object raw = this.schemaObject.getRawValue("required");
        if (raw == null) {
            return null;
        }
        return Collections.unmodifiableCollection(Types.asCol(raw));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> getProperties() {
        Map<String, JsonSchema> properties = this.schemaObject.convert("properties", new MapJsonSchemasConverter(this.context));
        if (properties == null) {
            return Collections.emptyMap();
        }
        return properties;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> getPatternProperties() {
        Map<String, JsonSchema> patternProperties = this.schemaObject.convert("patternProperties", new MapJsonSchemasConverter(this.context));
        if (patternProperties == null) {
            return Collections.emptyMap();
        }
        return patternProperties;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getAdditionalProperties() {
        return this.getJsonSchemaOf("additionalProperties");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getUnevaluatedProperties() {
        return this.getJsonSchemaOf("unevaluatedProperties");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonDependency> getDependencies() {
        return this.schemaObject.convert("dependencies", new MapDependencyConverter(this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> getDependentSchemas() {
        return this.schemaObject.convert("dependentSchemas", new MapJsonSchemasConverter(this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> getDependentRequired() {
        return this.schemaObject.convert("dependentRequired", new MapSetStringsOrEmptyConverter(ResponseType.Null));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getPropertyNames() {
        return this.getJsonSchemaOf("propertyNames");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getJsonSchema(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.schemaProperties.convert(property, new JsonSchemaConverter(this.context));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonInstance> getEnum() {
        Object raw = this.schemaObject.getRawValue("enum");
        if (raw == null) {
            return Collections.emptyList();
        }
        if (raw instanceof Collection) {
            ArrayList<JsonInstance> instances = new ArrayList<JsonInstance>();
            int index = 0;
            for (Object o : Types.asCol(raw)) {
                JsonInstance instance = new JsonInstance(this.getLocation().append("enum").append(index), o);
                instances.add(instance);
                ++index;
            }
            return Collections.unmodifiableCollection(instances);
        }
        throw new RuntimeException();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonInstance getConst() {
        if (!this.schemaObject.hasProperty("const")) {
            return null;
        }
        Object raw = this.schemaObject.getRawValue("const");
        return new JsonInstance(this.getLocation().append("const"), raw);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getType() {
        boolean exists = this.schemaObject.hasProperty("type");
        if (!exists) {
            return Collections.emptyList();
        }
        Object raw = this.schemaObject.getRawValue("type");
        if (raw instanceof String) {
            String type = Types.convert("", raw, String.class);
            return Collections.singletonList(type);
        }
        if (raw instanceof Collection) {
            return Collections.unmodifiableCollection(Types.asCol(raw));
        }
        throw new RuntimeException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getAllOf() {
        Collection<JsonSchema> allOf = this.getJsonSchemasOf("allOf");
        if (allOf == null) {
            return Collections.emptyList();
        }
        return allOf;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getAnyOf() {
        Collection<JsonSchema> anyOf = this.getJsonSchemasOf("anyOf");
        if (anyOf == null) {
            return Collections.emptyList();
        }
        return anyOf;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getOneOf() {
        Collection<JsonSchema> oneOf = this.getJsonSchemasOf("oneOf");
        if (oneOf == null) {
            return Collections.emptyList();
        }
        return oneOf;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getNot() {
        return this.getJsonSchemaOf("not");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getFormat() {
        return this.schemaObject.convert("format", new StringNullableConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getIf() {
        return this.getJsonSchemaOf("if");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getThen() {
        return this.getJsonSchemaOf("then");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getElse() {
        return this.getJsonSchemaOf("else");
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String location = this.schemaObject.getLocation().toString();
        if (location == null) {
            return String.format("%s", this.context.getScope());
        }
        return String.format("%s", this.schemaObject.getLocation());
    }

    private @Nullable @UnknownKeyFor @Initialized JsonSchema getJsonSchemaOf(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.schemaObject.convert(property, new JsonSchemaConverter(this.context));
    }

    private @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getJsonSchemasOf(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.schemaObject.convert(property, new JsonSchemasConverter(this.context));
    }

    private @UnknownKeyFor @NonNull @Initialized Bucket getBucketProperties(@UnknownKeyFor @NonNull @Initialized Bucket schemaBucket) {
        Bucket bucket = schemaBucket.convert("properties", new BucketConverter(schemaBucket));
        if (bucket == null) {
            return Bucket.empty();
        }
        return bucket;
    }
}

