/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.IdProvider;
import io.openapiprocessor.jsonschema.schema.Keyword;
import io.openapiprocessor.jsonschema.schema.SchemaKeywords;
import io.openapiprocessor.jsonschema.schema.SchemaResource;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public enum SchemaVersion {
    Draft202012(new SchemaResource("https://json-schema.org/draft/2020-12/schema", "/json-schema.org/draft/2020-12/schema"), SchemaKeywords.draft202012, IdProvider.DRAFT201909, Arrays.asList(new SchemaResource("https://json-schema.org/draft/2020-12/meta/applicator", "/json-schema.org/draft/2020-12/meta/applicator"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/content", "/json-schema.org/draft/2020-12/meta/content"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/core", "/json-schema.org/draft/2020-12/meta/core"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/format-annotation", "/json-schema.org/draft/2020-12/meta/format-annotation"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/format-assertion", "/json-schema.org/draft/2020-12/meta/format-assertion"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/hyper-schema", "/json-schema.org/draft/2020-12/meta/hyper-schema"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/meta-data", "/json-schema.org/draft/2020-12/meta/meta-data"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/unevaluated", "/json-schema.org/draft/2020-12/meta/unevaluated"), new SchemaResource("https://json-schema.org/draft/2020-12/meta/validation", "/json-schema.org/draft/2020-12/meta/validation"))),
    Draft201909(new SchemaResource("https://json-schema.org/draft/2019-09/schema", "/json-schema.org/draft/2019-09/schema"), SchemaKeywords.draft201909, IdProvider.DRAFT201909, Arrays.asList(new SchemaResource("https://json-schema.org/draft/2019-09/meta/applicator", "/json-schema.org/draft/2019-09/meta/applicator"), new SchemaResource("https://json-schema.org/draft/2019-09/meta/content", "/json-schema.org/draft/2019-09/meta/content"), new SchemaResource("https://json-schema.org/draft/2019-09/meta/core", "/json-schema.org/draft/2019-09/meta/core"), new SchemaResource("https://json-schema.org/draft/2019-09/meta/format", "/json-schema.org/draft/2019-09/meta/format"), new SchemaResource("https://json-schema.org/draft/2019-09/meta/meta-data", "/json-schema.org/draft/2019-09/meta/meta-data"), new SchemaResource("https://json-schema.org/draft/2019-09/meta/validation", "/json-schema.org/draft/2019-09/meta/validation"))),
    Draft7(new SchemaResource("http://json-schema.org/draft-07/schema#", "/json-schema.org/draft-07/schema"), SchemaKeywords.draft7, IdProvider.DRAFT7),
    Draft6(new SchemaResource("http://json-schema.org/draft-06/schema#", "/json-schema.org/draft-06/schema"), SchemaKeywords.draft6, IdProvider.DRAFT6),
    Draft4(new SchemaResource("http://json-schema.org/draft-04/schema#", "/json-schema.org/draft-04/schema"), SchemaKeywords.draft4, IdProvider.DRAFT4);

    private final @UnknownKeyFor @NonNull @Initialized SchemaResource schema;
    private final @UnknownKeyFor @NonNull @Initialized SchemaKeywords keywords;
    private final @UnknownKeyFor @NonNull @Initialized IdProvider idProvider;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaResource> vocabularies = new HashSet<SchemaResource>();

    private SchemaVersion(@UnknownKeyFor @NonNull @Initialized SchemaResource schema, SchemaKeywords keywords, IdProvider idProvider) {
        this.schema = schema;
        this.keywords = keywords;
        this.idProvider = idProvider;
    }

    private SchemaVersion(@UnknownKeyFor @NonNull @Initialized SchemaResource schema, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized SchemaKeywords keywords, IdProvider idProvider, Collection<SchemaResource> vocabularies) {
        this.schema = schema;
        this.keywords = keywords;
        this.idProvider = idProvider;
        this.vocabularies.addAll(vocabularies);
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaVersion getLatest() {
        return Draft201909;
    }

    public static @Nullable @UnknownKeyFor @Initialized SchemaVersion getVersion(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        if (Draft202012.getSchemaUri().equals(schemaUri)) {
            return Draft202012;
        }
        if (Draft201909.getSchemaUri().equals(schemaUri)) {
            return Draft201909;
        }
        if (Draft7.getSchemaUri().equals(schemaUri)) {
            return Draft7;
        }
        if (Draft6.getSchemaUri().equals(schemaUri)) {
            return Draft6;
        }
        if (Draft4.getSchemaUri().equals(schemaUri)) {
            return Draft4;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaVersion getVersion(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized SchemaVersion fallback) {
        SchemaVersion version = SchemaVersion.getVersion(uri);
        if (version == null) {
            return fallback;
        }
        return version;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getSchemaUri() {
        return this.schema.getUri();
    }

    @UnknownKeyFor @NonNull @Initialized SchemaResource getSchemaResource() {
        return this.schema;
    }

    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaResource> getVocabularyResources() {
        return this.vocabularies;
    }

    public @Nullable @UnknownKeyFor @Initialized Keyword getKeyword(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.keywords.getKeyword(name);
    }

    public @UnknownKeyFor @NonNull @Initialized IdProvider getIdProvider() {
        return this.idProvider;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validatesRefSiblings() {
        return this.isLaterOrEqualTo201909();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isLaterOrEqualTo201909() {
        return this.compareTo(Draft201909) <= 0;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isBefore202012() {
        return this.compareTo(Draft202012) > 0;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isBefore201909() {
        return this.compareTo(Draft201909) > 0;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isApplicatorVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        return this.isVocabulary(candidate, "/vocab/applicator");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isContentVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        return this.isVocabulary(candidate, "/vocab/content");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCoreVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        return this.isVocabulary(candidate, "/vocab/core");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isFormatAnnotationVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        if (this == Draft201909) {
            return this.isVocabulary(candidate, "/vocab/format");
        }
        return this.isVocabulary(candidate, "/vocab/format-annotation");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isFormatAssertionVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        if (this == Draft201909) {
            return this.isVocabulary(candidate, "/vocab/format");
        }
        return this.isVocabulary(candidate, "/vocab/format-assertion");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMetaDataVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        return this.isVocabulary(candidate, "/vocab/meta-data");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isValidationVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate) {
        return this.isVocabulary(candidate, "/vocab/validation");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVocabulary(@UnknownKeyFor @NonNull @Initialized URI candidate, @UnknownKeyFor @NonNull @Initialized String vocabulary) {
        String parentUri = this.getSchemaParentUri();
        String candidateUri = candidate.toString();
        boolean matchParent = candidateUri.startsWith(parentUri);
        boolean matchCore = candidateUri.endsWith(vocabulary);
        return matchParent && matchCore;
    }

    private @UnknownKeyFor @NonNull @Initialized String getSchemaParentUri() {
        String uri = this.getSchemaUri().toString();
        return uri.substring(0, uri.lastIndexOf("/"));
    }
}

