/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.schema.IdProvider;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import io.openapiprocessor.jsonschema.support.Nullness;
import java.net.URI;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Scope {
    private final @UnknownKeyFor @NonNull @Initialized URI documentUri;
    private final @UnknownKeyFor @NonNull @Initialized URI baseUri;
    private final @UnknownKeyFor @NonNull @Initialized SchemaVersion version;

    public Scope(@UnknownKeyFor @NonNull @Initialized URI documentUri, @Nullable @UnknownKeyFor @Initialized URI id, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        this.documentUri = documentUri;
        this.baseUri = UriSupport.isEmpty(id) ? documentUri : Nullness.nonNull(id);
        this.version = version;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getDocumentUri() {
        return this.documentUri;
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized URI getId() {
        return this.baseUri;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getBaseUri() {
        return this.baseUri;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaVersion getVersion() {
        return this.version;
    }

    public @UnknownKeyFor @NonNull @Initialized Scope resolve(@UnknownKeyFor @NonNull @Initialized String id) {
        URI resolved = UriSupport.resolve(this.baseUri, id);
        if (resolved.equals(this.baseUri)) {
            return this;
        }
        return new Scope(this.documentUri, resolved, this.version);
    }

    public @UnknownKeyFor @NonNull @Initialized Scope resolve(@UnknownKeyFor @NonNull @Initialized URI id) {
        URI resolved = UriSupport.resolve(this.baseUri, id);
        if (resolved.equals(this.baseUri)) {
            return this;
        }
        return new Scope(this.documentUri, resolved, this.version);
    }

    public @UnknownKeyFor @NonNull @Initialized URI resolveAnchor(@UnknownKeyFor @NonNull @Initialized String anchor) {
        return UriSupport.resolve(this.baseUri, "#" + anchor);
    }

    public @UnknownKeyFor @NonNull @Initialized Scope move(@UnknownKeyFor @NonNull @Initialized URI documentUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        return Scope.createScope(documentUri, document, this);
    }

    public @UnknownKeyFor @NonNull @Initialized Scope move(@UnknownKeyFor @NonNull @Initialized Object document) {
        return Scope.createScope(this.baseUri, document, this);
    }

    public static @UnknownKeyFor @NonNull @Initialized Scope createScope(@UnknownKeyFor @NonNull @Initialized URI documentUri, @UnknownKeyFor @NonNull @Initialized Object document, @UnknownKeyFor @NonNull @Initialized SchemaVersion fallback) {
        SchemaVersion version = Scope.getSchemaVersion(documentUri, document, fallback);
        if (!Types.isObject(document)) {
            return new Scope(documentUri, null, version);
        }
        IdProvider provider = version.getIdProvider();
        String id = provider.getId(Types.asMap(document));
        if (id == null) {
            return new Scope(documentUri, null, version);
        }
        return new Scope(documentUri, UriSupport.resolve(documentUri, id), version);
    }

    public static @UnknownKeyFor @NonNull @Initialized Scope createScope(@UnknownKeyFor @NonNull @Initialized URI documentUri, @UnknownKeyFor @NonNull @Initialized Object document, @UnknownKeyFor @NonNull @Initialized Scope currentScope) {
        SchemaVersion version = Scope.getSchemaVersion(documentUri, document, currentScope.getVersion());
        if (!Types.isObject(document)) {
            return new Scope(documentUri, null, version);
        }
        IdProvider provider = version.getIdProvider();
        String id = provider.getId(Types.asMap(document));
        if (id == null) {
            return new Scope(documentUri, null, version);
        }
        URI idUri = URI.create(id);
        boolean absolute = idUri.isAbsolute();
        if (absolute) {
            return new Scope(documentUri, URI.create(id), version);
        }
        return new Scope(documentUri, UriSupport.resolve(currentScope.getBaseUri(), id), version);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("base: %s (%s) (doc: %s)", new Object[]{this.baseUri, this.version, this.documentUri});
    }

    private static @UnknownKeyFor @NonNull @Initialized SchemaVersion getSchemaVersion(@UnknownKeyFor @NonNull @Initialized URI documentUri, @UnknownKeyFor @NonNull @Initialized Object document, @UnknownKeyFor @NonNull @Initialized SchemaVersion fallback) {
        URI metaSchema = Scope.getMetaSchema(document);
        if (metaSchema != null) {
            return SchemaVersion.getVersion(metaSchema, fallback);
        }
        return SchemaVersion.getVersion(documentUri, fallback);
    }

    private static @Nullable @UnknownKeyFor @Initialized URI getMetaSchema(@UnknownKeyFor @NonNull @Initialized Object document) {
        if (!Types.isObject(document)) {
            return null;
        }
        Map<String, Object> object = Types.asObject(document);
        Object schema = object.get("$schema");
        if (!Types.isString(schema)) {
            return null;
        }
        return UriSupport.createUri(Types.asString(schema));
    }
}

