/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.support.Nullness;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UriSupport {
    public static final @UnknownKeyFor @NonNull @Initialized String EMPTY_FRAGMENT = "#";

    public static @UnknownKeyFor @NonNull @Initialized URI emptyUri() {
        return URI.create("");
    }

    public static @UnknownKeyFor @NonNull @Initialized URI emptyFragment() {
        return URI.create(EMPTY_FRAGMENT);
    }

    public static @UnknownKeyFor @NonNull @Initialized URI createUri(@UnknownKeyFor @NonNull @Initialized String source) {
        return URI.create(UriSupport.encodePath(source));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isEmpty(@Nullable @UnknownKeyFor @Initialized URI uri) {
        return uri == null || uri.equals(UriSupport.emptyUri());
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasEmptyFragment(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return uri.toString().endsWith(EMPTY_FRAGMENT);
    }

    public static @UnknownKeyFor @NonNull @Initialized URI resolve(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized String child) {
        return UriSupport.resolve(uri, UriSupport.createUri(child));
    }

    public static @UnknownKeyFor @NonNull @Initialized URI resolve(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized URI child) {
        if (uri.isOpaque()) {
            return UriSupport.resolveOpaque(uri, child);
        }
        return uri.resolve(child);
    }

    private static @UnknownKeyFor @NonNull @Initialized URI resolveOpaque(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized URI part) {
        if (uri.equals(part)) {
            return uri;
        }
        if (part.isAbsolute()) {
            return part;
        }
        String uriPath = uri.getFragment() != null ? uri.getFragment() : "";
        int uriIdx = uriPath.indexOf("/");
        String uriId = uriIdx >= 0 ? uriPath.substring(0, uriIdx) : uriPath;
        String uriPointer = uriIdx >= 0 ? uriPath.substring(uriIdx) : "";
        String partPath = part.getFragment() != null ? part.getFragment() : "";
        int partIdx = partPath.indexOf("/");
        String partId = partIdx >= 0 ? partPath.substring(0, partIdx) : partPath;
        String partPointer = partIdx >= 0 ? partPath.substring(partIdx) : "";
        String id = uriId;
        if (!partId.isEmpty()) {
            id = partId;
        }
        String uriValue = uri.toString();
        if (!uriPath.isEmpty()) {
            uriValue = uriValue.substring(0, uriValue.lastIndexOf(EMPTY_FRAGMENT));
        }
        String pointer = UriSupport.resolve(UriSupport.createUri(uriPointer), UriSupport.createUri(partPointer)).toString();
        Object newUri = uriValue;
        if (!id.isEmpty() || !pointer.isEmpty()) {
            newUri = (String)newUri + EMPTY_FRAGMENT + id + pointer;
        }
        return UriSupport.createUri((String)newUri);
    }

    public static @UnknownKeyFor @NonNull @Initialized URI stripFragment(@UnknownKeyFor @NonNull @Initialized URI uri) {
        if (uri.isOpaque()) {
            return UriSupport.stripFragmentFromOpaqueUri(uri);
        }
        return UriSupport.stripFragmentFromNonOpaqueUri(uri);
    }

    private static @UnknownKeyFor @NonNull @Initialized URI stripFragmentFromNonOpaqueUri(@UnknownKeyFor @NonNull @Initialized URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), Nullness.nullable(null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized URI stripFragmentFromOpaqueUri(@UnknownKeyFor @NonNull @Initialized URI uri) {
        String opaque = uri.toString();
        int fragIndex = opaque.lastIndexOf(EMPTY_FRAGMENT);
        if (fragIndex < 0) {
            return uri;
        }
        return UriSupport.createUri(opaque.substring(0, fragIndex));
    }

    public static @UnknownKeyFor @NonNull @Initialized URI stripEmptyFragment(@UnknownKeyFor @NonNull @Initialized URI uri) {
        if (UriSupport.hasEmptyFragment(uri)) {
            return UriSupport.stripFragment(uri);
        }
        return uri;
    }

    public static @UnknownKeyFor @NonNull @Initialized String encodePath(@UnknownKeyFor @NonNull @Initialized String source) {
        return source.replace("{", "%7B").replace("}", "%7D");
    }

    public static @UnknownKeyFor @NonNull @Initialized String decodePath(@UnknownKeyFor @NonNull @Initialized String source) {
        return source.replace("%7B", "{").replace("%7D", "}");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasFragment(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return uri.toString().contains(EMPTY_FRAGMENT);
    }

    public static @UnknownKeyFor @NonNull @Initialized String encode(@UnknownKeyFor @NonNull @Initialized String source) {
        try {
            return URLEncoder.encode(source, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String decode(@UnknownKeyFor @NonNull @Initialized String source) {
        try {
            return URLDecoder.decode(source, StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

