/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Vocabularies {
    public static final @UnknownKeyFor @NonNull @Initialized Vocabularies ALL = new Vocabularies();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Boolean> vocabularies;
    private final @UnknownKeyFor @NonNull @Initialized SchemaVersion version;
    private @UnknownKeyFor @NonNull @Initialized State applicator = State.REQUIRED;
    private @UnknownKeyFor @NonNull @Initialized State content = State.REQUIRED;
    private @UnknownKeyFor @NonNull @Initialized State core = State.REQUIRED;
    private @UnknownKeyFor @NonNull @Initialized State formatAnnotation = State.REQUIRED;
    private @UnknownKeyFor @NonNull @Initialized State formatAssertion = State.REQUIRED;
    private @UnknownKeyFor @NonNull @Initialized State metaData = State.REQUIRED;
    private @UnknownKeyFor @NonNull @Initialized State validation = State.REQUIRED;

    private Vocabularies() {
        this.vocabularies = Collections.emptyMap();
        this.version = SchemaVersion.getLatest();
    }

    public Vocabularies(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Boolean> vocabularies, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        this.vocabularies = vocabularies;
        this.version = version;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasApplicator() {
        return this.applicator.ordinal() > State.MISSING.ordinal();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasContent() {
        return this.content.ordinal() > State.MISSING.ordinal();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasFormatAnnotation() {
        return this.formatAnnotation.ordinal() > State.MISSING.ordinal();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasFormatAssertion() {
        return this.formatAssertion.ordinal() > State.MISSING.ordinal();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasMetaData() {
        return this.metaData.ordinal() > State.MISSING.ordinal();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasValidation() {
        return this.validation.ordinal() > State.MISSING.ordinal();
    }

    public static @UnknownKeyFor @NonNull @Initialized Vocabularies create(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Boolean> vocabularies, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        Vocabularies result = new Vocabularies(vocabularies, version);
        result.applicator = Vocabularies.getState(vocabularies, version, version::isApplicatorVocabulary);
        result.content = Vocabularies.getState(vocabularies, version, version::isContentVocabulary);
        result.core = Vocabularies.getState(vocabularies, version, version::isCoreVocabulary);
        result.formatAnnotation = Vocabularies.getState(vocabularies, version, version::isFormatAnnotationVocabulary);
        result.formatAssertion = Vocabularies.getState(vocabularies, version, version::isFormatAssertionVocabulary);
        result.metaData = Vocabularies.getState(vocabularies, version, version::isMetaDataVocabulary);
        result.validation = Vocabularies.getState(vocabularies, version, version::isValidationVocabulary);
        if (result.core != State.REQUIRED) {
            throw new RuntimeException();
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized State getState(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Boolean> vocabularies, @UnknownKeyFor @NonNull @Initialized SchemaVersion version, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized URI> predicate) {
        if (version.isBefore201909()) {
            return State.REQUIRED;
        }
        return vocabularies.keySet().stream().filter(predicate).findFirst().map(v -> (Boolean)vocabularies.get(v) != false ? State.REQUIRED : State.OPTIONAL).orElse(State.MISSING);
    }

    private static enum State {
        MISSING,
        OPTIONAL,
        REQUIRED;

    }
}

