/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaBoolean;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.any.AllOfStep;
import io.openapiprocessor.jsonschema.validator.any.AnyOfStep;
import io.openapiprocessor.jsonschema.validator.any.ConstStep;
import io.openapiprocessor.jsonschema.validator.any.EnumStep;
import io.openapiprocessor.jsonschema.validator.any.IfStep;
import io.openapiprocessor.jsonschema.validator.any.NotStep;
import io.openapiprocessor.jsonschema.validator.any.OneOfStep;
import io.openapiprocessor.jsonschema.validator.any.Type;
import io.openapiprocessor.jsonschema.validator.array.Contains;
import io.openapiprocessor.jsonschema.validator.array.Items;
import io.openapiprocessor.jsonschema.validator.array.ItemsX;
import io.openapiprocessor.jsonschema.validator.array.MaxItems;
import io.openapiprocessor.jsonschema.validator.array.MinItems;
import io.openapiprocessor.jsonschema.validator.array.UniqueItems;
import io.openapiprocessor.jsonschema.validator.bool.Boolean;
import io.openapiprocessor.jsonschema.validator.conditional.DependentSchemas;
import io.openapiprocessor.jsonschema.validator.number.ExclusiveMaximum;
import io.openapiprocessor.jsonschema.validator.number.ExclusiveMinimum;
import io.openapiprocessor.jsonschema.validator.number.Maximum;
import io.openapiprocessor.jsonschema.validator.number.Minimum;
import io.openapiprocessor.jsonschema.validator.number.MultipleOf;
import io.openapiprocessor.jsonschema.validator.number.draft4.Maximum4;
import io.openapiprocessor.jsonschema.validator.number.draft4.Minimum4;
import io.openapiprocessor.jsonschema.validator.object.Dependencies;
import io.openapiprocessor.jsonschema.validator.object.DependentRequired;
import io.openapiprocessor.jsonschema.validator.object.MaxProperties;
import io.openapiprocessor.jsonschema.validator.object.MinProperties;
import io.openapiprocessor.jsonschema.validator.object.Properties;
import io.openapiprocessor.jsonschema.validator.object.PropertyNames;
import io.openapiprocessor.jsonschema.validator.object.Required;
import io.openapiprocessor.jsonschema.validator.steps.DynamicRefStep;
import io.openapiprocessor.jsonschema.validator.steps.RefStep;
import io.openapiprocessor.jsonschema.validator.steps.SchemaStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.DateTime;
import io.openapiprocessor.jsonschema.validator.string.Email;
import io.openapiprocessor.jsonschema.validator.string.Hostname;
import io.openapiprocessor.jsonschema.validator.string.IpV4;
import io.openapiprocessor.jsonschema.validator.string.IpV6;
import io.openapiprocessor.jsonschema.validator.string.MaxLength;
import io.openapiprocessor.jsonschema.validator.string.MinLength;
import io.openapiprocessor.jsonschema.validator.string.Pattern;
import io.openapiprocessor.jsonschema.validator.string.Regex;
import io.openapiprocessor.jsonschema.validator.string.Uri;
import io.openapiprocessor.jsonschema.validator.string.UriReference;
import io.openapiprocessor.jsonschema.validator.string.Uuid;
import java.net.URI;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Validator {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public Validator() {
        this.settings = new ValidatorSettings();
    }

    public Validator(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidationStep validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        SchemaStep step = new SchemaStep(schema, instance);
        this.validate(schema, instance, null, step);
        return step;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @Nullable @UnknownKeyFor @Initialized DynamicScope parentScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        DynamicScope dynamicScope = this.calcDynamicScope(schema, parentScope);
        RefResult ref = this.validateRef(schema, instance, dynamicScope, parentStep);
        if (ref.shouldStop()) {
            return;
        }
        this.validateDynamicRef(schema, instance, dynamicScope, parentStep);
        this.validateIf(schema, instance, dynamicScope, parentStep);
        this.validateAllOf(schema, instance, dynamicScope, parentStep);
        this.validateAnyOf(schema, instance, dynamicScope, parentStep);
        this.validateOneOf(schema, instance, dynamicScope, parentStep);
        this.validateNot(schema, instance, dynamicScope, parentStep);
        this.validateEnum(schema, instance, parentStep);
        this.validateConst(schema, instance, parentStep);
        this.validateType(schema, instance, parentStep);
        this.validateBoolean(schema, instance, parentStep);
        this.validateNumber(schema, instance, parentStep);
        this.validateString(schema, instance, parentStep);
        this.validateObject(schema, instance, dynamicScope, parentStep);
        this.validateArray(schema, instance, dynamicScope, parentStep);
    }

    private @UnknownKeyFor @NonNull @Initialized RefResult validateRef(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!schema.isRef()) {
            return new RefResult(false);
        }
        JsonSchema refSchema = schema.getRefSchema();
        RefStep step = new RefStep(schema, instance);
        this.validate(refSchema, instance, dynamicScope, step);
        parentStep.add(step);
        return new RefResult(!this.refAllowsSibling(step, schema));
    }

    private void validateDynamicRef(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!schema.isDynamicRef()) {
            return;
        }
        URI dynamicRef = schema.getDynamicRef();
        if (dynamicRef == null) {
            return;
        }
        JsonSchema refSchema = schema.getRefSchema(dynamicScope.findScope(dynamicRef));
        DynamicRefStep step = new DynamicRefStep(schema, instance);
        this.validate(refSchema, instance, dynamicScope, step);
        parentStep.add(step);
    }

    private void validateIf(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        JsonSchema jsIf = schema.getIf();
        JsonSchema jsThen = schema.getThen();
        JsonSchema jsElse = schema.getElse();
        if (jsIf == null) {
            return;
        }
        IfStep ifStep = new IfStep(jsIf, instance);
        this.validate(jsIf, instance, dynamicScope, ifStep);
        parentStep.add(ifStep);
        if (ifStep.isValid()) {
            if (jsThen != null) {
                SchemaStep thenStep = new SchemaStep(jsThen, instance);
                this.validate(jsThen, instance, dynamicScope, thenStep);
                parentStep.add(thenStep);
            }
        } else if (jsElse != null) {
            SchemaStep elseStep = new SchemaStep(jsElse, instance);
            this.validate(jsElse, instance, dynamicScope, elseStep);
            parentStep.add(elseStep);
        }
    }

    private void validateAllOf(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Collection<JsonSchema> allOf = schema.getAllOf();
        if (allOf.isEmpty()) {
            return;
        }
        AllOfStep step = new AllOfStep(schema, instance);
        for (JsonSchema allOfSchema : allOf) {
            SchemaStep allStep = new SchemaStep(allOfSchema, instance);
            this.validate(allOfSchema, instance, dynamicScope, allStep);
            step.add(allStep);
        }
        if (allOf.size() > 0 && step.countValid() != allOf.size()) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private void validateAnyOf(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Collection<JsonSchema> anyOf = schema.getAnyOf();
        if (anyOf.isEmpty()) {
            return;
        }
        AnyOfStep step = new AnyOfStep(schema, instance);
        for (JsonSchema anyOfSchema : anyOf) {
            SchemaStep anyStep = new SchemaStep(anyOfSchema, instance);
            this.validate(anyOfSchema, instance, dynamicScope, anyStep);
            step.add(anyStep);
        }
        if (anyOf.size() > 0 && step.countValid() == 0) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private void validateOneOf(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Collection<JsonSchema> oneOf = schema.getOneOf();
        if (oneOf.isEmpty()) {
            return;
        }
        OneOfStep step = new OneOfStep(schema, instance);
        for (JsonSchema oneOfSchema : oneOf) {
            SchemaStep oneStep = new SchemaStep(oneOfSchema, instance);
            this.validate(oneOfSchema, instance, dynamicScope, oneStep);
            step.add(oneStep);
        }
        if (oneOf.size() > 0 && step.countValid() != 1) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private void validateNot(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        JsonSchema not = schema.getNot();
        if (not == null) {
            return;
        }
        NotStep step = new NotStep(schema, instance);
        this.validate(not, instance, dynamicScope, step);
        if (step.isValid()) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private void validateEnum(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Collection<JsonInstance> enums = schema.getEnum();
        if (enums.isEmpty()) {
            return;
        }
        EnumStep step = new EnumStep(schema, instance);
        boolean valid = false;
        for (JsonInstance value : enums) {
            if (!instance.isEqual(value)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private void validateConst(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        JsonInstance constValue = schema.getConst();
        if (constValue == null) {
            return;
        }
        ConstStep step = new ConstStep(schema, instance);
        if (!instance.isEqual(constValue)) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private void validateType(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        new Type().validate(schema, instance, parentStep);
    }

    private void validateBoolean(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!this.isBooleanSchema(schema)) {
            return;
        }
        new Boolean().validate(schema, instance, parentStep);
    }

    private void validateArray(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!instance.isArray()) {
            return;
        }
        new MaxItems().validate(schema, instance, parentStep);
        new MinItems().validate(schema, instance, parentStep);
        new UniqueItems().validate(schema, instance, parentStep);
        new Contains(this).validate(schema, instance, dynamicScope, parentStep);
        if (this.isBeforeDraft202012(schema)) {
            new Items(this).validate(schema, instance, dynamicScope, parentStep);
        } else {
            new ItemsX(this).validate(schema, instance, dynamicScope, parentStep);
        }
    }

    private void validateObject(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!instance.isObject()) {
            return;
        }
        new MaxProperties().validate(schema, instance, parentStep);
        new MinProperties().validate(schema, instance, parentStep);
        new Required().validate(schema, instance, parentStep);
        new DependentRequired().validate(schema, instance, parentStep);
        new DependentSchemas(this).validate(schema, instance, dynamicScope, parentStep);
        new Properties(this).validate(schema, instance, dynamicScope, parentStep);
        new Dependencies(this).validate(schema, instance, dynamicScope, parentStep);
        new PropertyNames(this).validate(schema, instance, dynamicScope, parentStep);
    }

    private void validateNumber(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!instance.isNumber()) {
            return;
        }
        if (this.isDraft4(schema)) {
            new Minimum4().validate(schema, instance, parentStep);
            new Maximum4().validate(schema, instance, parentStep);
            new MultipleOf().validate(schema, instance, parentStep);
        } else {
            if (!this.shouldValidate(schema)) {
                return;
            }
            new Minimum().validate(schema, instance, parentStep);
            new Maximum().validate(schema, instance, parentStep);
            new ExclusiveMinimum().validate(schema, instance, parentStep);
            new ExclusiveMaximum().validate(schema, instance, parentStep);
            new MultipleOf().validate(schema, instance, parentStep);
        }
    }

    private void validateString(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        if (!instance.isString()) {
            return;
        }
        new MaxLength().validate(schema, instance, parentStep);
        new MinLength().validate(schema, instance, parentStep);
        new Pattern().validate(schema, instance, parentStep);
        new Uuid(this.settings).validate(schema, instance, parentStep);
        new DateTime(this.settings).validate(schema, instance, parentStep);
        new Email(this.settings).validate(schema, instance, parentStep);
        new Hostname(this.settings).validate(schema, instance, parentStep);
        new IpV4(this.settings).validate(schema, instance, parentStep);
        new IpV6(this.settings).validate(schema, instance, parentStep);
        new Uri(this.settings).validate(schema, instance, parentStep);
        new UriReference(this.settings).validate(schema, instance, parentStep);
        new Regex(this.settings).validate(schema, instance, parentStep);
    }

    private @UnknownKeyFor @NonNull @Initialized DynamicScope calcDynamicScope(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @Nullable @UnknownKeyFor @Initialized DynamicScope parentScope) {
        if (parentScope == null) {
            return new DynamicScope(schema);
        }
        return parentScope.add(schema);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema.getContext().getVocabularies().hasValidation();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean refAllowsSibling(@UnknownKeyFor @NonNull @Initialized ValidationStep step, @UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        if (step instanceof RefStep) {
            return schema.getContext().refAllowsSiblings();
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isBooleanSchema(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema instanceof JsonSchemaBoolean;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isBeforeDraft202012(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema.getContext().getVersion().isBefore202012();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isDraft4(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return SchemaVersion.Draft4.equals((Object)schema.getContext().getVersion());
    }

    private static class RefResult {
        @UnknownKeyFor @NonNull @Initialized boolean stop;

        public RefResult(@UnknownKeyFor @NonNull @Initialized boolean stop) {
            this.stop = stop;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean shouldStop() {
            return this.stop;
        }
    }
}

