/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.Output;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import java.util.Arrays;
import java.util.EnumSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ValidatorSettings {
    private @UnknownKeyFor @NonNull @Initialized SchemaVersion version = SchemaVersion.getLatest();
    private @UnknownKeyFor @NonNull @Initialized Output output = Output.VERBOSE;
    private final @UnknownKeyFor @NonNull @Initialized EnumSet<@UnknownKeyFor @NonNull @Initialized Format> formats = EnumSet.noneOf(Format.class);

    public @UnknownKeyFor @NonNull @Initialized SchemaVersion getVersion() {
        return this.version;
    }

    public void setVersion(@UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        this.version = version;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatorSettings setOutput(@UnknownKeyFor @NonNull @Initialized Output output) {
        this.output = output;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Output getOutput() {
        return this.output;
    }

    public void disableFormats(Format ... disable) {
        Arrays.asList(disable).forEach(this.formats::remove);
    }

    public void enableFormats(Format ... enable) {
        this.formats.addAll(Arrays.asList(enable));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validateFormat(@UnknownKeyFor @NonNull @Initialized Format format) {
        return this.formats.contains((Object)format);
    }
}

