/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.array;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemas;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.array.ItemsStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ItemsX {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public ItemsX(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        JsonSchema unevaluatedSchema;
        JsonSchemas items;
        ItemsStep prefixItemsStep = new ItemsStep(schema, instance, "prefixItems");
        ItemsStep itemsStep = new ItemsStep(schema, instance, "items");
        ItemsStep unevaluatedItemsStep = new ItemsStep(schema, instance, "unevaluatedItems");
        Integer prefixItemsAnnotation = null;
        Boolean itemsAnnotation = null;
        Boolean unevaluatedItemsAnnotation = null;
        int instanceSize = instance.getArraySize();
        Collection<JsonSchema> prefixItems = schema.getPrefixItems();
        if (!prefixItems.isEmpty()) {
            Iterator<JsonSchema> prefixItemsSchemas = prefixItems.iterator();
            int maxIdx = instanceSize;
            if (maxIdx > prefixItems.size()) {
                maxIdx = prefixItems.size();
            }
            IntStream.range(0, maxIdx).forEach(idx -> {
                JsonInstance value = instance.getValue(idx);
                if (idx < prefixItems.size()) {
                    this.validator.validate((JsonSchema)prefixItemsSchemas.next(), value, dynamicScope, prefixItemsStep);
                }
            });
            prefixItemsAnnotation = maxIdx;
        }
        if ((items = schema.getItems()).isSingle()) {
            JsonSchema itemsSchema = items.getSchema();
            Integer startIndex = prefixItemsAnnotation;
            if (startIndex == null) {
                startIndex = 0;
            }
            AtomicInteger itemsCnt = new AtomicInteger();
            IntStream.range(startIndex, instanceSize).forEach(idx -> {
                JsonInstance value = instance.getValue(idx);
                this.validator.validate(itemsSchema, value, dynamicScope, itemsStep);
                itemsCnt.getAndIncrement();
            });
            itemsAnnotation = itemsCnt.get() > 0;
        }
        if ((unevaluatedSchema = schema.getUnevaluatedItems()) != null) {
            Integer allPrefixItemsAnnotation = this.reducePrefixItemsAnnotations(prefixItemsAnnotation, parentStep, instanceSize);
            Boolean allItemsAnnotation = this.reduceItemsAnnotations(itemsAnnotation, parentStep);
            Collection<Integer> containsAnnotation = this.getContainsAnnotation(parentStep);
            Boolean allUnevaluatedItemsAnnotation = this.reduceUnevaluatedItemsAnnotations(unevaluatedItemsAnnotation, parentStep);
            AtomicInteger cntUnevaluatedItems = new AtomicInteger();
            if (allPrefixItemsAnnotation != null && instanceSize > allPrefixItemsAnnotation && allItemsAnnotation == null && allUnevaluatedItemsAnnotation == null) {
                IntStream.range(allPrefixItemsAnnotation, instanceSize).filter(idx -> !containsAnnotation.contains(idx)).forEach(idx -> {
                    JsonInstance value = instance.getValue(idx);
                    this.validator.validate(unevaluatedSchema, value, dynamicScope, unevaluatedItemsStep);
                    cntUnevaluatedItems.getAndIncrement();
                });
            } else if (allPrefixItemsAnnotation == null && allItemsAnnotation == null && allUnevaluatedItemsAnnotation == null) {
                IntStream.range(0, instanceSize).filter(idx -> !containsAnnotation.contains(idx)).forEach(idx -> {
                    JsonInstance value = instance.getValue(idx);
                    this.validator.validate(unevaluatedSchema, value, dynamicScope, unevaluatedItemsStep);
                    cntUnevaluatedItems.getAndIncrement();
                });
            }
            if (cntUnevaluatedItems.get() > 0) {
                unevaluatedItemsAnnotation = true;
            }
        }
        if (prefixItemsAnnotation != null) {
            prefixItemsStep.addAnnotation(prefixItemsAnnotation);
        }
        if (itemsAnnotation != null && itemsAnnotation.booleanValue()) {
            itemsStep.addAnnotation(itemsAnnotation);
        }
        if (unevaluatedItemsAnnotation != null) {
            unevaluatedItemsStep.addAnnotation(unevaluatedItemsAnnotation);
        }
        if (prefixItemsStep.isNotEmpty()) {
            parentStep.add(prefixItemsStep);
        }
        if (itemsStep.isNotEmpty()) {
            parentStep.add(itemsStep);
        }
        if (unevaluatedItemsStep.isNotEmpty()) {
            parentStep.add(unevaluatedItemsStep);
        }
    }

    private @Nullable @UnknownKeyFor @Initialized Integer reducePrefixItemsAnnotations(@Nullable @UnknownKeyFor @Initialized Integer currentPrefixItemsAnnotation, @UnknownKeyFor @NonNull @Initialized ValidationStep step, @UnknownKeyFor @NonNull @Initialized int instanceSize) {
        Collection<Annotation> otherAnnotations = step.getAnnotations("prefixItems");
        Integer reducedAnnotation = currentPrefixItemsAnnotation;
        if (!otherAnnotations.isEmpty()) {
            List booleanItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Boolean.class)).map(Annotation::asBoolean).collect(Collectors.toList());
            List integerItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Integer.class)).map(Annotation::asInteger).collect(Collectors.toList());
            if (currentPrefixItemsAnnotation != null) {
                if (currentPrefixItemsAnnotation == instanceSize) {
                    booleanItemsAnnotations.add(true);
                } else {
                    integerItemsAnnotations.add(currentPrefixItemsAnnotation);
                }
            }
            if (!booleanItemsAnnotations.isEmpty()) {
                boolean reduced = booleanItemsAnnotations.stream().reduce(false, (current, annotation) -> {
                    current = current | annotation;
                    return current;
                });
                if (reduced) {
                    reducedAnnotation = instanceSize;
                }
            } else {
                reducedAnnotation = integerItemsAnnotations.stream().reduce(0, Math::max);
            }
        }
        return reducedAnnotation;
    }

    private @Nullable @UnknownKeyFor @Initialized Boolean reduceItemsAnnotations(@Nullable @UnknownKeyFor @Initialized Boolean currentItemsAnnotation, @UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        Collection<Annotation> otherAnnotations = step.getAnnotations("items");
        Boolean reducedAnnotation = currentItemsAnnotation;
        if (!otherAnnotations.isEmpty()) {
            List itemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Boolean.class)).map(Annotation::asBoolean).collect(Collectors.toList());
            if (currentItemsAnnotation != null) {
                itemsAnnotations.add(currentItemsAnnotation);
            }
            reducedAnnotation = itemsAnnotations.stream().reduce(false, (current, annotation) -> {
                current = current | annotation;
                return current;
            });
        }
        return reducedAnnotation;
    }

    private @Nullable @UnknownKeyFor @Initialized Boolean reduceUnevaluatedItemsAnnotations(@Nullable @UnknownKeyFor @Initialized Boolean currentUnevaluatedItemsAnnotation, @UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        Collection<Annotation> otherAnnotations = step.getAnnotations("unevaluatedItems");
        Boolean reducedAnnotation = currentUnevaluatedItemsAnnotation;
        if (!otherAnnotations.isEmpty()) {
            List unevaluatedItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Boolean.class)).map(Annotation::asBoolean).collect(Collectors.toList());
            if (currentUnevaluatedItemsAnnotation != null) {
                unevaluatedItemsAnnotations.add(currentUnevaluatedItemsAnnotation);
            }
            reducedAnnotation = unevaluatedItemsAnnotations.stream().reduce(false, (current, annotation) -> {
                current = current | annotation;
                return current;
            });
        }
        return reducedAnnotation;
    }

    private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Integer> getContainsAnnotation(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        return step.getAnnotations("contains").stream().map(Annotation::asIntegers).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

