/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaBoolean;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.object.PropertiesStep;
import io.openapiprocessor.jsonschema.validator.object.PropertyStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Properties {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public Properties(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        PropertiesStep propertiesStep = new PropertiesStep(schema, instance, "properties");
        PropertiesStep patternPropertiesStep = new PropertiesStep(schema, instance, "patternProperties");
        PropertiesStep additionalPropertiesStep = new PropertiesStep(schema, instance, "additionalProperties");
        PropertiesStep unevaluatedPropertiesStep = new PropertiesStep(schema, instance, "unevaluatedProperties");
        Map<String, JsonSchema> schemaProperties = schema.getProperties();
        Map<String, JsonSchema> patternProperties = schema.getPatternProperties();
        JsonSchema additionalProperties = schema.getAdditionalProperties();
        JsonSchema unevaluatedProperties = schema.getUnevaluatedProperties();
        Map<String, Object> instanceObject = Nullness.nonNull(instance.asObject());
        HashSet<String> instanceProperties = new HashSet<String>(instanceObject.keySet());
        HashSet propertiesAnnotations = new HashSet();
        ArrayList patternPropertiesAnnotation = new ArrayList();
        ArrayList additionalPropertiesAnnotation = new ArrayList();
        ArrayList unevaluatedPropertiesAnnotation = new ArrayList();
        instanceObject.keySet().forEach(propName -> {
            boolean checkAdditionalProperty = true;
            JsonSchema propSchema = (JsonSchema)schemaProperties.get(propName);
            JsonInstance propInstance = instance.getValue((String)propName);
            if (propSchema != null) {
                PropertyStep propStep = new PropertyStep(propSchema, propInstance, (String)propName);
                propertiesStep.add(propStep);
                this.validator.validate(propSchema, propInstance, dynamicScope, propStep);
                if (propStep.isValid()) {
                    propertiesAnnotations.add(propName);
                }
                checkAdditionalProperty = false;
            }
            for (String pattern : patternProperties.keySet()) {
                Pattern p = Pattern.compile(pattern);
                Matcher m = p.matcher((CharSequence)propName);
                if (!m.find()) continue;
                JsonSchema patternSchema = (JsonSchema)patternProperties.get(pattern);
                JsonInstance value = instance.getValue((String)propName);
                PropertyStep propStep = new PropertyStep(patternSchema, value, (String)propName);
                patternPropertiesStep.add(propStep);
                this.validator.validate(patternSchema, value, dynamicScope, propStep);
                if (propStep.isValid()) {
                    patternPropertiesAnnotation.add(propName);
                }
                checkAdditionalProperty = false;
            }
            if (checkAdditionalProperty && additionalProperties != null) {
                JsonInstance value = instance.getValue((String)propName);
                PropertyStep propStep = new PropertyStep(additionalProperties, value, (String)propName);
                additionalPropertiesStep.add(propStep);
                this.validator.validate(additionalProperties, value, dynamicScope, propStep);
                if (propStep.isValid()) {
                    additionalPropertiesAnnotation.add(propName);
                }
            }
        });
        if (additionalProperties instanceof JsonSchemaBoolean && additionalProperties.isFalse()) {
            instanceProperties.removeAll(schemaProperties.keySet());
            Iterator it = instanceProperties.iterator();
            while (it.hasNext()) {
                String property = (String)it.next();
                for (String pattern : patternProperties.keySet()) {
                    Pattern p = Pattern.compile(pattern);
                    Matcher m = p.matcher(property);
                    if (!m.find()) continue;
                    it.remove();
                }
            }
        }
        Set<String> tmpAnnotations = this.collectAnnotations(parentStep, "properties");
        tmpAnnotations.addAll(propertiesAnnotations);
        tmpAnnotations.forEach(instanceProperties::remove);
        tmpAnnotations = this.collectAnnotations(parentStep, "patternProperties");
        tmpAnnotations.addAll(patternPropertiesAnnotation);
        tmpAnnotations.forEach(instanceProperties::remove);
        tmpAnnotations = this.collectAnnotations(parentStep, "additionalProperties");
        tmpAnnotations.addAll(additionalPropertiesAnnotation);
        tmpAnnotations.forEach(instanceProperties::remove);
        tmpAnnotations = this.collectAnnotations(parentStep, "unevaluatedProperties");
        tmpAnnotations.addAll(unevaluatedPropertiesAnnotation);
        tmpAnnotations.forEach(instanceProperties::remove);
        if (unevaluatedProperties != null) {
            instanceProperties.forEach(propName -> {
                JsonInstance propInstance = instance.getValue((String)propName);
                PropertyStep propStep = new PropertyStep(unevaluatedProperties, propInstance, (String)propName);
                unevaluatedPropertiesStep.add(propStep);
                this.validator.validate(unevaluatedProperties, propInstance, dynamicScope, propStep);
                if (propStep.isValid()) {
                    unevaluatedPropertiesAnnotation.add(propName);
                }
            });
        }
        propertiesStep.addAnnotation(propertiesAnnotations);
        patternPropertiesStep.addAnnotation(patternPropertiesAnnotation);
        additionalPropertiesStep.addAnnotation(additionalPropertiesAnnotation);
        unevaluatedPropertiesStep.addAnnotation(unevaluatedPropertiesAnnotation);
        if (!schemaProperties.isEmpty()) {
            parentStep.add(propertiesStep);
        }
        if (!patternProperties.isEmpty()) {
            parentStep.add(patternPropertiesStep);
        }
        if (additionalProperties != null) {
            parentStep.add(additionalPropertiesStep);
        }
        if (unevaluatedPropertiesStep.isNotEmpty()) {
            parentStep.add(unevaluatedPropertiesStep);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> collectAnnotations(@UnknownKeyFor @NonNull @Initialized ValidationStep step, @UnknownKeyFor @NonNull @Initialized String property) {
        return step.getAnnotations(property).stream().map(Annotation::asStrings).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

