/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.result;

import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class MessageKey {
    final @UnknownKeyFor @NonNull @Initialized String instanceScope;
    final @UnknownKeyFor @NonNull @Initialized String instancePath;

    public MessageKey(@UnknownKeyFor @NonNull @Initialized String instanceScope, @UnknownKeyFor @NonNull @Initialized String instancePath) {
        this.instanceScope = instanceScope;
        this.instancePath = instancePath;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("%s - %s", this.instanceScope, this.instancePath);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageKey that = (MessageKey)o;
        return Objects.equals(this.instanceScope, that.instanceScope) && Objects.equals(this.instancePath, that.instancePath);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.instanceScope, this.instancePath);
    }
}

