/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.EmailStep;
import io.openapiprocessor.jsonschema.validator.support.EmailValidator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Email {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public Email(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        String instanceValue;
        boolean valid;
        if (!this.hasFormat(schema)) {
            return;
        }
        EmailStep step = new EmailStep(schema, instance);
        if (this.shouldValidate(schema) && !(valid = new EmailValidator(instanceValue = this.getInstanceValue(instance)).validate())) {
            step.setInvalid();
        }
        if (this.shouldAnnotate(schema)) {
            step.createAnnotation();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldAnnotate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return this.getVocabularies(schema).hasFormatAnnotation();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return this.getVocabularies(schema).hasFormatAssertion() && this.settings.validateFormat(Format.EMAIL);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasFormat(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        String format = schema.getFormat();
        return format != null && format.equals(Format.EMAIL.getFormat());
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Nullness.nonNull(instance.asString());
    }

    private @UnknownKeyFor @NonNull @Initialized Vocabularies getVocabularies(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        JsonSchema metaSchema = schema.getMetaSchemaSchema();
        if (metaSchema == null) {
            return Vocabularies.ALL;
        }
        Vocabularies vocabularies = metaSchema.getVocabulary();
        if (vocabularies == null) {
            return Vocabularies.ALL;
        }
        return vocabularies;
    }
}

