/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.HostnameStep;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Hostname {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public Hostname(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        String format = schema.getFormat();
        if (!this.shouldValidate(format)) {
            return;
        }
        HostnameStep step = new HostnameStep(schema, instance);
        String instanceValue = this.getInstanceValue(instance);
        boolean valid = this.isValid(instanceValue);
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@Nullable @UnknownKeyFor @Initialized String format) {
        return format != null && format.equals(Format.HOSTNAME.getFormat()) && this.settings.validateFormat(Format.HOSTNAME);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Nullness.nonNull(instance.asString());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isValid(@UnknownKeyFor @NonNull @Initialized String ip) {
        String[] labels = ip.split("\\.");
        if (labels.length == 0) {
            return false;
        }
        for (String value : labels) {
            if (!value.codePoints().allMatch(this::isValidChar)) {
                return false;
            }
            if (value.startsWith("-") || value.endsWith("-")) {
                return false;
            }
            if (value.length() <= 63) continue;
            return false;
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isValidChar(@UnknownKeyFor @NonNull @Initialized int c) {
        return this.isNumber(c) || this.isLetter(c) || this.isDash(c);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNumber(@UnknownKeyFor @NonNull @Initialized int c) {
        return c >= 48 && c <= 57;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isLetter(@UnknownKeyFor @NonNull @Initialized int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isDash(@UnknownKeyFor @NonNull @Initialized int c) {
        return c == 45;
    }
}

