/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.MaxLengthStep;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MaxLength {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        boolean valid;
        Integer maxLength = schema.getMaxLength();
        if (maxLength == null) {
            return;
        }
        MaxLengthStep step = new MaxLengthStep(schema, instance);
        String instanceValue = this.getInstanceValue(instance);
        boolean bl = valid = instanceValue.codePointCount(0, instanceValue.length()) <= maxLength;
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Nullness.nonNull(instance.asString());
    }
}

