/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import io.openapiprocessor.jsonschema.support.Types;
import io.openapiprocessor.jsonschema.support.Uris;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class VocabularyConverter
implements PropertyConverter<Vocabularies> {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context;

    public VocabularyConverter(@UnknownKeyFor @NonNull @Initialized JsonSchemaContext context) {
        this.context = context;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Vocabularies convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        Map<String, Object> objects = Types.convertMapOrNull(location, value);
        if (objects == null) {
            return null;
        }
        LinkedHashMap<URI, Boolean> vocabularies = new LinkedHashMap<URI, Boolean>();
        objects.forEach((propKey, propValue) -> vocabularies.put(Uris.createUri(propKey), Types.asBoolean(propValue)));
        return Vocabularies.create(vocabularies, this.context.getVersion());
    }
}

