/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.reader;

import io.openapiprocessor.interfaces.Reader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UriReader
implements Reader {
    public @UnknownKeyFor @NonNull @Initialized InputStream read(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(uri);
        if (!UriReader.isHttp(uri)) {
            return UriReader.readFromUri(uri);
        }
        return UriReader.readFromHttp(uri);
    }

    private static @UnknownKeyFor @NonNull @Initialized InputStream readFromUri(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        URL root = uri.toURL();
        return root.openStream();
    }

    private static @UnknownKeyFor @NonNull @Initialized InputStream readFromHttp(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        HttpClient client = UriReader.buildHttpClient();
        HttpRequest request = UriReader.buildHttpRequest(uri);
        try {
            return client.send(request, HttpResponse.BodyHandlers.ofInputStream()).body();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpRequest buildHttpRequest(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return HttpRequest.newBuilder(uri).GET().timeout(Duration.ofSeconds(30L)).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpClient buildHttpClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isHttp(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return uri.getScheme().startsWith("http");
    }
}

