/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.BooleanConverter;
import io.openapiprocessor.jsonschema.converter.BucketConverter;
import io.openapiprocessor.jsonschema.converter.IntegerConverter;
import io.openapiprocessor.jsonschema.converter.JsonSchemaConverter;
import io.openapiprocessor.jsonschema.converter.JsonSchemaRefConverter;
import io.openapiprocessor.jsonschema.converter.JsonSchemasConverter;
import io.openapiprocessor.jsonschema.converter.MapDependencyConverter;
import io.openapiprocessor.jsonschema.converter.MapJsonSchemasConverter;
import io.openapiprocessor.jsonschema.converter.MapSetStringsOrEmptyConverter;
import io.openapiprocessor.jsonschema.converter.NoValueException;
import io.openapiprocessor.jsonschema.converter.NumberConverter;
import io.openapiprocessor.jsonschema.converter.ResponseType;
import io.openapiprocessor.jsonschema.converter.StringNullableConverter;
import io.openapiprocessor.jsonschema.converter.UriConverter;
import io.openapiprocessor.jsonschema.converter.VocabularyConverter;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.InvalidPropertyException;
import io.openapiprocessor.jsonschema.schema.JsonDependency;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.JsonSchemas;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.schema.Reference;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.support.Types;
import io.openapiprocessor.jsonschema.support.Uris;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class JsonSchemaObject
implements JsonSchema {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context;
    private final @UnknownKeyFor @NonNull @Initialized Bucket schemaObject;
    private final @UnknownKeyFor @NonNull @Initialized Bucket schemaProperties;

    public JsonSchemaObject(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document, @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context) {
        this.context = context;
        this.schemaObject = new Bucket(context.getScope(), document);
        this.schemaProperties = this.getBucketProperties(this.schemaObject);
    }

    public JsonSchemaObject(@UnknownKeyFor @NonNull @Initialized JsonPointer location, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document, @UnknownKeyFor @NonNull @Initialized JsonSchemaContext context) {
        this.context = context;
        this.schemaObject = new Bucket(context.getScope(), location, document);
        this.schemaProperties = this.getBucketProperties(this.schemaObject);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchemaContext getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getLocation() {
        return this.schemaObject.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRef() {
        return this.schemaObject.hasProperty(Keywords.REF);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getRef() {
        return this.schemaObject.convert(Keywords.REF, new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getAnchor() {
        return this.schemaObject.convert(Keywords.ANCHOR, new StringNullableConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isDynamicRef() {
        if (this.context.getVersion() == SchemaVersion.Draft201909) {
            return this.schemaObject.hasProperty(Keywords.RECURSIVE_REF);
        }
        return this.schemaObject.hasProperty(Keywords.DYNAMIC_REF);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getDynamicRef() {
        if (this.context.getVersion() == SchemaVersion.Draft201909) {
            return this.schemaObject.convert(Keywords.RECURSIVE_REF, new UriConverter());
        }
        return this.schemaObject.convert(Keywords.DYNAMIC_REF, new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getDynamicAnchor() {
        if (this.context.getVersion() == SchemaVersion.Draft201909) {
            Boolean anchor = this.schemaObject.convert(Keywords.RECURSIVE_ANCHOR, new BooleanConverter());
            if (anchor == null || !anchor.booleanValue()) {
                return null;
            }
            return Keywords.HASH;
        }
        return this.schemaObject.convert(Keywords.DYNAMIC_ANCHOR, new StringNullableConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchema getRefSchema() {
        Reference reference = this.context.getReference(Null.nonNull(this.getRef()));
        JsonSchemaContext refContext = this.context.withScope(reference.getValueScope());
        JsonSchema schema = (JsonSchema)new JsonSchemaRefConverter(refContext).convert(Keywords.REF, reference.getValue(), reference.getPointer());
        if (schema == null) {
            throw new NoValueException(this.getLocation().append(Keywords.REF));
        }
        return schema;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchema getRefSchema(@Nullable @UnknownKeyFor @Initialized URI dynamicScope) {
        if (dynamicScope == null) {
            Reference reference = this.context.getReference(Null.nonNull(this.getDynamicRef()));
            JsonSchemaContext refContext = this.context.withScope(reference.getValueScope());
            JsonSchema schema = (JsonSchema)new JsonSchemaRefConverter(refContext).convert(Keywords.DYNAMIC_REF, reference.getValue(), reference.getPointer());
            if (schema == null) {
                throw new NoValueException(this.getLocation().append(Keywords.DYNAMIC_REF));
            }
            return schema;
        }
        URI dynamicRef = Null.nonNull(this.getDynamicRef());
        String fragment = dynamicRef.getFragment();
        Reference reference = this.context.getDynamicReference(dynamicRef = Uris.createUri("#" + fragment), dynamicScope);
        JsonSchemaContext refContext = this.context.withScope(reference.getValueScope());
        JsonSchema schema = (JsonSchema)new JsonSchemaRefConverter(refContext).convert(Keywords.DYNAMIC_REF, reference.getValue(), reference.getPointer());
        if (schema == null) {
            throw new NoValueException(this.getLocation().append(Keywords.DYNAMIC_REF));
        }
        return schema;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getMetaSchema() {
        return this.schemaObject.convert(Keywords.SCHEMA, new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getMetaSchemaSchema() {
        URI metaSchemaUri = this.getMetaSchema();
        if (metaSchemaUri == null) {
            return null;
        }
        Reference reference = this.context.getReference(metaSchemaUri);
        return (JsonSchema)new JsonSchemaConverter(this.context).convert(Keywords.SCHEMA, reference.getValue(), reference.getPointer());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Vocabularies getVocabulary() {
        return this.schemaObject.convert(Keywords.VOCABULARY, new VocabularyConverter(this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized URI getId() {
        if (this.context.getVersion() == SchemaVersion.Draft4) {
            return this.schemaObject.convert(Keywords.ID4, new UriConverter());
        }
        return this.schemaObject.convert(Keywords.ID, new UriConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getMultipleOf() {
        return this.schemaObject.convert(Keywords.MULTIPLE_OF, new NumberConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getMaximum() {
        return this.schemaObject.convert(Keywords.MAXIMUM, new NumberConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean getExclusiveMaximumB() {
        Boolean exclusive = this.schemaObject.convert(Keywords.EXCLUSIVE_MAXIMUM, new BooleanConverter());
        if (exclusive == null) {
            return false;
        }
        return exclusive;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getExclusiveMaximum() {
        return this.schemaObject.convert(Keywords.EXCLUSIVE_MAXIMUM, new NumberConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getMinimum() {
        return this.schemaObject.convert(Keywords.MINIMUM, new NumberConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean getExclusiveMinimumB() {
        Boolean exclusive = this.schemaObject.convert(Keywords.EXCLUSIVE_MINIMUM, new BooleanConverter());
        if (exclusive == null) {
            return false;
        }
        return exclusive;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Number getExclusiveMinimum() {
        return this.schemaObject.convert(Keywords.EXCLUSIVE_MINIMUM, new NumberConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxLength() {
        return this.schemaObject.convert(Keywords.MAX_LENGTH, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMinLength() {
        return this.schemaObject.convert(Keywords.MIN_LENGTH, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getPattern() {
        return this.schemaObject.convert(Keywords.PATTERN, new StringNullableConverter());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getPrefixItems() {
        Collection<JsonSchema> prefixItems = this.getJsonSchemasOf(Keywords.PREFIX_ITEMS);
        if (prefixItems == null) {
            return Collections.emptyList();
        }
        return prefixItems;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchemas getItems() {
        Collection<JsonSchema> items;
        boolean exists = this.schemaObject.hasProperty(Keywords.ITEMS);
        if (!exists) {
            return new JsonSchemas();
        }
        Object raw = this.schemaObject.getRawValue(Keywords.ITEMS);
        if (Types.isSchema(raw)) {
            return new JsonSchemas(this.getJsonSchemaOf(Keywords.ITEMS));
        }
        if (Types.isArray(raw) && (items = this.getJsonSchemasOf(Keywords.ITEMS)) != null) {
            return new JsonSchemas(items);
        }
        throw new InvalidPropertyException(this.getLocation().append(Keywords.ITEMS));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonSchemas getAdditionalItems() {
        boolean exists = this.schemaObject.hasProperty(Keywords.ADDITIONAL_ITEMS);
        if (!exists) {
            return new JsonSchemas();
        }
        Object raw = this.schemaObject.getRawValue(Keywords.ADDITIONAL_ITEMS);
        if (raw == null) {
            return new JsonSchemas((JsonSchema)null);
        }
        return new JsonSchemas(this.getJsonSchemaOf(Keywords.ADDITIONAL_ITEMS));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getUnevaluatedItems() {
        return this.getJsonSchemaOf(Keywords.UNEVALUATED_ITEMS);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxItems() {
        return this.schemaObject.convert(Keywords.MAX_ITEMS, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMinItems() {
        return this.schemaObject.convert(Keywords.MIN_ITEMS, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Boolean isUniqueItems() {
        return this.schemaObject.convert(Keywords.UNIQUE_ITEMS, new BooleanConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getContains() {
        return this.getJsonSchemaOf(Keywords.CONTAINS);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer getMinContains() {
        Integer minContains = this.schemaObject.convert(Keywords.MIN_CONTAINS, new IntegerConverter());
        if (minContains == null) {
            return 1;
        }
        return minContains;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxContains() {
        return this.schemaObject.convert(Keywords.MAX_CONTAINS, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMaxProperties() {
        return this.schemaObject.convert(Keywords.MAX_PROPERTIES, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getMinProperties() {
        return this.schemaObject.convert(Keywords.MIN_PROPERTIES, new IntegerConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getRequired() {
        Object raw = this.schemaObject.getRawValue(Keywords.REQUIRED);
        if (raw == null) {
            return null;
        }
        return Collections.unmodifiableCollection(Types.asCol(raw));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> getProperties() {
        Map<String, JsonSchema> properties = this.schemaObject.convert(Keywords.PROPERTIES, new MapJsonSchemasConverter(this.context));
        if (properties == null) {
            return Collections.emptyMap();
        }
        return properties;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> getPatternProperties() {
        Map<String, JsonSchema> patternProperties = this.schemaObject.convert(Keywords.PATTERN_PROPERTIES, new MapJsonSchemasConverter(this.context));
        if (patternProperties == null) {
            return Collections.emptyMap();
        }
        return patternProperties;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getAdditionalProperties() {
        return this.getJsonSchemaOf(Keywords.ADDITIONAL_PROPERTIES);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getUnevaluatedProperties() {
        return this.getJsonSchemaOf(Keywords.UNEVALUATED_PROPERTIES);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonDependency> getDependencies() {
        return this.schemaObject.convert(Keywords.DEPENDENCIES, new MapDependencyConverter(this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> getDependentSchemas() {
        return this.schemaObject.convert(Keywords.DEPENDENT_SCHEMAS, new MapJsonSchemasConverter(this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> getDependentRequired() {
        return this.schemaObject.convert(Keywords.DEPENDENT_REQUIRED, new MapSetStringsOrEmptyConverter(ResponseType.NULL));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getPropertyNames() {
        return this.getJsonSchemaOf(Keywords.PROPERTY_NAMES);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getJsonSchema(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.schemaProperties.convert(property, new JsonSchemaConverter(this.context));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonInstance> getEnum() {
        Object raw = this.schemaObject.getRawValue(Keywords.ENUM);
        if (raw == null) {
            return Collections.emptyList();
        }
        if (raw instanceof Collection) {
            ArrayList<JsonInstance> instances = new ArrayList<JsonInstance>();
            int index = 0;
            for (Object o : Types.asCol(raw)) {
                JsonInstance instance = new JsonInstance(this.getLocation().append(Keywords.ENUM).append(index), o);
                instances.add(instance);
                ++index;
            }
            return Collections.unmodifiableCollection(instances);
        }
        throw new RuntimeException();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonInstance getConst() {
        if (!this.schemaObject.hasProperty(Keywords.CONST)) {
            return null;
        }
        Object raw = this.schemaObject.getRawValue(Keywords.CONST);
        return new JsonInstance(this.getLocation().append(Keywords.CONST), raw);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getType() {
        boolean exists = this.schemaObject.hasProperty(Keywords.TYPE);
        if (!exists) {
            return Collections.emptyList();
        }
        Object raw = this.schemaObject.getRawValue(Keywords.TYPE);
        if (raw instanceof String) {
            String type = Types.convert("", raw, String.class);
            return Collections.singletonList(type);
        }
        if (raw instanceof Collection) {
            return Collections.unmodifiableCollection(Types.asCol(raw));
        }
        throw new RuntimeException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getAllOf() {
        Collection<JsonSchema> allOf = this.getJsonSchemasOf(Keywords.ALL_OF);
        if (allOf == null) {
            return Collections.emptyList();
        }
        return allOf;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getAnyOf() {
        Collection<JsonSchema> anyOf = this.getJsonSchemasOf(Keywords.ANY_OF);
        if (anyOf == null) {
            return Collections.emptyList();
        }
        return anyOf;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getOneOf() {
        Collection<JsonSchema> oneOf = this.getJsonSchemasOf(Keywords.ONE_OF);
        if (oneOf == null) {
            return Collections.emptyList();
        }
        return oneOf;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getNot() {
        return this.getJsonSchemaOf(Keywords.NOT);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getFormat() {
        return this.schemaObject.convert(Keywords.FORMAT, new StringNullableConverter());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getIf() {
        return this.getJsonSchemaOf(Keywords.IF);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getThen() {
        return this.getJsonSchemaOf(Keywords.THEN);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema getElse() {
        return this.getJsonSchemaOf(Keywords.ELSE);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("%s", this.schemaObject.getLocation());
    }

    private @Nullable @UnknownKeyFor @Initialized JsonSchema getJsonSchemaOf(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.schemaObject.convert(property, new JsonSchemaConverter(this.context));
    }

    private @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized JsonSchema> getJsonSchemasOf(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.schemaObject.convert(property, new JsonSchemasConverter(this.context));
    }

    private @UnknownKeyFor @NonNull @Initialized Bucket getBucketProperties(@UnknownKeyFor @NonNull @Initialized Bucket schemaBucket) {
        Bucket bucket = schemaBucket.convert(Keywords.PROPERTIES, new BucketConverter(schemaBucket));
        if (bucket == null) {
            return Bucket.empty();
        }
        return bucket;
    }
}

