/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.Ref;
import io.openapiprocessor.jsonschema.schema.RefValue;
import io.openapiprocessor.jsonschema.schema.Reference;
import io.openapiprocessor.jsonschema.schema.ReferenceType;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Uris;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ReferenceRegistry {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ReferenceKey, @UnknownKeyFor @NonNull @Initialized Reference> references = new HashMap<ReferenceKey, Reference>();

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.references.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasReference(@UnknownKeyFor @NonNull @Initialized URI absoluteRef) {
        boolean hasRef = this.hasReference(absoluteRef, ReferenceType.STATIC);
        if (hasRef) {
            return true;
        }
        if (Uris.hasEmptyFragment(absoluteRef)) {
            return this.hasReference(Uris.stripFragment(absoluteRef), ReferenceType.STATIC);
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Reference getReference(@UnknownKeyFor @NonNull @Initialized URI absoluteRef) {
        Reference reference = this.getReference(absoluteRef, ReferenceType.STATIC);
        if (reference != null) {
            return reference;
        }
        if (Uris.hasEmptyFragment(absoluteRef)) {
            reference = this.getReference(Uris.stripFragment(absoluteRef), ReferenceType.STATIC);
        }
        if (reference == null) {
            throw new RuntimeException();
        }
        return reference;
    }

    public @UnknownKeyFor @NonNull @Initialized Reference getDynamicReference(@UnknownKeyFor @NonNull @Initialized URI absoluteRef) {
        Reference reference = this.getReference(absoluteRef, ReferenceType.DYNAMIC);
        if (reference != null) {
            return reference;
        }
        return this.getReference(absoluteRef);
    }

    public void addReference(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized Scope valueScope, @UnknownKeyFor @NonNull @Initialized Object document) {
        this.references.put(new ReferenceKey(ref.getAbsoluteUri(), ReferenceType.STATIC), new Reference(ref, new RefValue(valueScope, document)));
    }

    public void addDynamicReference(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized Scope valueScope, @UnknownKeyFor @NonNull @Initialized Object document) {
        this.references.put(new ReferenceKey(ref.getAbsoluteUri(), ReferenceType.DYNAMIC), new Reference(ref, new RefValue(valueScope, document)));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasDynamicReference(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return this.hasReference(uri, ReferenceType.DYNAMIC);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasReference(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized ReferenceType type) {
        return this.references.containsKey(new ReferenceKey(uri, type));
    }

    private @Nullable @UnknownKeyFor @Initialized Reference getReference(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized ReferenceType type) {
        return this.references.get(new ReferenceKey(uri, type));
    }

    static class ReferenceKey {
        @UnknownKeyFor @NonNull @Initialized URI uri;
        @UnknownKeyFor @NonNull @Initialized ReferenceType type;

        public ReferenceKey(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized ReferenceType type) {
            this.uri = uri;
            this.type = type;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReferenceKey that = (ReferenceKey)o;
            return Objects.equals(this.uri, that.uri) && this.type == that.type;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(new Object[]{this.uri, this.type});
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.format("%s (%s)", new Object[]{this.uri, this.type});
        }
    }
}

