/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.DocumentLoader;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.ReferenceRegistry;
import io.openapiprocessor.jsonschema.schema.ResolverContext;
import io.openapiprocessor.jsonschema.schema.ResolverException;
import io.openapiprocessor.jsonschema.schema.ResolverId;
import io.openapiprocessor.jsonschema.schema.ResolverRef;
import io.openapiprocessor.jsonschema.schema.ResolverResult;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Types;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resolver {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(Resolver.class);
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents;
    private final @UnknownKeyFor @NonNull @Initialized DocumentLoader loader;

    public Resolver(@UnknownKeyFor @NonNull @Initialized DocumentStore documents, @UnknownKeyFor @NonNull @Initialized DocumentLoader loader) {
        this.documents = documents;
        this.loader = loader;
    }

    public @UnknownKeyFor @NonNull @Initialized ResolverResult resolve(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Settings settings) {
        try {
            return this.resolve(uri, this.loader.loadDocument(uri), settings);
        }
        catch (Exception e) {
            throw new ResolverException(String.format("failed to resolve '%s'.", uri), e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized ResolverResult resolve(@UnknownKeyFor @NonNull @Initialized String resourcePath, @UnknownKeyFor @NonNull @Initialized Settings settings) {
        try {
            return this.resolve(URI.create(resourcePath), this.loader.loadDocument(resourcePath), settings);
        }
        catch (Exception e) {
            throw new ResolverException(String.format("failed to resolve '%s'.", resourcePath), e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized ResolverResult resolve(@UnknownKeyFor @NonNull @Initialized URI documentUri, @UnknownKeyFor @NonNull @Initialized Object document, @UnknownKeyFor @NonNull @Initialized Settings settings) {
        ReferenceRegistry registry = new ReferenceRegistry();
        this.documents.addId(documentUri, document);
        Scope scope = Scope.createScope(documentUri, document, settings.version);
        Bucket bucket = this.toBucket(scope, document);
        if (bucket == null) {
            return new ResolverResult(scope, document, registry, this.documents);
        }
        ResolverContext context = new ResolverContext(this.documents, this.loader, registry);
        ResolverId resolverId = new ResolverId(context);
        resolverId.resolve(bucket);
        ResolverRef resolverRef = new ResolverRef(context);
        resolverRef.resolve(bucket);
        return new ResolverResult(scope, document, registry, this.documents);
    }

    private @Nullable @UnknownKeyFor @Initialized Bucket toBucket(@UnknownKeyFor @NonNull @Initialized Scope scope, @PolyNull @UnknownKeyFor @Initialized Object source) {
        if (!Types.isObject(source)) {
            return null;
        }
        return new Bucket(scope, Types.asObject(source));
    }

    public static class Settings {
        private @UnknownKeyFor @NonNull @Initialized SchemaVersion version;
        private @UnknownKeyFor @NonNull @Initialized boolean autoLoadSchemas = false;

        public Settings() {
        }

        public Settings(@UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
            this.version = version;
        }

        public @UnknownKeyFor @NonNull @Initialized Settings autoLoadSchemas(@UnknownKeyFor @NonNull @Initialized boolean load) {
            this.autoLoadSchemas = load;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized SchemaVersion getVersion() {
            return this.version;
        }
    }
}

