/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.DocumentLoader;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.Ref;
import io.openapiprocessor.jsonschema.schema.ReferenceRegistry;
import io.openapiprocessor.jsonschema.schema.References;
import io.openapiprocessor.jsonschema.schema.ResolverException;
import io.openapiprocessor.jsonschema.schema.Scope;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ResolverContext {
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents;
    private final @UnknownKeyFor @NonNull @Initialized DocumentLoader loader;
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized URI> processedDocuments = new HashSet<URI>();
    public final @UnknownKeyFor @NonNull @Initialized References references = new References();
    public final @UnknownKeyFor @NonNull @Initialized ReferenceRegistry registry;

    public ResolverContext(@UnknownKeyFor @NonNull @Initialized DocumentStore documents, @UnknownKeyFor @NonNull @Initialized DocumentLoader loader, @UnknownKeyFor @NonNull @Initialized ReferenceRegistry registry) {
        this.documents = documents;
        this.loader = loader;
        this.registry = registry;
    }

    public void addId(@UnknownKeyFor @NonNull @Initialized URI id, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        if (this.documents.contains(id)) {
            return;
        }
        this.documents.addId(id, document);
    }

    public void addAnchor(@UnknownKeyFor @NonNull @Initialized URI anchor, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        if (this.documents.contains(anchor)) {
            return;
        }
        this.documents.addAnchor(anchor, document);
    }

    public void addDynamicAnchor(@UnknownKeyFor @NonNull @Initialized URI anchor, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        if (this.documents.contains(anchor)) {
            return;
        }
        this.documents.addDynamicAnchor(anchor, document);
    }

    public void addRef(@UnknownKeyFor @NonNull @Initialized Ref ref) {
        if (this.registry.hasReference(ref.getAbsoluteUri())) {
            return;
        }
        if (this.references.contains(ref)) {
            return;
        }
        this.references.add(ref);
    }

    public void addRef(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        if (this.registry.hasReference(ref.getAbsoluteUri())) {
            return;
        }
        this.registry.addReference(ref, ref.getScope(), document);
    }

    public void addDynamicAnchorRef(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        if (this.registry.hasDynamicReference(ref.getAbsoluteUri())) {
            return;
        }
        this.registry.addDynamicReference(ref, ref.getScope(), document);
    }

    public void addRef(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized Object document) {
        if (this.registry.hasReference(ref.getAbsoluteUri())) {
            return;
        }
        this.registry.addReference(ref, scope, document);
    }

    public @Nullable @UnknownKeyFor @Initialized Object getDocument(@UnknownKeyFor @NonNull @Initialized URI documentUri) {
        return this.documents.get(documentUri);
    }

    public void addDocument(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized Object document) {
        this.documents.addId(scope.getBaseUri(), document);
        this.setProcessedDocument(scope.getBaseUri());
    }

    public @UnknownKeyFor @NonNull @Initialized Object addDocument(@UnknownKeyFor @NonNull @Initialized URI documentUri, @UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized String ref) {
        try {
            Object document = documentUri.getScheme() == null ? this.loader.loadDocument(documentUri.toString()) : this.loader.loadDocument(documentUri);
            this.documents.addId(documentUri, document);
            return document;
        }
        catch (ResolverException ex) {
            throw new ResolverException(String.format("failed to resolve '%s' $referenced from '%s'", ref, source), ex);
        }
    }

    public void setProcessedDocument(@UnknownKeyFor @NonNull @Initialized URI documentUri) {
        this.processedDocuments.add(documentUri);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isProcessedDocument(@UnknownKeyFor @NonNull @Initialized URI documentUri) {
        return this.processedDocuments.contains(documentUri);
    }
}

