/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.array;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.array.ContainsStep;
import io.openapiprocessor.jsonschema.validator.array.MaxContainsStep;
import io.openapiprocessor.jsonschema.validator.array.MinContainsStep;
import io.openapiprocessor.jsonschema.validator.steps.SchemaStep;
import io.openapiprocessor.jsonschema.validator.steps.SimpleStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Contains {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public Contains(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        SimpleStep minStep;
        JsonSchema contains = schema.getContains();
        if (contains == null) {
            return;
        }
        ArrayList<Integer> containsAnnotation = new ArrayList<Integer>();
        Collection<Object> instanceValue = this.getInstanceValue(instance);
        int instanceSize = instanceValue.size();
        ContainsStep containsStep = new ContainsStep(schema, instance);
        int validCount = 0;
        for (int idx = 0; idx < instanceSize; ++idx) {
            JsonInstance value = instance.getValue(idx);
            SchemaStep step = new SchemaStep(contains, value);
            this.validator.validate(contains, value, dynamicScope, step);
            if (!step.isValid()) continue;
            containsAnnotation.add(idx);
            ++validCount;
        }
        boolean containsIsValid = validCount > 0;
        Integer minContains = schema.getMinContains();
        Integer maxContains = schema.getMaxContains();
        if (minContains != null) {
            minStep = new MinContainsStep(schema, instance);
            minStep.setValid(validCount >= minContains);
            parentStep.add(minStep);
            if (minContains == 0 && maxContains == null) {
                containsIsValid = true;
            }
        }
        if (maxContains != null) {
            minStep = new MaxContainsStep(schema, instance);
            boolean valid = validCount <= maxContains;
            minStep.setValid(valid);
            parentStep.add(minStep);
            if (valid && minContains != null && minContains == 0) {
                containsIsValid = true;
            }
        }
        if (!containsIsValid) {
            containsStep.setInvalid();
        }
        containsStep.addAnnotation(containsAnnotation);
        parentStep.add(containsStep);
    }

    private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asCollection());
    }
}

