/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.steps.Step;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PropertyStep
implements ValidationStep {
    protected final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;
    protected final @UnknownKeyFor @NonNull @Initialized JsonInstance instance;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    protected final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> steps = new ArrayList<ValidationStep>();

    public PropertyStep(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        this.schema = schema;
        this.instance = instance;
        this.propertyName = propertyName;
    }

    @Override
    public void add(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        this.steps.add(step);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isValid() {
        return this.steps.stream().allMatch(ValidationStep::isValid);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> getSteps() {
        return this.steps;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized ValidationMessage getMessage() {
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Annotation getAnnotation() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Annotation> getAnnotations(@UnknownKeyFor @NonNull @Initialized String keyword) {
        return this.steps.stream().filter(ValidationStep::isValid).map(s -> s.getAnnotations(keyword)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getInstanceLocation() {
        return this.instance.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getKeywordLocation() {
        return this.schema.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation() {
        return Step.getAbsoluteKeywordLocation(this.getScope(), this.getKeywordLocation());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Step.toString(this.getKeywordLocation(), this.getInstanceLocation(), this.isValid());
    }

    private @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.schema.getContext().getScope();
    }
}

