/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.steps;

import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.Annotations;
import io.openapiprocessor.jsonschema.validator.AnnotationsComposite;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class CompositeStep
implements ValidationStep,
Annotations {
    protected final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> steps;

    public CompositeStep() {
        this.steps = new ArrayList<ValidationStep>();
    }

    public CompositeStep(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> steps) {
        this.steps = steps;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.steps.isEmpty();
    }

    @Override
    public void add(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        this.steps.add(step);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized ValidationMessage getMessage() {
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Annotation getAnnotation() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> getSteps() {
        return this.steps;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Annotation> getAnnotations(@UnknownKeyFor @NonNull @Initialized String keyword) {
        return this.steps.stream().filter(ValidationStep::isValid).map(s -> s.getAnnotations(keyword)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized AnnotationsComposite mergeAnnotations(@UnknownKeyFor @NonNull @Initialized Annotations annotations) {
        AnnotationsComposite merge = new AnnotationsComposite();
        merge.add(annotations);
        merge.add(this);
        return merge;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isValid() {
        return this.steps.stream().filter(ValidationStep::isValidatable).allMatch(ValidationStep::isValid);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.isValid() ? "(composite) valid" : "invalid";
    }
}

