/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.support;

import io.openapiprocessor.jsonschema.validator.support.IpV4Validator;
import io.openapiprocessor.jsonschema.validator.support.IpV6Validator;
import io.openapiprocessor.jsonschema.validator.support.ValidInt;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UriValidator {
    private final @UnknownKeyFor @NonNull @Initialized String source;
    private static final @UnknownKeyFor @NonNull @Initialized int EXCLAMATION_MARK = 33;
    private static final @UnknownKeyFor @NonNull @Initialized int DOLLAR = 36;
    private static final @UnknownKeyFor @NonNull @Initialized int PERCENT = 37;
    private static final @UnknownKeyFor @NonNull @Initialized int AMPERSAND = 38;
    private static final @UnknownKeyFor @NonNull @Initialized int SINGLE_QUOTE = 39;
    private static final @UnknownKeyFor @NonNull @Initialized int OPEN_PARENTHESIS = 40;
    private static final @UnknownKeyFor @NonNull @Initialized int CLOSE_PARENTHESIS = 41;
    private static final @UnknownKeyFor @NonNull @Initialized int ASTERISK = 42;
    private static final @UnknownKeyFor @NonNull @Initialized int PLUS = 43;
    private static final @UnknownKeyFor @NonNull @Initialized int COMMA = 44;
    private static final @UnknownKeyFor @NonNull @Initialized int HYPHEN = 45;
    private static final @UnknownKeyFor @NonNull @Initialized int DOT = 46;
    private static final @UnknownKeyFor @NonNull @Initialized int SLASH = 47;
    private static final @UnknownKeyFor @NonNull @Initialized int COLON = 58;
    private static final @UnknownKeyFor @NonNull @Initialized int SEMICOLON = 59;
    private static final @UnknownKeyFor @NonNull @Initialized int EQUALS = 61;
    private static final @UnknownKeyFor @NonNull @Initialized int QUESTION_MARK = 63;
    private static final @UnknownKeyFor @NonNull @Initialized int AT = 64;
    private static final @UnknownKeyFor @NonNull @Initialized int OPEN_BRACKET = 91;
    private static final @UnknownKeyFor @NonNull @Initialized int CLOSE_BRACKET = 93;
    private static final @UnknownKeyFor @NonNull @Initialized int UNDERSCORE = 95;
    private static final @UnknownKeyFor @NonNull @Initialized int TILDE = 126;

    public UriValidator(@UnknownKeyFor @NonNull @Initialized String source) {
        this.source = source;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validate() {
        try {
            Components components = this.splitComponents();
            if (!components.isRelative()) {
                this.checkScheme(components.scheme);
            }
            this.checkAuthority(components.authority);
            this.checkPath(components.path, components.hasAuthority());
            this.checkQuery(components.query);
            this.checkFragment(components.fragment);
            return true;
        }
        catch (ValidatorException ex) {
            return false;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validateAbsolute() {
        try {
            Components components = this.splitComponents();
            this.checkScheme(components.scheme);
            this.checkAuthority(components.authority);
            this.checkPath(components.path, components.hasAuthority());
            this.checkQuery(components.query);
            this.checkFragment(components.fragment);
            return true;
        }
        catch (ValidatorException ex) {
            return false;
        }
    }

    private void checkScheme(@UnknownKeyFor @NonNull @Initialized String scheme) {
        if (scheme == null || scheme.length() == 0) {
            throw new ValidatorException();
        }
        int first = scheme.codePointAt(0);
        if (!this.isLetter(first)) {
            throw new ValidatorException();
        }
        if (scheme.length() == 1) {
            return;
        }
        boolean allMatch = scheme.substring(1).codePoints().allMatch(this::isSchemeChar);
        if (!allMatch) {
            throw new ValidatorException();
        }
    }

    private void checkAuthority(@UnknownKeyFor @NonNull @Initialized String authority) {
        String host;
        boolean hasPort;
        if (authority == null || authority.length() == 0) {
            return;
        }
        String content = authority.substring(2);
        int hostStart = 0;
        int hostEnd = content.length();
        int hostSeparator = content.indexOf(64);
        if (hostSeparator != -1) {
            String userInfo = content.substring(0, hostSeparator);
            this.checkUserInfo(userInfo);
            hostStart = hostSeparator + 1;
        }
        int bracketClose = content.indexOf(93);
        int portSeparator = content.lastIndexOf(58);
        boolean bl = hasPort = portSeparator > hostSeparator && portSeparator > bracketClose;
        if (hasPort) {
            String port = content.substring(portSeparator);
            hostEnd = portSeparator;
        }
        if ((host = content.substring(hostStart, hostEnd)).isEmpty()) {
            return;
        }
        if (this.isIpV6(host)) {
            return;
        }
        if (this.isIpV4(host)) {
            return;
        }
        for (int i = 0; i < host.length(); ++i) {
            boolean valid;
            int c = host.codePointAt(i);
            if (c == 37 && host.length() > i + 2) {
                String encoded = host.substring(i + 1, i + 2);
                ValidInt validInt = ValidInt.parseHex(encoded);
                if (validInt.isValid()) continue;
                throw new ValidatorException();
            }
            boolean bl2 = valid = this.isUnreserved(c) || this.isSubDelim(c);
            if (valid) continue;
            throw new ValidatorException();
        }
    }

    private void checkPath(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized boolean hasAuthority) {
        String[] segments;
        boolean hasDoubleSlash;
        int length = path.length();
        boolean emptyPath = length == 0;
        boolean hasSlash = !emptyPath && path.codePointAt(0) == 47;
        boolean bl = hasDoubleSlash = hasSlash && length > 1 && path.codePointAt(1) == 47;
        if (hasAuthority ? !emptyPath && !hasSlash : hasDoubleSlash) {
            throw new ValidatorException();
        }
        for (String segment : segments = path.split("/")) {
            for (int i = 0; i < segment.length(); ++i) {
                boolean valid;
                int c = segment.codePointAt(i);
                if (c == 37 && segment.length() > i + 2) {
                    String encoded = segment.substring(i + 1, i + 2);
                    ValidInt validInt = ValidInt.parseHex(encoded);
                    if (validInt.isValid()) continue;
                    throw new ValidatorException();
                }
                boolean bl2 = valid = this.isUnreserved(c) || this.isSubDelim(c) || c == 58 || c == 64;
                if (valid) continue;
                throw new ValidatorException();
            }
        }
    }

    private void checkQuery(@UnknownKeyFor @NonNull @Initialized String query) {
    }

    private void checkFragment(@UnknownKeyFor @NonNull @Initialized String fragment) {
        for (int i = 0; i < fragment.length(); ++i) {
            boolean valid;
            int c = fragment.codePointAt(i);
            if (c == 37 && fragment.length() > i + 2) {
                String encoded = fragment.substring(i + 1, i + 2);
                ValidInt validInt = ValidInt.parseHex(encoded);
                if (validInt.isValid()) continue;
                throw new ValidatorException();
            }
            boolean bl = valid = this.isUnreserved(c) || this.isSubDelim(c) || c == 47 || c == 58 || c == 63 || c == 64;
            if (valid) continue;
            throw new ValidatorException();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isIpV6(@UnknownKeyFor @NonNull @Initialized String source) {
        if (source.length() <= 2) {
            return false;
        }
        if (!this.isEnclosedIp(source)) {
            return false;
        }
        String ip = source.substring(1, source.length() - 1);
        boolean isIpV6 = new IpV6Validator(ip).validate();
        if (isIpV6) {
            return true;
        }
        throw new ValidatorException();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isIpV4(@UnknownKeyFor @NonNull @Initialized String source) {
        return new IpV4Validator(source).validate();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isEnclosedIp(@UnknownKeyFor @NonNull @Initialized String source) {
        return source.indexOf(91) == 0 && source.lastIndexOf(93) == source.length() - 1;
    }

    private void checkUserInfo(@UnknownKeyFor @NonNull @Initialized String userInfo) {
        for (int i = 0; i < userInfo.length(); ++i) {
            boolean valid;
            int c = userInfo.codePointAt(i);
            if (c == 37 && userInfo.length() > i + 2) {
                String encoded = userInfo.substring(i + 1, i + 2);
                ValidInt validInt = ValidInt.parseHex(encoded);
                if (validInt.isValid()) continue;
                throw new ValidatorException();
            }
            boolean bl = valid = this.isUnreserved(c) || this.isSubDelim(c) || c == 58;
            if (valid) continue;
            throw new ValidatorException();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Components splitComponents() {
        String query;
        String path;
        String authority;
        int componentStart = 0;
        int componentEnd = this.findScheme(componentStart);
        String scheme = this.extractComponent(componentStart, componentEnd);
        if (scheme.length() != 0) {
            componentStart = componentEnd + 1;
        }
        if ((authority = this.extractComponent(componentStart, componentEnd = this.findAuthority(componentStart))).length() != 0) {
            componentStart = componentEnd;
        }
        if ((path = this.extractComponent(componentStart, componentEnd = this.findPath(componentStart))).length() != 0) {
            componentStart = componentEnd;
        }
        if ((componentEnd = this.findQuery(componentStart)) != componentStart) {
            ++componentStart;
        }
        if ((query = this.extractComponent(componentStart, componentEnd)).length() != 0) {
            componentStart = componentEnd;
        }
        if ((componentEnd = this.findFragment(componentStart)) != componentStart) {
            ++componentStart;
        }
        String fragment = this.extractComponent(componentStart, componentEnd);
        return new Components(scheme, authority, path, query, fragment);
    }

    private @UnknownKeyFor @NonNull @Initialized int findScheme(@UnknownKeyFor @NonNull @Initialized int start) {
        char c;
        int pos = start;
        int length = this.source.length();
        String noSchemeOn = "/?#";
        String schemeStopOn = ":";
        for (int i = pos; i < length && noSchemeOn.indexOf(c = this.source.charAt(i)) < 0; ++i) {
            if (schemeStopOn.indexOf(c) < 0) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private @UnknownKeyFor @NonNull @Initialized int findAuthority(@UnknownKeyFor @NonNull @Initialized int start) {
        char c;
        int pos = start;
        int length = this.source.length();
        if (pos >= length) {
            return pos;
        }
        if (length <= 3) {
            return pos;
        }
        String authorityStart = this.source.substring(pos, pos + 2);
        if (!authorityStart.equals("//")) {
            return pos;
        }
        String authorityStopOn = "/?#";
        for (int i = pos += 2; i < length && authorityStopOn.indexOf(c = this.source.charAt(i)) < 0; ++i) {
            ++pos;
        }
        return pos;
    }

    private @UnknownKeyFor @NonNull @Initialized int findPath(@UnknownKeyFor @NonNull @Initialized int start) {
        char c;
        int pos = start;
        int length = this.source.length();
        if (pos >= length) {
            return pos;
        }
        String pathStopOn = "?#";
        for (int i = pos; i < length && pathStopOn.indexOf(c = this.source.charAt(i)) < 0; ++i) {
            ++pos;
        }
        return pos;
    }

    private @UnknownKeyFor @NonNull @Initialized int findQuery(@UnknownKeyFor @NonNull @Initialized int start) {
        char c;
        int pos = start;
        int length = this.source.length();
        if (pos >= length) {
            return pos;
        }
        String queryStart = this.source.substring(pos, pos + 1);
        if (!queryStart.equals("?")) {
            return pos;
        }
        String pathStopOn = "#";
        for (int i = ++pos; i < length && pathStopOn.indexOf(c = this.source.charAt(i)) < 0; ++i) {
            ++pos;
        }
        return pos;
    }

    private @UnknownKeyFor @NonNull @Initialized int findFragment(@UnknownKeyFor @NonNull @Initialized int start) {
        int pos = start;
        int length = this.source.length();
        if (pos >= length) {
            return pos;
        }
        String queryStart = this.source.substring(pos, pos + 1);
        if (!queryStart.equals("#")) {
            return pos;
        }
        for (int i = ++pos; i < length; ++i) {
            ++pos;
        }
        return pos;
    }

    private @UnknownKeyFor @NonNull @Initialized String extractComponent(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end) {
        return this.source.substring(start, end);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isUnreserved(@UnknownKeyFor @NonNull @Initialized int c) {
        return this.isLetter(c) || this.isNumber(c) || c == 45 || c == 46 || c == 95 || c == 126;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isSubDelim(@UnknownKeyFor @NonNull @Initialized int c) {
        return c == 33 || c == 36 || c == 38 || c == 39 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 59 || c == 61;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isSchemeChar(@UnknownKeyFor @NonNull @Initialized int c) {
        return this.isLetter(c) || this.isNumber(c) || c == 43 || c == 45 || c == 46;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNumber(@UnknownKeyFor @NonNull @Initialized int c) {
        return c >= 48 && c <= 57;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isLetter(@UnknownKeyFor @NonNull @Initialized int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private static class Components {
        private final @UnknownKeyFor @NonNull @Initialized String scheme;
        private final @UnknownKeyFor @NonNull @Initialized String authority;
        private final @UnknownKeyFor @NonNull @Initialized String path;
        private final @UnknownKeyFor @NonNull @Initialized String query;
        private final @UnknownKeyFor @NonNull @Initialized String fragment;

        public Components(@UnknownKeyFor @NonNull @Initialized String scheme, @UnknownKeyFor @NonNull @Initialized String authority, @UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized String fragment) {
            this.scheme = scheme;
            this.authority = authority;
            this.path = path;
            this.query = query;
            this.fragment = fragment;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean isRelative() {
            return this.scheme.length() == 0;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasAuthority() {
            return this.authority.length() > 0;
        }
    }

    private static class ValidatorException
    extends RuntimeException {
        private ValidatorException() {
        }
    }
}

