/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.Document;
import io.openapiprocessor.jsonschema.support.Copy;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DocumentStore {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Document> documents = new HashMap<URI, Document>();

    public void addId(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Object document) {
        this.documents.put(uri, new Document(document, Document.Source.ID));
    }

    public void addAnchor(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Object document) {
        this.documents.put(uri, new Document(document, Document.Source.ANCHOR));
    }

    public void addDynamicAnchor(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Object document) {
        this.documents.put(uri, new Document(document, Document.Source.DYNAMIC_ANCHOR));
    }

    public @Nullable @UnknownKeyFor @Initialized Document getDocument(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return this.documents.get(uri);
    }

    public @Nullable @UnknownKeyFor @Initialized Object get(@UnknownKeyFor @NonNull @Initialized URI uri) {
        Document document = this.documents.get(uri);
        if (document == null && uri.getFragment() == null) {
            URI resolved = uri.resolve("#");
            document = this.documents.get(resolved);
        }
        if (document == null) {
            return null;
        }
        return document.getDocument();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.documents.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized URI uri) {
        return this.documents.containsKey(uri);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Document> getDocuments() {
        return this.documents;
    }

    public @UnknownKeyFor @NonNull @Initialized DocumentStore copy() {
        DocumentStore store = new DocumentStore();
        this.documents.forEach((key, value) -> store.documents.put((URI)key, new Document(Copy.deep(value.getDocument()), value.getSource())));
        return store;
    }
}

