/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.Reference;
import io.openapiprocessor.jsonschema.schema.ReferenceRegistry;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import io.openapiprocessor.jsonschema.support.Uris;
import java.net.URI;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonSchemaContext {
    private final @UnknownKeyFor @NonNull @Initialized Scope scope;
    private final @UnknownKeyFor @NonNull @Initialized ReferenceRegistry references;
    private final @UnknownKeyFor @NonNull @Initialized Vocabularies vocabularies;

    public JsonSchemaContext(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized ReferenceRegistry references) {
        this.scope = scope;
        this.references = references;
        this.vocabularies = Vocabularies.ALL;
    }

    public JsonSchemaContext(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized ReferenceRegistry references, @UnknownKeyFor @NonNull @Initialized Vocabularies vocabularies) {
        this.scope = scope;
        this.references = references;
        this.vocabularies = vocabularies;
    }

    public @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.scope;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaVersion getVersion() {
        return this.scope.getVersion();
    }

    public @UnknownKeyFor @NonNull @Initialized Vocabularies getVocabularies() {
        return this.vocabularies;
    }

    public @UnknownKeyFor @NonNull @Initialized Reference getReference(@UnknownKeyFor @NonNull @Initialized URI ref) {
        if (ref.isAbsolute()) {
            return this.references.getReference(ref);
        }
        URI refId = Uris.resolve(this.scope.getBaseUri(), ref);
        if (this.references.hasReference(refId)) {
            return this.references.getReference(refId);
        }
        URI refLocal = Uris.resolve(this.scope.getBaseUri(), ref);
        return this.references.getReference(refLocal);
    }

    public @UnknownKeyFor @NonNull @Initialized Reference getDynamicReference(@UnknownKeyFor @NonNull @Initialized URI ref, @UnknownKeyFor @NonNull @Initialized URI dynamicScope) {
        URI resolved = dynamicScope.resolve(ref);
        return this.references.getDynamicReference(resolved);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasDynamicReference(@UnknownKeyFor @NonNull @Initialized String dynamicAnchor) {
        URI anchorUri = Uris.resolve(this.scope.getBaseUri(), dynamicAnchor);
        return this.references.hasDynamicReference(anchorUri);
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchemaContext withScope(@UnknownKeyFor @NonNull @Initialized Scope targetScope) {
        return new JsonSchemaContext(targetScope, this.references, this.vocabularies);
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchemaContext withId(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        return new JsonSchemaContext(this.scope.move(properties), this.references, this.vocabularies);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean refAllowsSiblings() {
        return this.scope.getVersion().validatesRefSiblings();
    }
}

