/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.Ref;
import io.openapiprocessor.jsonschema.schema.RefValue;
import io.openapiprocessor.jsonschema.schema.Scope;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Reference {
    private final @UnknownKeyFor @NonNull @Initialized Ref ref;
    private final @UnknownKeyFor @NonNull @Initialized RefValue value;

    public Reference(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized RefValue value) {
        this.ref = ref;
        this.value = value;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getDocumentUri() {
        return this.ref.getDocumentUri();
    }

    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteRefUri() {
        return this.ref.getAbsoluteUri();
    }

    public @UnknownKeyFor @NonNull @Initialized String getRefValue() {
        return this.ref.getRef();
    }

    public @UnknownKeyFor @NonNull @Initialized Scope getValueScope() {
        return this.value.getScope();
    }

    public @Nullable @UnknownKeyFor @Initialized Object getRawValue() {
        return this.value.getValue();
    }

    public <T> @Nullable T getValue() {
        return (T)this.value.getValue();
    }

    public @UnknownKeyFor @NonNull @Initialized JsonPointer getPointer() {
        return JsonPointer.from(this.ref.getPointer());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.ref.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String createRefRelative(@UnknownKeyFor @NonNull @Initialized String ref) {
        int hash = ref.indexOf("#");
        if (hash != -1) {
            return ref.substring(hash + 1);
        }
        return "";
    }
}

