/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.BooleanConverter;
import io.openapiprocessor.jsonschema.converter.StringNullableConverter;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.Keyword;
import io.openapiprocessor.jsonschema.schema.Ref;
import io.openapiprocessor.jsonschema.schema.ResolverContext;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Types;
import java.net.URI;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ResolverId {
    private final @UnknownKeyFor @NonNull @Initialized ResolverContext context;

    public ResolverId(@UnknownKeyFor @NonNull @Initialized ResolverContext context) {
        this.context = context;
    }

    public void resolve(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        this.resolveId(bucket);
        this.walkBucket(bucket);
    }

    private void walkBucket(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        URI currentId = this.getId(bucket);
        this.registerId(currentId, bucket);
        this.resolveId(bucket);
        URI currentAnchor = this.getAnchor(bucket);
        this.registerAnchor(currentAnchor, bucket);
        this.resolveAnchor(currentAnchor, bucket);
        URI recursiveAnchor = this.getRecursiveAnchor(bucket);
        this.registerDynamicAnchor(recursiveAnchor, bucket);
        this.resolveDynamicAnchor(recursiveAnchor, bucket);
        URI dynamicAnchor = this.getDynamicAnchor(bucket);
        this.registerDynamicAnchor(dynamicAnchor, bucket);
        this.resolveDynamicAnchor(dynamicAnchor, bucket);
        Scope scope = bucket.getScope();
        JsonPointer location = bucket.getLocation();
        SchemaVersion version = scope.getVersion();
        bucket.forEach((name, value) -> {
            boolean navigable;
            JsonPointer propLocation = location.append((String)name);
            Keyword keyword = version.getKeyword((String)name);
            boolean bl = navigable = keyword != null && keyword.isNavigable();
            if (navigable && keyword.isSchema() && Types.isObject(value)) {
                this.walkSchema(scope, value, propLocation);
            } else if (navigable && keyword.isSchemaArray() && Types.isArray(value)) {
                this.walkSchemaArray(scope, value, propLocation);
            } else if (navigable && keyword.isSchemaMap()) {
                this.walkSchemaMap(scope, value, propLocation);
            }
        });
    }

    private void walkSchema(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope scope = currentScope.move(value);
        Bucket bucket = Bucket.createBucket(scope, value, location);
        if (bucket == null) {
            return;
        }
        this.walkBucket(bucket);
    }

    private void walkSchemaArray(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Collection items = Types.asArray(value);
        if (items == null) {
            return;
        }
        int index = 0;
        for (Object item : items) {
            JsonPointer itemLocation = location.append(index);
            this.walkSchema(currentScope, item, itemLocation);
            ++index;
        }
    }

    private void walkSchemaMap(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope targetScope = currentScope.move(value);
        Bucket bucket = Bucket.createBucket(targetScope, value, location);
        if (bucket == null) {
            return;
        }
        bucket.forEach((propName, propValue) -> {
            JsonPointer propLocation = location.append((String)propName);
            this.walkSchema(targetScope, propValue, propLocation);
        });
    }

    private @Nullable @UnknownKeyFor @Initialized URI getId(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        return bucket.getId();
    }

    private void registerId(@Nullable @UnknownKeyFor @Initialized URI id, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        if (id == null) {
            return;
        }
        this.context.addId(bucket.getBaseUri(), bucket.getRawValues());
    }

    private @Nullable @UnknownKeyFor @Initialized URI getAnchor(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        String anchor = bucket.convert("$anchor", new StringNullableConverter());
        if (anchor == null) {
            return null;
        }
        return bucket.getScope().resolveAnchor(anchor);
    }

    private void registerAnchor(@Nullable @UnknownKeyFor @Initialized URI anchor, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        if (anchor == null) {
            return;
        }
        this.context.addAnchor(anchor, bucket.getRawValues());
    }

    private @Nullable @UnknownKeyFor @Initialized URI getRecursiveAnchor(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        Boolean anchor = bucket.convert("$recursiveAnchor", new BooleanConverter());
        if (anchor == null || !anchor.booleanValue()) {
            return null;
        }
        return bucket.getScope().resolveAnchor("");
    }

    private @Nullable @UnknownKeyFor @Initialized URI getDynamicAnchor(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        String anchor = bucket.convert("$dynamicAnchor", new StringNullableConverter());
        if (anchor == null) {
            return null;
        }
        return bucket.getScope().resolveAnchor(anchor);
    }

    private void registerDynamicAnchor(@Nullable @UnknownKeyFor @Initialized URI anchor, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        if (anchor == null) {
            return;
        }
        this.context.addDynamicAnchor(anchor, bucket.getRawValues());
    }

    private void resolve(@Nullable @UnknownKeyFor @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        if (uri == null) {
            return;
        }
        this.context.addRef(new Ref(bucket.getScope(), uri), bucket.getRawValues());
    }

    private void resolveAnchor(@Nullable @UnknownKeyFor @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        if (uri == null) {
            return;
        }
        this.context.addRef(new Ref(bucket.getScope(), uri), bucket.getRawValues());
    }

    private void resolveDynamicAnchor(@Nullable @UnknownKeyFor @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        if (uri == null) {
            return;
        }
        this.context.addDynamicAnchorRef(new Ref(bucket.getScope(), uri), bucket.getRawValues());
    }

    private void resolveId(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        this.context.addRef(new Ref(bucket.getScope(), bucket.getBaseUri()), bucket.getRawValues());
    }
}

