/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.array;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaBoolean;
import io.openapiprocessor.jsonschema.schema.JsonSchemaObject;
import io.openapiprocessor.jsonschema.schema.JsonSchemas;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.array.ItemsStep;
import io.openapiprocessor.jsonschema.validator.steps.SchemaStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Items {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public Items(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        ItemsStep itemsStep = new ItemsStep(schema, instance, "items");
        ItemsStep additionalItemsStep = new ItemsStep(schema, instance, "additionalItems");
        ItemsStep unevaluatedItemsStep = new ItemsStep(schema, instance, "unevaluatedItems");
        Integer itemsAnnotation = null;
        Boolean additionalItemsAnnotation = null;
        Boolean unevaluatedItemsAnnotation = null;
        int instanceSize = instance.getArraySize();
        JsonSchemas items = schema.getItems();
        if (items.isSingle()) {
            JsonSchema itemsSchema = items.getSchema();
            IntStream.range(0, instanceSize).forEach(idx -> {
                JsonInstance value = instance.getValue(idx);
                this.validator.validate(itemsSchema, value, dynamicScope, itemsStep);
            });
            itemsAnnotation = instanceSize;
        } else if (items.isArray()) {
            Iterator<JsonSchema> itemSchemas;
            JsonSchemas additional = schema.getAdditionalItems();
            if (additional.isEmpty()) {
                itemSchemas = items.getSchemas().iterator();
                int maxIdx = instanceSize;
                if (maxIdx > items.size()) {
                    maxIdx = items.size();
                }
                IntStream.range(0, maxIdx).forEach(idx -> {
                    JsonInstance value = instance.getValue(idx);
                    if (idx < items.size()) {
                        JsonSchema idxSchema = (JsonSchema)itemSchemas.next();
                        SchemaStep idxStep = new SchemaStep(idxSchema, instance);
                        this.validator.validate(idxSchema, value, dynamicScope, idxStep);
                        itemsStep.add(idxStep);
                    }
                });
                itemsAnnotation = maxIdx;
            } else if (additional.isSingle()) {
                itemSchemas = items.getSchemas().iterator();
                JsonSchema additionalSchema = additional.getSchema();
                AtomicInteger cntItem = new AtomicInteger();
                AtomicInteger cntAdditionalItem = new AtomicInteger();
                IntStream.range(0, instanceSize).forEach(idx -> {
                    JsonInstance value = instance.getValue(idx);
                    if (idx < items.size()) {
                        JsonSchema idxSchema = (JsonSchema)itemSchemas.next();
                        SchemaStep idxStep = new SchemaStep(idxSchema, value);
                        this.validator.validate(idxSchema, value, dynamicScope, idxStep);
                        itemsStep.add(idxStep);
                        cntItem.getAndIncrement();
                    } else {
                        SchemaStep idxStep = new SchemaStep(additionalSchema, value);
                        this.validator.validate(additionalSchema, value, dynamicScope, idxStep);
                        additionalItemsStep.add(idxStep);
                        cntAdditionalItem.getAndIncrement();
                    }
                });
                itemsAnnotation = cntItem.get();
                additionalItemsAnnotation = cntAdditionalItem.get() > 0;
            }
        }
        JsonSchema unevaluatedSchema = schema.getUnevaluatedItems();
        if (unevaluatedSchema != null) {
            Integer allItemsAnnotation = this.reduceItemsAnnotations(itemsAnnotation, parentStep, instanceSize);
            Boolean allAdditionalItemsAnnotations = this.reduceAdditionalItemsAnnotations(additionalItemsAnnotation, parentStep);
            Boolean allUnevaluatedItemsAnnotations = this.reduceUnevaluatedItemsAnnotations(unevaluatedItemsAnnotation, parentStep);
            AtomicInteger cntUnevaluatedItems = new AtomicInteger();
            if (allItemsAnnotation != null && instanceSize > allItemsAnnotation && allAdditionalItemsAnnotations == null && allUnevaluatedItemsAnnotations == null) {
                IntStream.range(allItemsAnnotation, instanceSize).forEach(idx -> {
                    JsonInstance value = instance.getValue(idx);
                    this.validator.validate(unevaluatedSchema, value, dynamicScope, unevaluatedItemsStep);
                    cntUnevaluatedItems.getAndIncrement();
                });
            } else if (allItemsAnnotation == null && allAdditionalItemsAnnotations == null && allUnevaluatedItemsAnnotations == null) {
                IntStream.range(0, instanceSize).forEach(idx -> {
                    JsonInstance value = instance.getValue(idx);
                    this.validator.validate(unevaluatedSchema, value, dynamicScope, unevaluatedItemsStep);
                    cntUnevaluatedItems.getAndIncrement();
                });
            }
            if (cntUnevaluatedItems.get() > 0) {
                unevaluatedItemsAnnotation = true;
            }
        }
        if (itemsAnnotation != null) {
            if (itemsAnnotation == instanceSize) {
                itemsStep.addAnnotation(true);
            } else {
                itemsStep.addAnnotation(itemsAnnotation);
            }
        }
        if (additionalItemsAnnotation != null) {
            additionalItemsStep.addAnnotation(additionalItemsAnnotation);
        }
        if (unevaluatedItemsAnnotation != null) {
            unevaluatedItemsStep.addAnnotation(unevaluatedItemsAnnotation);
        }
        if (itemsStep.isNotEmpty()) {
            parentStep.add(itemsStep);
        }
        if (additionalItemsStep.isNotEmpty()) {
            parentStep.add(additionalItemsStep);
        }
        if (unevaluatedItemsStep.isNotEmpty()) {
            parentStep.add(unevaluatedItemsStep);
        }
    }

    private @Nullable @UnknownKeyFor @Initialized Integer reduceItemsAnnotations(@Nullable @UnknownKeyFor @Initialized Integer currentItemsAnnotation, @UnknownKeyFor @NonNull @Initialized ValidationStep step, @UnknownKeyFor @NonNull @Initialized int instanceSize) {
        Collection<Annotation> otherAnnotations = step.getAnnotations("items");
        Integer reducedAnnotation = currentItemsAnnotation;
        if (!otherAnnotations.isEmpty()) {
            List booleanItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Boolean.class)).map(Annotation::asBoolean).collect(Collectors.toList());
            List integerItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Integer.class)).map(Annotation::asInteger).collect(Collectors.toList());
            if (currentItemsAnnotation != null) {
                if (currentItemsAnnotation == instanceSize) {
                    booleanItemsAnnotations.add(true);
                } else {
                    integerItemsAnnotations.add(currentItemsAnnotation);
                }
            }
            if (!booleanItemsAnnotations.isEmpty()) {
                boolean reduced = booleanItemsAnnotations.stream().reduce(false, (current, annotation) -> {
                    current = current | annotation;
                    return current;
                });
                if (reduced) {
                    reducedAnnotation = instanceSize;
                }
            } else {
                reducedAnnotation = integerItemsAnnotations.stream().reduce(0, Math::max);
            }
        }
        return reducedAnnotation;
    }

    private @Nullable @UnknownKeyFor @Initialized Boolean reduceAdditionalItemsAnnotations(@Nullable @UnknownKeyFor @Initialized Boolean currentAdditionalItemsAnnotation, @UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        Collection<Annotation> otherAnnotations = step.getAnnotations("additionalItems");
        Boolean reducedAnnotation = currentAdditionalItemsAnnotation;
        if (!otherAnnotations.isEmpty()) {
            List additionalItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Boolean.class)).map(Annotation::asBoolean).collect(Collectors.toList());
            if (currentAdditionalItemsAnnotation != null) {
                additionalItemsAnnotations.add(currentAdditionalItemsAnnotation);
            }
            reducedAnnotation = additionalItemsAnnotations.stream().reduce(false, (current, annotation) -> {
                current = current | annotation;
                return current;
            });
        }
        return reducedAnnotation;
    }

    private @Nullable @UnknownKeyFor @Initialized Boolean reduceUnevaluatedItemsAnnotations(@Nullable @UnknownKeyFor @Initialized Boolean currentUnevaluatedItemsAnnotation, @UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        Collection<Annotation> otherAnnotations = step.getAnnotations("unevaluatedItems");
        Boolean reducedAnnotation = currentUnevaluatedItemsAnnotation;
        if (!otherAnnotations.isEmpty()) {
            List unevaluatedItemsAnnotations = otherAnnotations.stream().filter(a -> a.is(Boolean.class)).map(Annotation::asBoolean).collect(Collectors.toList());
            if (currentUnevaluatedItemsAnnotation != null) {
                unevaluatedItemsAnnotations.add(currentUnevaluatedItemsAnnotation);
            }
            reducedAnnotation = unevaluatedItemsAnnotations.stream().reduce(false, (current, annotation) -> {
                current = current | annotation;
                return current;
            });
        }
        return reducedAnnotation;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isBooleanFalse(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema instanceof JsonSchemaBoolean && schema.isFalse();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isObject(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema instanceof JsonSchemaObject;
    }
}

