/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.conditional;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.conditional.DependentSchemaStep;
import io.openapiprocessor.jsonschema.validator.conditional.DependentSchemasStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DependentSchemas {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public DependentSchemas(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Map<String, JsonSchema> schemas = schema.getDependentSchemas();
        if (schemas == null) {
            return;
        }
        DependentSchemasStep step = new DependentSchemasStep(schema, instance);
        Map<String, Object> instanceObject = Null.nonNull(instance.asObject());
        instanceObject.keySet().forEach(propName -> {
            JsonSchema propSchema = (JsonSchema)schemas.get(propName);
            if (propSchema == null) {
                return;
            }
            DependentSchemaStep depStep = new DependentSchemaStep(propSchema, instance);
            this.validator.validate(propSchema, instance, dynamicScope, depStep);
            step.add(depStep);
        });
        parentStep.add(step);
    }
}

