/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.object.DependenciesStep;
import io.openapiprocessor.jsonschema.validator.object.DependencyStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DependentRequired {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        DependenciesStep step = new DependenciesStep(schema, instance);
        if (!this.shouldValidate(schema)) {
            return;
        }
        Map<String, Set<String>> required = schema.getDependentRequired();
        if (required == null) {
            return;
        }
        Map<String, Object> instanceObject = Null.nonNull(instance.asObject());
        instanceObject.keySet().forEach(propName -> {
            Set requiredProperties = (Set)required.get(propName);
            if (requiredProperties != null) {
                HashSet instanceProperties = new HashSet(instanceObject.keySet());
                requiredProperties.forEach(p -> {
                    if (!instanceProperties.contains(p)) {
                        DependencyStep depStep = new DependencyStep(schema, instance, (String)p);
                        depStep.setInvalid();
                        step.add(depStep);
                    }
                });
            }
        });
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema.getContext().getVersion().getKeyword(Keywords.DEPENDENT_REQUIRED) != null;
    }
}

