/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.steps.Step;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PropertiesStep
implements ValidationStep {
    protected final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;
    protected final @UnknownKeyFor @NonNull @Initialized JsonInstance instance;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> steps = new ArrayList<ValidationStep>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Annotation> annotations = new HashMap<String, Annotation>();

    public PropertiesStep(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        this.schema = schema;
        this.instance = instance;
        this.propertyName = propertyName;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.steps.isEmpty();
    }

    @Override
    public void add(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        this.steps.add(step);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> getSteps() {
        return this.steps;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized ValidationMessage getMessage() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isValid() {
        return this.steps.stream().allMatch(ValidationStep::isValid);
    }

    public void addAnnotation(@UnknownKeyFor @NonNull @Initialized Object value) {
        this.annotations.put(this.propertyName, new Annotation(this.propertyName, value));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Annotation getAnnotation() {
        return this.annotations.get(this.propertyName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Annotation> getAnnotations(@Nullable @UnknownKeyFor @Initialized String keyword) {
        if (keyword == null) {
            return Collections.emptyList();
        }
        Annotation annotation = this.annotations.get(keyword);
        if (annotation == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(annotation);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getInstanceLocation() {
        return this.instance.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getKeywordLocation() {
        return this.schema.getLocation().append(this.propertyName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation() {
        return Step.getAbsoluteKeywordLocation(this.getScope(), this.getKeywordLocation());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Step.toString(this.getKeywordLocation(), this.getInstanceLocation(), this.isValid());
    }

    private @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.schema.getContext().getScope();
    }
}

