/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.steps;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.steps.CompositeStep;
import io.openapiprocessor.jsonschema.validator.steps.Step;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class DynamicRefStep
extends CompositeStep {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;
    protected final @UnknownKeyFor @NonNull @Initialized JsonInstance instance;
    private final @UnknownKeyFor @NonNull @Initialized String keyword;

    public DynamicRefStep(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        this.schema = schema;
        this.instance = instance;
        this.keyword = DynamicRefStep.isDraft201909(schema) ? Keywords.RECURSIVE_REF : Keywords.DYNAMIC_REF;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getInstanceLocation() {
        return this.instance.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getKeywordLocation() {
        return this.schema.getLocation().append(this.keyword);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation() {
        return Step.getAbsoluteKeywordLocation(this.getScope(), this.getKeywordLocation());
    }

    public @UnknownKeyFor @NonNull @Initialized URI getRef() {
        return Null.nonNull(this.schema.getDynamicRef());
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Step.toString(this.getKeywordLocation(), this.getInstanceLocation(), this.isValid());
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isDraft201909(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return SchemaVersion.Draft201909.equals((Object)schema.getContext().getVersion());
    }

    private @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.schema.getContext().getScope();
    }
}

