/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.UriStep;
import io.openapiprocessor.jsonschema.validator.support.UriValidator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Uri {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public Uri(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Format format = Format.of(schema.getFormat());
        if (format == null || !this.supportsFormat(format)) {
            return;
        }
        UriStep step = new UriStep(schema, instance);
        parentStep.add(step);
        if (!this.shouldValidate(schema)) {
            return;
        }
        String instanceValue = this.getInstanceValue(instance);
        boolean valid = new UriValidator(instanceValue).validateAbsolute();
        if (!valid) {
            step.setInvalid();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        boolean shouldAssert = schema.getContext().getVocabularies().requiresFormatAssertion();
        if (!shouldAssert) {
            shouldAssert = this.settings.assertFormat();
        }
        return shouldAssert;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean supportsFormat(@UnknownKeyFor @NonNull @Initialized Format format) {
        return Format.URI.equals((Object)format);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asString());
    }
}

