/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.support;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Equals {
    public static @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object left, @Nullable @UnknownKeyFor @Initialized Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return Equals.equalsBoolean((Boolean)left, (Boolean)right);
        }
        if (left instanceof String && right instanceof String) {
            return Equals.equalsString((String)left, (String)right);
        }
        if (left instanceof Number && right instanceof Number) {
            return Equals.equalsNumber((Number)left, (Number)right);
        }
        if (left instanceof Collection && right instanceof Collection) {
            return Equals.equalsArray((Collection)left, (Collection)right);
        }
        if (left instanceof Map && right instanceof Map) {
            return Equals.equalsObject((Map)left, (Map)right);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean equalsBoolean(@UnknownKeyFor @NonNull @Initialized Boolean left, @UnknownKeyFor @NonNull @Initialized Boolean right) {
        return Objects.equals(left, right);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean equalsString(@UnknownKeyFor @NonNull @Initialized String left, @UnknownKeyFor @NonNull @Initialized String right) {
        return Objects.equals(left, right);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean equalsNumber(@UnknownKeyFor @NonNull @Initialized Number left, @UnknownKeyFor @NonNull @Initialized Number right) {
        BigDecimal r;
        BigDecimal l = new BigDecimal(left.toString());
        return l.compareTo(r = new BigDecimal(right.toString())) == 0;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean equalsArray(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> left, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> right) {
        if (left.size() != right.size()) {
            return false;
        }
        Iterator<Object> r = right.iterator();
        for (Object l : left) {
            if (Equals.equals(l, r.next())) continue;
            return false;
        }
        return true;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean equalsObject(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> left, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (String key : left.keySet()) {
            Object rv;
            if (!right.containsKey(key)) {
                return false;
            }
            Object lv = left.get(key);
            if (Equals.equals(lv, rv = right.get(key))) continue;
            return false;
        }
        return true;
    }
}

