/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser;

import io.openapiparser.converter.PropertyConverter;
import io.openapiparser.converter.StringNullableConverter;
import io.openapiparser.schema.Bucket;
import io.openapiparser.schema.JsonInstanceContext;
import io.openapiparser.schema.Reference;
import io.openapiparser.schema.ReferenceRegistry;
import io.openapiparser.schema.SchemaVersion;
import io.openapiparser.schema.UriSupport;
import java.net.URI;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Context {
    private final @UnknownKeyFor @NonNull @Initialized URI scope;
    private final @UnknownKeyFor @NonNull @Initialized ReferenceRegistry references;
    private final @UnknownKeyFor @NonNull @Initialized SchemaVersion version;

    public Context(@UnknownKeyFor @NonNull @Initialized URI scope, @UnknownKeyFor @NonNull @Initialized ReferenceRegistry references) {
        this.scope = scope;
        this.references = references;
        this.version = SchemaVersion.Draft4;
    }

    public @UnknownKeyFor @NonNull @Initialized Reference getReference(@UnknownKeyFor @NonNull @Initialized URI ref) {
        URI resolved = this.scope.resolve(ref);
        return this.references.getRef(resolved);
    }

    public @Nullable @UnknownKeyFor @Initialized Bucket getRefObjectOrNull(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        String ref = (String)bucket.convert("$ref", (PropertyConverter)new StringNullableConverter());
        if (ref == null) {
            return null;
        }
        return this.getRefObject(ref);
    }

    public @UnknownKeyFor @NonNull @Initialized Bucket getRefObjectOrThrow(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        Bucket refObject = this.getRefObjectOrNull(bucket);
        if (refObject == null) {
            throw new RuntimeException();
        }
        return refObject;
    }

    public @UnknownKeyFor @NonNull @Initialized JsonInstanceContext getInstanceContext() {
        return new JsonInstanceContext(this.scope, this.references);
    }

    private @Nullable @UnknownKeyFor @Initialized Bucket getRefObject(@UnknownKeyFor @NonNull @Initialized String ref) {
        Reference reference = this.getReference(UriSupport.createUri((String)ref));
        Context refContext = this.withScope(reference.getValueScope());
        Map value = (Map)reference.getValue();
        if (value == null) {
            return null;
        }
        return new Bucket(refContext.withId(value), reference.getPointer(), value);
    }

    public @UnknownKeyFor @NonNull @Initialized Context withScope(@Nullable @UnknownKeyFor @Initialized URI targetScope) {
        if (targetScope == null) {
            return this;
        }
        return new Context(this.scope.resolve(targetScope), this.references);
    }

    public @UnknownKeyFor @NonNull @Initialized URI withId(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        String id = this.version.getIdProvider().getId(properties);
        if (id == null) {
            return this.scope;
        }
        return this.withId(id);
    }

    public @UnknownKeyFor @NonNull @Initialized URI withId(@Nullable @UnknownKeyFor @Initialized String id) {
        if (id == null) {
            return this.scope;
        }
        return this.scope.resolve(id);
    }
}

