/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser;

import io.openapiparser.Context;
import io.openapiparser.OpenApiResult;
import io.openapiparser.OpenApiResult30;
import io.openapiparser.OpenApiResult31;
import io.openapiparser.ParserException;
import io.openapiparser.UnknownVersionException;
import io.openapiparser.converter.PropertyConverter;
import io.openapiparser.converter.StringNotNullConverter;
import io.openapiparser.converter.Types;
import io.openapiparser.schema.Bucket;
import io.openapiparser.schema.Resolver;
import io.openapiparser.schema.ResolverResult;
import io.openapiparser.support.Nullness;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OpenApiParser {
    private final @UnknownKeyFor @NonNull @Initialized Resolver resolver;

    public OpenApiParser(@UnknownKeyFor @NonNull @Initialized Resolver resolver) {
        this.resolver = resolver;
    }

    public @UnknownKeyFor @NonNull @Initialized OpenApiResult parse(@UnknownKeyFor @NonNull @Initialized URI baseUri) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            return this.createResult(this.resolver.resolve(baseUri));
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized OpenApiResult parse(@UnknownKeyFor @NonNull @Initialized String resource) {
        try {
            return this.createResult(this.resolver.resolve(resource));
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized OpenApiResult createResult(@UnknownKeyFor @NonNull @Initialized ResolverResult result) {
        Object document = result.getDocument();
        Bucket api = new Bucket(result.getUri(), Types.asMap((Object)document));
        String version = this.getVersion(api);
        if (this.isVersion30(version)) {
            return new OpenApiResult30(new Context(result.getUri(), result.getRegistry()), api);
        }
        if (this.isVersion31(version)) {
            return new OpenApiResult31(new Context(result.getUri(), result.getRegistry()), api);
        }
        throw new UnknownVersionException(version);
    }

    private @UnknownKeyFor @NonNull @Initialized String getVersion(@UnknownKeyFor @NonNull @Initialized Bucket api) {
        return (String)Nullness.nonNull((Object)((String)api.convert("openapi", (PropertyConverter)new StringNotNullConverter())));
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVersion30(@UnknownKeyFor @NonNull @Initialized String version) {
        return this.checkVersion(version, "3.0");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVersion31(@UnknownKeyFor @NonNull @Initialized String version) {
        return this.checkVersion(version, "3.1");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkVersion(@UnknownKeyFor @NonNull @Initialized String version, @UnknownKeyFor @NonNull @Initialized String prefix) {
        return version.startsWith(prefix);
    }
}

