/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.converter;

import io.openapiparser.Factory;
import io.openapiparser.converter.ObjectNotNullConverter;
import io.openapiparser.converter.PropertiesConverter;
import io.openapiparser.schema.JsonPointer;
import io.openapiparser.support.Nullness;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapObjectsOrEmptySelfConverter<@UnknownKeyFor T>
implements PropertiesConverter<Map<String, T>> {
    private final @UnknownKeyFor @NonNull @Initialized ObjectNotNullConverter<T> converter;

    public MapObjectsOrEmptySelfConverter(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Factory<T> factory) {
        this.converter = new ObjectNotNullConverter<T>(uri, factory);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> convert(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties, @UnknownKeyFor @NonNull @Initialized String location) {
        LinkedHashMap objects = new LinkedHashMap();
        properties.forEach((property, value) -> objects.put(property, this.create((String)property, value, this.getLocation(location, (String)property))));
        return Collections.unmodifiableMap(objects);
    }

    private T create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object item, @UnknownKeyFor @NonNull @Initialized String location) {
        return (T)Nullness.nonNull(this.converter.convert(name, item, location));
    }

    private @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized String property) {
        return JsonPointer.from((String)location).getJsonPointer(property);
    }
}

